/* BackendS3.c generated by valac 0.12.0, the Vala compiler
 * generated from BackendS3.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gnome-keyring.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;
typedef struct _DejaDupBackendS3Private DejaDupBackendS3Private;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
typedef struct _DejaDupBackendS3GetEnvpData DejaDupBackendS3GetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, GError** error);
	gchar* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendS3 {
	DejaDupBackend parent_instance;
	DejaDupBackendS3Private * priv;
};

struct _DejaDupBackendS3Class {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendS3Private {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

struct _DejaDupBackendS3GetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendS3* self;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
};


static gpointer deja_dup_backend_s3_parent_class = NULL;

#define DEJA_DUP_S3_ROOT "S3"
#define DEJA_DUP_S3_ID_KEY "id"
#define DEJA_DUP_S3_BUCKET_KEY "bucket"
#define DEJA_DUP_S3_FOLDER_KEY "folder"
#define DEJA_DUP_S3_SERVER "s3.amazonaws.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_s3_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_S3_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Private))
enum  {
	DEJA_DUP_BACKEND_S3_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base);
DejaDupBackendS3* deja_dup_backend_s3_new (void);
DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type);
static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static gchar* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self);
static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_s3_real_get_icon (DejaDupBackend* base);
static gboolean deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, gchar** when);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static gchar* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
void deja_dup_simple_settings_set_string (DejaDupSimpleSettings* self, const gchar* k, const gchar* v);
gchar* deja_dup_get_folder_key (DejaDupSimpleSettings* settings, const gchar* key);
gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self);
static gchar* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* data);
static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self);
static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list);
static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self);
static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self);
static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val);
static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_s3_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendS3* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_backend_s3_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) base;
	if (mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("--s3-use-new-style");
		*argv = g_list_append (*argv, _tmp0_);
	}
}


static gchar* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_utf8_strdown (self->priv->id, (gssize) (-1));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("deja-dup-auto-%s", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	gboolean result = FALSE;
	self = (DejaDupBackendS3*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_s3_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, gchar** when) {
	DejaDupBackendS3 * self;
	gchar* _when = NULL;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_ = NULL;
	DejaDupNetwork* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = _ ("Backup will begin when a network connection becomes available.");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_when);
	_when = _tmp1_;
	_tmp2_ = deja_dup_network_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_network_get_connected (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
}


static gchar* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* bucket;
	gchar* _tmp2_ = NULL;
	gchar* default_bucket;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* folder;
	gchar* _tmp10_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_S3_BUCKET_KEY);
	bucket = _tmp1_;
	_tmp2_ = deja_dup_backend_s3_get_default_bucket (self);
	default_bucket = _tmp2_;
	if (bucket == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (bucket, "") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp6_ = g_str_has_prefix (bucket, "deja-dup-auto-");
		if (_tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = g_str_has_prefix (bucket, default_bucket);
			_tmp5_ = !_tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (default_bucket);
		_g_free0 (bucket);
		bucket = _tmp8_;
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_S3_BUCKET_KEY, bucket);
	}
	_tmp9_ = deja_dup_get_folder_key (settings, DEJA_DUP_S3_FOLDER_KEY);
	folder = _tmp9_;
	_tmp10_ = g_strdup_printf ("s3+http://%s/%s", bucket, folder);
	result = _tmp10_;
	_g_free0 (folder);
	_g_free0 (default_bucket);
	_g_free0 (bucket);
	_g_object_unref0 (settings);
	return result;
}


gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self) {
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* bucket;
	gboolean _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** bits;
	gint bits_length1;
	gint _bits_size_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_S3_BUCKET_KEY);
	bucket = _tmp1_;
	if (g_strcmp0 (bucket, "deja-dup") == 0) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = deja_dup_backend_s3_get_default_bucket (self);
		_g_free0 (bucket);
		bucket = _tmp2_;
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_S3_BUCKET_KEY, bucket);
		result = TRUE;
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp3_ = g_str_has_prefix (bucket, "deja-dup-auto-");
	if (!_tmp3_) {
		result = FALSE;
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp5_ = _tmp4_ = g_strsplit (bucket, "-", 0);
	bits = _tmp5_;
	bits_length1 = _vala_array_length (_tmp4_);
	_bits_size_ = _vala_array_length (_tmp4_);
	if (bits == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = bits[0] == NULL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = bits[1] == NULL;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = bits[2] == NULL;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = bits[3] == NULL;
	}
	if (_tmp6_) {
		result = FALSE;
		bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	if (bits[4] == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strconcat (bucket, "-2", NULL);
		_g_free0 (bucket);
		bucket = _tmp10_;
	} else {
		glong _tmp11_;
		glong num;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp11_ = atol (bits[4]);
		num = _tmp11_;
		_tmp12_ = g_strdup_printf ("%li", num + 1);
		_tmp13_ = _tmp12_;
		_g_free0 (bits[4]);
		bits[4] = _tmp13_;
		_tmp14_ = g_strjoinv ("-", bits);
		_g_free0 (bucket);
		bucket = _tmp14_;
	}
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_S3_BUCKET_KEY, bucket);
	result = TRUE;
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (bucket);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* folder;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = deja_dup_get_folder_key (settings, DEJA_DUP_S3_FOLDER_KEY);
	folder = _tmp1_;
	if (g_strcmp0 (folder, "") == 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = _ ("Amazon S3");
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		_g_free0 (folder);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("%s on Amazon S3");
		_tmp5_ = g_strdup_printf (_tmp4_, folder);
		result = _tmp5_;
		_g_free0 (folder);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (folder);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendS3GetEnvpData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendS3GetEnvpData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendS3 * self;
	DejaDupBackendS3GetEnvpData* _data_;
	self = (DejaDupBackendS3*) base;
	_data_ = g_slice_new0 (DejaDupBackendS3GetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_s3_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_s3_real_get_envp_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_backend_s3_real_get_envp_co (_data_);
}


static void deja_dup_backend_s3_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendS3GetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self) {
	deja_dup_backend_s3_found_password (self, _result_, list);
}


static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	data->settings = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_string ((GSettings*) data->settings, DEJA_DUP_S3_ID_KEY);
	_g_free0 (data->self->priv->settings_id);
	data->self->priv->settings_id = data->_tmp1_;
	if (data->self->priv->settings_id == NULL) {
		data->_tmp2_ = "";
	} else {
		data->_tmp2_ = data->self->priv->settings_id;
	}
	data->_tmp3_ = g_strdup (data->_tmp2_);
	_g_free0 (data->self->priv->id);
	data->self->priv->id = data->_tmp3_;
	if (g_strcmp0 (data->self->priv->id, "") != 0) {
		data->_tmp4_ = data->self->priv->secret_key != NULL;
	} else {
		data->_tmp4_ = FALSE;
	}
	if (data->_tmp4_) {
		deja_dup_backend_s3_got_secret_key (data->self);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (g_strcmp0 (data->self->priv->id, "") != 0) {
		_g_free0 (data->self->priv->secret_key);
		data->self->priv->secret_key = NULL;
		gnome_keyring_find_network_password (data->self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (data->self), g_object_unref);
	} else {
		deja_dup_backend_s3_ask_password (data->self);
	}
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (_result_ == GNOME_KEYRING_RESULT_OK) {
		_tmp0_ = list != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (((GnomeKeyringNetworkPasswordData*) list->data)->password);
		_g_free0 (self->priv->secret_key);
		self->priv->secret_key = _tmp1_;
		deja_dup_backend_s3_got_secret_key (self);
	} else {
		deja_dup_backend_s3_ask_password (self);
	}
}


static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self) {
	deja_dup_backend_s3_save_password_callback (self, _result_, val);
}


static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_) {
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GPasswordSave _tmp6_;
	GPasswordSave remember;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount_op != NULL);
	if (_result_ != G_MOUNT_OPERATION_HANDLED) {
		GList* _tmp0_;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = NULL;
		_tmp1_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp0_, _tmp1_);
		__g_list_free__g_free0_0 (_tmp0_);
		return;
	}
	_tmp2_ = g_mount_operation_get_username (mount_op);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->id);
	self->priv->id = _tmp3_;
	_tmp4_ = g_mount_operation_get_password (mount_op);
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->secret_key);
	self->priv->secret_key = _tmp5_;
	_tmp6_ = g_mount_operation_get_password_save (mount_op);
	remember = _tmp6_;
	if (remember != G_PASSWORD_SAVE_NEVER) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* where;
		if (remember == G_PASSWORD_SAVE_FOR_SESSION) {
			_tmp7_ = "session";
		} else {
			_tmp7_ = GNOME_KEYRING_DEFAULT;
		}
		_tmp8_ = g_strdup (_tmp7_);
		where = _tmp8_;
		gnome_keyring_set_network_password (where, self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, self->priv->secret_key, _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		_g_free0 (where);
	}
	deja_dup_backend_s3_got_secret_key (self);
}


static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_s3_got_password_reply (self, _sender, _result_);
}


static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self) {
	GMountOperation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GMountOperation* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GMountOperation* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMountOperation* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GMountOperation* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GMountOperation* _tmp12_ = NULL;
	GMountOperation* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _ ("You can sign up for an Amazon S3 account <a href=\"%s\">online</a>.");
	_tmp2_ = g_strdup_printf (_tmp1_, "http://aws.amazon.com/s3/");
	_tmp3_ = _tmp2_;
	g_object_set ((GObject*) _tmp0_, "label_help", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp5_ = _ ("_Access key ID:");
	g_object_set ((GObject*) _tmp4_, "label_username", _tmp5_, NULL);
	_tmp6_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp7_ = _ ("_Secret access key:");
	g_object_set ((GObject*) _tmp6_, "label_password", _tmp7_, NULL);
	_tmp8_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp9_ = _ ("S_how secret access key");
	g_object_set ((GObject*) _tmp8_, "label_show_password", _tmp9_, NULL);
	_tmp10_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp11_ = _ ("_Remember secret access key");
	g_object_set ((GObject*) _tmp10_, "label_remember_password", _tmp11_, NULL);
	_tmp12_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	g_signal_connect_object (_tmp12_, "reply", (GCallback) _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp13_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp14_ = _ ("Enter Amazon S3 access key");
	g_signal_emit_by_name (_tmp13_, "ask-password", _tmp14_, self->priv->id, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	GList* envp;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	if (g_strcmp0 (self->priv->id, self->priv->settings_id) != 0) {
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_S3_ID_KEY, self->priv->id);
	}
	envp = NULL;
	_tmp1_ = g_strdup_printf ("AWS_ACCESS_KEY_ID=%s", self->priv->id);
	envp = g_list_append (envp, _tmp1_);
	_tmp2_ = g_strdup_printf ("AWS_SECRET_ACCESS_KEY=%s", self->priv->secret_key);
	envp = g_list_append (envp, _tmp2_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_object_unref0 (settings);
}


DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type) {
	DejaDupBackendS3 * self = NULL;
	self = (DejaDupBackendS3*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendS3* deja_dup_backend_s3_new (void) {
	return deja_dup_backend_s3_construct (DEJA_DUP_TYPE_BACKEND_S3);
}


static void deja_dup_backend_s3_class_init (DejaDupBackendS3Class * klass) {
	deja_dup_backend_s3_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendS3Private));
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_s3_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_s3_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_s3_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->get_icon = deja_dup_backend_s3_real_get_icon;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_s3_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_s3_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_s3_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_s3_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp_finish = deja_dup_backend_s3_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_s3_finalize;
}


static void deja_dup_backend_s3_instance_init (DejaDupBackendS3 * self) {
	self->priv = DEJA_DUP_BACKEND_S3_GET_PRIVATE (self);
}


static void deja_dup_backend_s3_finalize (GObject* obj) {
	DejaDupBackendS3 * self;
	self = DEJA_DUP_BACKEND_S3 (obj);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_s3_parent_class)->finalize (obj);
}


GType deja_dup_backend_s3_get_type (void) {
	static volatile gsize deja_dup_backend_s3_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_s3_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendS3Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_s3_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendS3), 0, (GInstanceInitFunc) deja_dup_backend_s3_instance_init, NULL };
		GType deja_dup_backend_s3_type_id;
		deja_dup_backend_s3_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendS3", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_s3_type_id__volatile, deja_dup_backend_s3_type_id);
	}
	return deja_dup_backend_s3_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



