# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import media

from tools       import consts
from mutagen.mp3 import MP3
from mutagen.id3 import ID3


def readInfo(file):
    """ Read information from a mp3 file """
    id3     = ID3(file)
    mp3File = MP3(file)

    info = [consts.UNKNOWN_TRACKNUMBER, consts.UNKNOWN_TITLE, consts.UNKNOWN_ARTIST, consts.UNKNOWN_ALBUM, int(round(mp3File.info.length)), file]

    try:    info[media.NFO_TIT] = unicode(str(id3['TIT2']), errors='replace')
    except: pass

    try:    info[media.NFO_ALB] = unicode(str(id3['TALB']), errors='replace')
    except: pass

    try:    info[media.NFO_ART] = unicode(str(id3['TPE1']), errors='replace')
    except: pass

    try:    info[media.NFO_NUM] = int(str(id3['TRCK']).split('/')[0])  # Track format may be 01/08, 02/08...
    except: pass

    return info
