#ifndef xcontrol_binary_section_h_
#define xcontrol_binary_section_h_ 1

#include "package_name.h"
#include "attribute.h"
#include "control_file_stream.h"

#include <string>

#include <ostream>

class binary_section
{
public:
	binary_section(package_name const &name);

	typedef std::string attribute_selector_type;

	typedef attribute<std::string> attribute;

	attribute operator[](attribute_selector_type const &);

	bool operator==(binary_section const &) const;
	bool operator!=(binary_section const &rhs) const
	{
		return !operator==(rhs);
	}

	package_name name;
	std::string section;
	std::string depends;
	std::string description;
	std::string architecture;
};

control_file_ostream &operator<<(control_file_ostream &, binary_section const &);

#endif
