#!/bin/sh

set -ev
test $DARCS || DARCS=$PWD/../darcs

# Check that checkpoints are removed when tags are unrecorded

rm -rf temp1
mkdir temp1
cd temp1
$DARCS init
echo foo > f
$DARCS rec -Ax -alm init
$DARCS tag -Ax --checkpoint t
echo y | $DARCS unrec -t t
# the complete inventory has only one patch to check
$DARCS check --complete > out
grep -q '1 of 1' out
# the checkpoint (if left) has two patches to check
# but it should have been removed
$DARCS check --partial > out
grep -q '1 of 1' out
cd ..
rm -rf temp1
