DACSCRED(1)                  DACS Commands Manual                  DACSCRED(1)



[1mNAME[0m
       dacscred - acquire and manage [1mDACS [22mcredentials

[1mSYNOPSIS[0m
       [1mdacscred [22m[[1m-dd [4m[22mdir[24m] [[1m-ll [4m[22mlog_level[24m] [[1m-v[22m] [4mop[24m [[4mopargs[24m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacscred [22mutility supports simple [1mDACS [22mauthentication, optionally
       storing the returned [1mDACS [22midentities securely for future use by
       non-browser applications. Basic maintenance operations are provided for
       this cache of credentials.

       [1mDACS [22mper-user information, including the cache, is kept within a
       directory that must be owned by the user. Additionally, the directory
       must be accessible only by the user.  [1mDACS [22mwill refuse to use any
       per-user information if file permissions are inappropriate.

       If this directory is not specified on the command line, the following
       is the default behaviour. If an environment variable named [1mDACSDIR [22mis
       available, its value is used for the name of this directory; otherwise,
       [1mDACS [22mwill use a directory named .dacs in the user's home directory.

       The contents of the cache file are encrypted. A password must be
       provided when the cache is created and before each subsequent access.
       Currently, AES-128-CFB is used along with a SHA1-based [34m[1mHMAC[0m[1m[22m[1].

           [1mSecurity[0m
           A jurisdiction may reject credentials that are used from an IP
           address that does not match the IP address from which the
           credentials were initially requested (see the VERIFY_IP
           configuration directive). This means that if a cache is moved to a
           different host, the credentials may be treated as invalid if they
           are used from that host.

[1mOPTIONS[0m
       The following command line flags are common to all operations:

       [1m-dd [4m[22mdirectory[0m
           The [1mDACS [22mdirectory to use instead of the default is [4mdirectory[24m.

       [1m-ll [4m[22mlog_level[0m
           Set the debugging output level to [4mlog_level[24m (see [34m[1mdacs(1)[0m[1m[22m[2]). The
           default level is warn.

       [1m-v[0m
           The [1m-v [22mflag bumps the debugging output level to debug or (if
           repeated) trace.

       The [4mop[24m argument specifies the operation to be performed. The following
       operations are available:

           Try to authenticate as [4musername[24m by invoking [34m[1mdacs_authenticate[0m[1m[22m[3] at
           the URL [4mauth-URL[24m.  [4musername[24m has the syntax
           [[[4mfederation[24m]::][4mjurisdiction[24m:[4musername[24m (the jurisdiction component
           of the name must be provided; see [34m[1mdacs(1)[0m[1m[22m[4]). An SSL connection is
           always used for this purpose.

           If authentication is successful and the [1m-s [22mflag is not given, the
           ([4musername[24m, [4mauth-URL[24m) pair will be recorded; subsequent invocations
           of the command can omit the [4mauth-URL[24m argument if it is unchanged.
           If the [1m-p [22mflag is given, the user is prompted for a password to
           pass to [1mdacs_authenticate[22m; if [1m-pf [22mis given instead, a password is
           read from [4mfile[24m (stdin is read if [4mfile[24m is "-"). If [4maux[24m is given, it
           is used as the value of the [4mAUXILIARY[24m argument to
           [1mdacs_authenticate[22m. The [1m-caf [22m([1m-ccf[22m) flag identifies [4mfile[24m as a file
           of CA certificates (client certificates) in PEM format,
           respectively; see [34m[1msslclient(1)[0m[1m[22m[5].

           New credentials replace old credentials in the cache. Credentials
           and authentication mappings in the cache are not automatically
           managed, so the cache may contain credentials that have expired.

           The following example prompts the user for a password before trying
           to authenticate as DSS:smith:

               % dacscred auth -p DSS:smith \
                   https://dss.example.com/cgi-bin/dacs/dacs_authenticate

           The following example might be used within a script to test if
           $passwd is the correct password for DSS:smith:

               % echo $passwd | dacscred auth -s -pf - DSS:smith \
                   https://dss.example.com/cgi-bin/dacs/dacs_authenticate

           The exit status will be 0 only if the password is correct.

           Delete all credentials with a name that matches a regular
           expression (see [34m[1mregex(3)[0m[1m[22m[6]).

           Print all credentials to stdout that should be sent along with a
           service request to the given URL. If no URL is given, print all
           credentials in the cache. Note that these credentials represent
           [1mDACS [22midentities and should be kept secret.

           List the names of all credentials in the cache, by default. This is
           equivalent to providing the cred argument. If the auth argument is
           given, a list of identities and the [4mauth-URL[24m arguments that were
           used to authenticate those identities is displayed. If a [4mregex[24m is
           given, the list is limited to those identities matched by it (cred
           behaviour) or those "[4musername[24m [4mauth-URL[24m" strings that match it (auth
           behaviour).

           Change the password that protects the cache. The current password
           must first be provided.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       This command only supplies partial support for interacting with
       [1mdacs_authenticate[22m.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[3]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[7])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[8] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. HMAC
           http://www.rfc-editor.org/rfc/rfc2104.txt

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. dacs_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

        5. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

        6. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                       DACSCRED(1)
