/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2005 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <dom/cria-slide-element-priv.h>

#include <string.h>

enum {
	PROP_0,
	PROP_NAME
};

G_DEFINE_TYPE(CriaSlideElement, cria_slide_element, G_TYPE_OBJECT);

gchar const*
cria_slide_element_get_name(CriaSlideElement const* self) {
	g_return_val_if_fail(CRIA_IS_SLIDE_ELEMENT(self), NULL);
	
	return self->name;
}

void
cria_slide_element_set_name(CriaSlideElement* self, gchar const* name) {
	g_return_if_fail(CRIA_IS_SLIDE_ELEMENT(self));
	g_return_if_fail(name && *name);

	if(self->name && !strcmp(name, self->name)) {
		return;
	}

	g_free(self->name);
	self->name = g_strdup(name);

	g_object_notify(G_OBJECT(self), "name");
}

static void
cria_slide_element_init(CriaSlideElement* self){}

static void
cse_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
	CriaSlideElement* self = CRIA_SLIDE_ELEMENT(object);

	switch(prop_id) {
	case PROP_NAME:
		g_value_set_string(value, cria_slide_element_get_name(self));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void
cse_set_property(GObject* object, guint prop_id, GValue const* value, GParamSpec* pspec) {
	CriaSlideElement* self = CRIA_SLIDE_ELEMENT(object);

	switch(prop_id) {
	case PROP_NAME:
		cria_slide_element_set_name(self, g_value_get_string(value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void
cria_slide_element_class_init(CriaSlideElementClass* self_class) {
	GObjectClass* go_class;

	/* setting up GObjectClass */
	go_class = G_OBJECT_CLASS(self_class);
	go_class->get_property = cse_get_property;
	go_class->set_property = cse_set_property;
	g_object_class_install_property(self_class,
					PROP_NAME,
					g_param_spec_string("name",
							    "Name",
							    "The name of the element",
							    NULL,
							    G_PARAM_READWRITE));
}

