#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
#


_version = "1.1"
fox_header = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.4) Gecko/20070603 Fedora/2.0.0.4-2.fc7 Firefox/2.0.0.4 ConVirt/" + _version


#
# constants definitions
#

# config properties
prop_disks_dir = 'disks_dir'
prop_snapshots_dir = 'snapshots_dir'
prop_conf_dir = 'conf_dir'
prop_cache_dir = 'cache_dir'
prop_kernel = 'kernel'
prop_ramdisk = 'ramdisk'
prop_dom0_kernel = 'dom0_kernel'
#prop_staging_location = 'staging_location'
#prop_staging_path_kernel = 'staging_path_kernel'
#prop_staging_path_ramdisk = 'staging_path_ramdisk'
prop_snapshot_file_ext = 'snapshot_file_ext'
#prop_bootloader = 'bootloader'
prop_lvm = 'lvm_enabled'

prop_isRemote = 'is_remote'
prop_image_store="image_store"
prop_appliance_store="appliance_store"
prop_log_dir='log_dir'
prop_exec_path = 'exec_path'
prop_default_computed_options="default_computed_options"

prop_updates_url = "updates_url"
prop_updates_file = "updates_file"
prop_ref_update_time = "ref_update_time"

# node specific properties
prop_login = "login"
prop_ssh_port= "ssh_port"
prop_migration_port= "migration_port"
prop_use_keys= "use_keys"
prop_address = "address"
prop_platform = "platform"
prop_hostname = "hostname"
prop_last_vncdisplay = "last_vncdisplay"

# ManagedNode environment identifiers
prop_env_SYSTEM = 'SYSTEM'
prop_env_RELEASE = 'RELEASE'
prop_env_VER = 'VERSION'
prop_env_MACHINE_TYPE = 'MACHINE'
prop_env_NODE_NAME = 'NODE'
prop_env_PROCESSOR = 'PROCESSOR'
prop_env_KERNEL = 'RELEASE'

#client config properties
prop_gnome_vfs_enabled = "gnome_vfs_enabled"      # by default True
prop_init_confirmation = 'confirm_dialog'
#prop_browser = "html_browser"       # Location of browser
prop_imagestore_default = 'default_image'

prop_enable_paramiko_log="enable_paramiko_log"
prop_paramiko_log_file = 'paramiko_log_file'

prop_enable_log="enable_log"
prop_log_file = "log_file"
prop_cli_log_file="cli_log_file"

prop_vncviewer = "vncviewer"
prop_local_vncviewer = "local_vncviewer"
prop_vncviewer_options = "vncviewer_options"
prop_vncviewer_via_tunnel = "vncviewer_via_tunnel"
prop_default_ssh_port= "default_ssh_port"
prop_default_use_keys = "default_use_keys"

prop_http_proxy = "http_proxy"
prop_ftp_proxy = "ftp_proxy"

prop_chk_updates_on_startup = "check_updates_on_startup"
prop_guess_proxy = "guess_proxy"
# Global identifiers
LOCALHOST = 'localhost'
DEFAULT_LOG_DIR="/var/log/convirt"

# APP DATA section
prop_domfiles = "vms"
prop_groups = "groups"
prop_images = "images"
prop_image_groups = "image_groups"

prop_storage_defs = "storage_defs"
prop_node_sds = "node_storage_defs"
prop_group_sds = "group_storage_defs"


prop_nw_defns = "nw_defns"
prop_node_defn_status = "node_defn_status"
prop_group_defn_status = "group_defn_status"



# properties for Information Tab
key_os_release= 'release'
key_os_system='system'
key_os_machine='machine'
key_os_distro='distro'
key_os_distro_ver='distro_ver'
key_os_distro_string='distro_string'

key_network_interface_name='interface_name'
key_network_ip='ip_address'

key_cpu_count='no_of_processors'
key_cpu_vendor_id='vendor_id'
key_cpu_model_name='model_name'
key_cpu_mhz = "cpu_mhz"

key_memory_total='total_memory'
key_memory_free='free_memory'
key_disk_file_system='file_system'
key_disk_size='size'
key_disk_mounted='mounted_on'

display_os_release= 'Kernel'
display_os_system='Platform'
display_os_machine='Architecture'
display_os_distro='Distribution'

display_network_interface_name='INTERFACE NAME'
display_network_ip='IP ADDRESS'

display_cpu_count='Processors'
display_cpu_vendor_id='Vendor Id'
display_cpu_model_name='Model'
display_cpu_mhz = "Speed (MHz)"

display_memory_total='Total Memory (MB)'
display_memory_free='Free Memory (MB)'

display_disk_file_system='FILE SYSTEM'
display_disk_size='SIZE'
display_disk_mounted='MOUNTED ON'
display_platform_xen_version='Xen Version'
display_platform_xen_caps='Xen Capabilites'

display_tab_os_info="OS Info"
display_tab_cpu_info="CPU Info"
display_tab_memory_info="Memory Info"
display_tab_disk_info="Disk Info"
display_tab_network_info="Network Info"
display_tab_platform_info="Platform Info"


VM_SHARED_STORAGE="VM_SHARED_STORAGE"
VM_LOCAL_STORAGE="VM_LOCAL_STORAGE"
VM_TOTAL_STORAGE="VM_TOTAL_STORAGE"

POOL_STORAGE_TOTAL="POOL_STORAGE_TOTAL"



# Constants required for cli


# Constants
VM_RUNNING_STATE=0
VM_BLOCKED_STATE=1
VM_PAUSED_STATE=2
VM_NOT_RUNNING_STATE=-1

# Paths
SNAPSHOT_FILE_LOCATION="/var/cache/convirt/snapshots/"
SNAPSHOT_FILE_EXT=".snapshot.xm"
