#
# 	UNIX-SPECIFIC HELPERS MANAGEMENT
# 	(c) 1997 Alexandre Burton & Jean Piche
# 	v1.80a (10/08/97)
#
#       MODIFIED BY Hans-Christoph Steiner
#       $Id $
#

proc getSoundFileInfo {path} {
    global prefs
    catch    {exec $prefs(help:CSND) -U sndinfo $path} stuff
    if {[lsearch $stuff "AIFF"] == -1 && [lsearch $stuff "WAVE"] == -1 } {return 0}
    set type [lindex $stuff [expr [lsearch $stuff "soundfile,"] - 1]]
    if {$type == ""} {
	set type [lindex $stuff [expr [lsearch $stuff "soundfile"] - 1]]
    }
    set dur  [lindex $stuff [expr [lsearch $stuff "seconds"] - 1]]
    set sr   [string trim [lindex $stuff [expr [lsearch $stuff "srate"] + 1]] ", "]
    set tr   [string trim [lindex $stuff [expr [lsearch $stuff ${sr},] + 1]] ", "]
    set siz  [lindex $stuff [expr [lsearch $stuff ${tr},] + 1]]
    return   "$dur $sr [string tolower $type] $tr $siz"

}

proc editSoundFile { path } {
    global prefs
    exec $prefs(help:EDIT) [string trim $path \"] &
}

proc convSoundFile { path } {
    global prefs
    exec soundfiler [string trim $path \"] &
}

proc playSound {what where} {
    global ceclib prefs player
     exec $prefs(help:PLAY) [string trim $what \"] &
}

proc Helpme  {what} {
    global ceclib prefs tcl_platform
    set helpPage [file join $ceclib doc $what]

    switch -- $tcl_platform(os) {
	IRIX {
	    set ps [exec ps -e]
	    if ![regexp netscape $ps] { 
		puts "info: starting netscape."
		exec netscape $helpPage & 
	    } else { exec netscape -remote openURL(file:$helpPage) & }
	}
	Linux {
	    set ps [exec ps -e]
	    if ![regexp $prefs(help:HTML) $ps] { 
		puts "info: starting $prefs(help:HTML)."
		exec $prefs(help:HTML) $helpPage & 
	    } else { exec $prefs(help:HTML) -remote openURL(file:$helpPage) & }
	}
	Darwin {
	    exec /usr/bin/open $helpPage &
	}
    }
}
