#
# 	Fonctions de traitement des arrays de graphs
# 	(c) 1995-8 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#

proc resample {cible rate} {
    global data actif path limite 
    if {$cible == "actif"} {set cible $actif}
    array set dc $data($cible)
    set liste [lsort  -real [array names dc] ]
    set index 0
    set dt [expr 1.0/($rate)]
    set start 0.0
    set newData($start) $dc($start)
    foreach p [lrange $liste 1 end] {
	set m [expr ($dc($p)-$dc($start))/($p-$start)]
	set b [expr -$m*$start+$dc($start)]
	while {(($dt*$index)) < $p} {
	    set x [expr $dt*$index]
	    set newData([expr ($x)]) [expr $m*$x+$b]
	    incr index
	}
	set start $p
    }
    set newData(1.0) $dc(1.0)
    set data($cible) [array get newData]
    redrawLine $cible
}

proc randomize {cible xrand yrand type} {
    global data actif path limite 
    if {$cible == "actif"} {set cible $actif}
    array set dc $data($cible)
    switch $type {
    
	rnd {
	    foreach p  [array names dc] {
		if {($p == 0.0) || ($p == 1.0)} {
		    set x $p
		} else {
		    set x [expr abs($p - $xrand + (2.0 * $xrand * [rawrand] / 65535))]
		    if {$x >= 1} { set x [expr 1.0 - ($x -1)] }
		}
		set y [expr abs($dc($p) - $yrand + (2.0 * $yrand * [rawrand] / 65535))]
		if {$y > 1} { set y [expr 1.0 - ($y -1)] }
		set newData($x) $y
	    }
	}
	
	sq {
		set pList [lsort [array names dc]]
		for {set j 0} {$j<[expr [llength $pList ] -1]} {incr j} {
			set de [lindex $pList [expr $j + 0]]
			set ar [lindex $pList [expr $j + 1]]
			set mid [expr $ar - .000001]

#			set adde [expr abs($de - $xrand + (2.0 * $xrand * [rawrand] / 65535))]
#			set adar [expr abs($ar - $xrand + (2.0 * $xrand * [rawrand] / 65535))]
#			set admid [expr $adar - .000001]
#			if {$de == 0.0} {set adde 0.0}

			set valdep [expr abs($dc($de) - $yrand + (2.0 * $yrand * [rawrand] / 65535))]
			set valar [expr abs($dc($ar) - $yrand + (2.0 * $yrand * [rawrand] / 65535))]
			set newData($de)  $valdep
			set newData($ar)  $valar
			set newData($mid)  $valdep
		    }
	}
	rm {		
		set pList [lsort [array names dc]]
		for {set j 0} {$j<[expr [llength $pList ] -1]} {incr j} {
			set de [lindex $pList [expr $j + 0]]
			set ar [lindex $pList [expr $j + 1]]
			set mid [expr $ar + .000001]
			
			set valdep [expr abs($dc($de) - $yrand + (2.0 * $yrand * [rawrand] / 65535))]
			set valar [expr abs($dc($ar) - $yrand + (2.0 * $yrand * [rawrand] / 65535))]
			set newData($de)  $valdep
			set newData($ar)  $valar
			set newData($mid)  $valdep
		    }
	}
	
    }
    set data($cible) [array get newData]
    redrawLine $cible
}

proc normalize {cible amb} {
    global data actif path limite
    if {$cible == "actif"} {set cible $actif}
    array set dataCourant $data($cible)
    set range [expr [getMaxY $data($cible)] - [getMinY $data($cible)]]
    if {$range == 0} {return}
    set scale [expr $amb / $range]
    set offset [getMinY $data($cible)]

    foreach x [array names dataCourant] {
	set newY [expr ($dataCourant($x) - $offset) * $scale]
	if {$newY > 1} {set newY 1} else { if {$newY < 0} {set newY 0}} 	
	set dataCourant($x) $newY   
    }
    set data($cible) [array get dataCourant]
    if {$amb < 1.0} {
	nodge $cible [expr (1.0-$amb)/2.0]
    } else {
	redrawLine $cible
    }
}

proc noise {rate amp type} {

    global data actif path limite fDat
    set cible $actif
    set dataCourant(0.0) [expr $amp * [rawrand] / 65535]
    set dataCourant(1.0) [expr $amp * [rawrand] / 65535]

    switch $type {
	rm {
	    for {set j 0} {$j<$rate} {incr j} {
		set dataCourant([expr 1.0 * [rawrand] / 65535]) [expr $amp * [rawrand] / 65535]
	    }
	}
	sq {	append randList "0.0 "
		for {set j 0} {$j<[expr $rate]} {incr j} {
		    append randList "[expr 1.0 * [rawrand] / 65535] "
		    }
		    set randList [lsort -real $randList]
	     
		for {set j 0} {$j<[expr $rate ]} {incr j 1} {
		    set dat [expr $amp * [rawrand] / 65535]	
		    set st [lindex $randList $j]
		    set en [expr [lindex $randList [expr $j + 1]] - 0.00001]
		    set dataCourant($st)  $dat
		    set dataCourant($en)  $dat
		}
		unset dataCourant($en)
		set  dataCourant(1.0) $dat
	    }
	}   
    set data($cible) [array get dataCourant]
    redrawLine $cible
}

proc drunk {rate step init} {
    global data actif
    set cible $actif
    switch $init {
        rand	{
        	set myinit [expr 1.0 * [rawrand] / 65535.0]
        }
		static	{
	    	array set temp $data($cible)
	    	set myinit $temp(0.0)
		}
		default {
			set myinit $init 
		}
    }
    set data($cible) [drunkGen $rate $step $myinit]
    redrawLine $cible
}

proc drunkGen {rate step init} {
	set dataCourant(0.0) $init 
    set prevY $dataCourant(0.0)
    for {set j 1} {$j<$rate+1} {incr j} {
		set x [expr 1.0 * $j/$rate]
		set y [expr abs(1.0 * ([rawrand] / (65535.0 / $step) * 2) -$step +$prevY)]
		if {$y > 1} { set y [expr 1.0 - ($y -1)] }
		set dataCourant($x) $y
		set prevY $dataCourant($x)
    }
	foreach x [lsort -real [array names dataCourant]] {
		lappend out $x $dataCourant($x)
	}
    return $out
}	
   
proc realDrunk {rate init amp offset} {
	array set dataCourant [drunkGen $rate 1 $init]
	foreach x [lsort -real [array names dataCourant]] {
		lappend out $x [expr (1.0*$dataCourant($x)*$amp) + $offset - $amp/2]
	}
	return $out 
}



proc sine {rate freq amp phs} {
    global data actif path limite fDat
    set cible $actif
    set data($cible) [waveGen sine $rate $freq $amp $phs]
    redrawLine $cible
}

proc waveGen {type rate freq amp phs} {
	switch $type {
		sine {
		    for {set j 0} {$j<=$rate} {incr j} {
				set newX [expr 1.0 * ($j)/$rate]
				set dataCourant($newX) [expr $amp*0.5 * ( sin($freq * ($newX+($phs/360.)) * 2* 3.14159))+0.5]
			}	
		}
	}
	foreach x [lsort -real [array names dataCourant]] {
		lappend out $x $dataCourant($x)
	}
    return $out
}
  
proc realGen {type rate freq amp phs offset} {
	array set dataCourant [waveGen $type $rate $freq 1 $phs]
	foreach x [lsort -real [array names dataCourant]] {
		lappend out $x [expr (1.0*$dataCourant($x)*$amp) + $offset - $amp/2]
	}
	return $out 
}



proc linseg {freq amp type phas inv} {
    global data actif path limite

    set cible $actif
    if {$inv == 1} {set amp [expr -$amp]}
    switch $type {
	r { set g 0
	    for {set j 0} {$j<$freq} {incr j} {
		set dataCourant([expr ($g + .0001)/$freq]) [expr 0.5+$amp/2.0]
		set dataCourant([expr [incr g].0/$freq]) [expr 0.5-$amp/2.0]
	    }
	    set dataCourant(0.0) [expr 0.5+$amp/2.0]
	    unset dataCourant([expr (.0001)/$freq])
	}
	q { set g 0;set boo [expr $freq * 2]
	    for {set j 0} {$j<[expr $freq]} {incr j} {
		set h   [expr ($g+.0001)/$boo]
		set h3  [expr ($g + 2.0)  /$boo]
		set h2  [expr (($h3-$h) * $phas)+$h]
		set h2a [expr $h2 + 0.0001]
		set dataCourant($h)  [expr 0.5+$amp/2.0]
		set dataCourant($h2)  [expr 0.5+$amp/2.0]
		set dataCourant($h2a) [expr 0.5-$amp/2.0]
		set dataCourant($h3)  [expr 0.5-$amp/2.0]
		set g [expr $g+2]
	    }
	    set dataCourant(0.0) [expr 0.5+($amp/2.0)]
	    unset dataCourant([expr (.0001)/$boo])
	}
    }

    set data($cible) [array get dataCourant]
    redrawLine $cible
}

proc compress {cible ratio} {
    global data actif path limite
    if {$cible == "actif"} {set cible $actif}
    array set dataCourant $data($cible)
    set listeCourante [lsort  -real [array names dataCourant] ]
    foreach x $listeCourante {
	switch $x {
	    0.0	    {set newX 0.0}
	    1.0	    {set newX 1.0}
	    default {
		set posCourante [lsearch -exact $listeCourante $x]
		if {$ratio > 0} {
		    set newX [expr $x +((1.0 - $x) * $ratio)]
		    set preX  [lindex $listeCourante [expr $posCourante -1]]
		    if {$newX <= $preX}  { set $newX [expr $preX + .0000001] }
		} else {
		    set newX [expr $x +($x * $ratio)]
		    set postX [lindex $listeCourante [expr $posCourante +1]]
		    if {$newX >= $postX} { set $newX [expr $postX - .0000001] }
		}
	    }
	}
	set newCourant($newX) $dataCourant($x)
    }
    set data($cible) [array get newCourant]
    redrawLine $cible
}

proc nodge {cible step} {
    global data actif path limite
    if {$cible == "actif"} {set cible $actif}
    array set dataCourant $data($cible)
    switch -- $step {
	top	{ set step [expr 1.0 - [getMaxY [array get dataCourant]]] }
	bottom	{ set step [expr 0.0 - [getMinY [array get dataCourant]]] }
	default { 
	    if {$step >= 1 || $step <= -1} {
		set step [ expr [screenToFloatY [expr $step + $limite(pad)]] -1] 
	    }
	}
    }    
    foreach x [array names dataCourant] {
	set newY [expr $dataCourant($x) + $step]
	if {$newY > 1} {set newY 1} else { if {$newY < 0} {set newY 0}} 	
	set dataCourant($x) $newY   
    }
    set data($cible) [array get dataCourant]
    redrawLine $cible
}

proc caldur {cible} {
    global data soundInInfo value
    set duree [lindex $soundInInfo(source) 2]
    array set dataCourant $data($cible)
    set liste [lsort -real [array names dataCourant]]
    set s 0
    for {set i 0} {$i<[llength $liste]-1} {incr i} {
	set t  [lindex $liste $i] 
	set t1 [lindex $liste [expr $i+1]]
	set d  [expr 1/[floatToParam $dataCourant($t) $cible]]
	set d1 [expr 1/[floatToParam $dataCourant($t1) $cible]]
	set t  [expr $t * $duree]
	set t1 [expr $t1  * $duree]
	set s [expr 0.5*($s+($t1-$t)*($d+$d1))]
	
    }
    set s [format %.2f $s]
    set value(duree_totale) $s
    update
    drawXGrid
}

proc gen {cible t} {

    global data actif path limite
    if {$cible == "actif"} {set cible $actif}
    array set dc $data($cible)
    set x [timeToFloat $t]
    if {$x>1.0||$x<0.0} { return OutOfRange }
    if [info exists dc($x)] { return [floatToParam $dc($x) $cible] }
    set dc($x) glabou
    set liste [lsort -real [array names dc]]
    set i [lsearch $liste $x]
    incr i -1
    set pre [lindex $liste $i]
    incr i 2
    set post [lindex $liste $i]
    if {[expr 1.0*($dc($post)-$dc($pre))] == 0.0} {
	set m 0
    } else {
	set m [expr ($dc($post)-$dc($pre))/($post-$pre)]
    }
    set b [expr -$m*$pre+$dc($pre)]
    return [floatToParam [expr $m*$x+$b] $cible]
}

proc fractal {cible maxiter args} {
#loadSourceFiles

    global data actif path limite
    if {$cible == "actif"} {set cible $actif}
    array set dc $data($cible)
    set liste [lsort -real [array names dc]]
    set N [expr [llength $liste] -1]
#    incr maxiter 
    for {set z 0} {$z <=$N} {incr z} {
	set xorig($z) [lindex $liste $z]
	set yorig($z) $dc($xorig($z))
    }
    
    # as Monro CMJ V11No1 p.90

    for {set i 1} {$i <= $N} {incr i} {
	set imin [expr $i - 1]
	set a($i) [expr $xorig($i) - $xorig($imin) ]
	set c($i) [expr $yorig($i) - $yorig($imin) ]
	set d($i) [lindex $args $imin]
	set e($i) $xorig($imin)
	set f($i) $yorig($imin)
    }
    for {set i 0} {$i <= $N} {incr i} {
	set xold($i) $xorig($i)
	set yold($i) $yorig($i)
    }

    set currpts $N
    set np 0
    
    for {set iter 2} {$iter <= $maxiter} {incr iter} {
	for {set t 1} {$t <= $N } {incr t} {
	    for {set i 0} {$i <= [expr $currpts-1]} {incr i} {
		set xnew($np) [expr $a($t)*$xold($i)+$e($t)]
		set ynew($np) [expr $c($t)*$xold($i)+$d($t)*$yold($i)+$f($t)]
		incr np
	    }
	}
	
	set xnew($np) $xold($currpts)
	set ynew($np) $yold($currpts)
	
	for {set i 0} {$i <= $np} {incr i} {
	    set xold($i) $xnew($i)
	    set yold($i) $ynew($i)
	}
	set currpts $np 
	set np 0
    }
    for {set n 0} {$n <= $currpts} {incr n} {
	set out($xnew($n)) $ynew($n)
    }
    set data($cible) [array get out]
    redrawLine $cible

}
