
#include <assert.h>

#include "ImagePanelYUV.h"

/**
  \class CImagePanelYUV
  \brief A simple CamPanel that displays YUV images from \ref CVideoDevice

  This class is placed right on top of CVideoDevice: it handles the YUV
  images. See alse \ref CImagePanelRGB
  
  Registers panel "image.yuv"
 */
 

/**
  \param video A \ref CVideoDevice object.
  \param parent The QWdiget parent object
  \param name The widget name
  \brief Constructor.
 */
CImagePanelYUV::CImagePanelYUV(CVideoDevice *video, QWidget *parent, const char *name)
	: CCamPanel("image.yuv", "Video image YUV", YUV420, TRUE, parent, name)
{
   assert(video != NULL);
   m_pVideo = video;
   SetSize(m_pVideo->GetSize());
   connect(m_pVideo, SIGNAL(SizeChanged(const QSize &)), this, SLOT(SetSize(const QSize &)));
   connect(m_pVideo, SIGNAL(FrameReady()), this, SLOT(UpdateImage()));
}

// private

void CImagePanelYUV::UpdateImage()
{
   CVideoFrame *frame = 0;

   frame = m_pVideo->GetLatestVideoFrame();
   if (frame == 0) {
     ImgY.reset();
     ImgU.reset();
     ImgV.reset();
   }
   else {
     ImgY = frame->GetY()->copy();
     ImgU = frame->GetU()->copy();
     ImgV = frame->GetV()->copy();
   }
   delete frame;
   update();
}


// public

/// overloaded

void CImagePanelYUV::hideEvent(QHideEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelYUV::hideEvent()");
#endif   
   //CCamPanel::SetVisibility(new_vis);
   m_pVideo->DisableYUV();
   QWidget::hideEvent(e);
}

void CImagePanelYUV::showEvent(QShowEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelYUV::showEvent()");
#endif
   m_pVideo->EnableYUV();
   QWidget::showEvent(e);
}
