// Copyright (C) 2005-2008 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "MonitoringModel.hxx"

namespace mml
{
  // MonitoringIn
  // 

  const MonitoringIn::dt_type& MonitoringIn::
  dt () const
  {
    return this->dt_.get ();
  }

  MonitoringIn::dt_type& MonitoringIn::
  dt ()
  {
    return this->dt_.get ();
  }

  void MonitoringIn::
  dt (const dt_type& x)
  {
    this->dt_.set (x);
  }

  void MonitoringIn::
  dt (::std::auto_ptr< dt_type > x)
  {
    this->dt_.set (x);
  }

  const MonitoringIn::refresh_type& MonitoringIn::
  refresh () const
  {
    return this->refresh_.get ();
  }

  MonitoringIn::refresh_type& MonitoringIn::
  refresh ()
  {
    return this->refresh_.get ();
  }

  void MonitoringIn::
  refresh (const refresh_type& x)
  {
    this->refresh_.set (x);
  }

  void MonitoringIn::
  refresh (::std::auto_ptr< refresh_type > x)
  {
    this->refresh_.set (x);
  }

  const MonitoringIn::pmlFile_optional& MonitoringIn::
  pmlFile () const
  {
    return this->pmlFile_;
  }

  MonitoringIn::pmlFile_optional& MonitoringIn::
  pmlFile ()
  {
    return this->pmlFile_;
  }

  void MonitoringIn::
  pmlFile (const pmlFile_type& x)
  {
    this->pmlFile_.set (x);
  }

  void MonitoringIn::
  pmlFile (const pmlFile_optional& x)
  {
    this->pmlFile_ = x;
  }

  void MonitoringIn::
  pmlFile (::std::auto_ptr< pmlFile_type > x)
  {
    this->pmlFile_.set (x);
  }

  const MonitoringIn::simulatorFile_optional& MonitoringIn::
  simulatorFile () const
  {
    return this->simulatorFile_;
  }

  MonitoringIn::simulatorFile_optional& MonitoringIn::
  simulatorFile ()
  {
    return this->simulatorFile_;
  }

  void MonitoringIn::
  simulatorFile (const simulatorFile_type& x)
  {
    this->simulatorFile_.set (x);
  }

  void MonitoringIn::
  simulatorFile (const simulatorFile_optional& x)
  {
    this->simulatorFile_ = x;
  }

  void MonitoringIn::
  simulatorFile (::std::auto_ptr< simulatorFile_type > x)
  {
    this->simulatorFile_.set (x);
  }

  const MonitoringIn::lmlFile_optional& MonitoringIn::
  lmlFile () const
  {
    return this->lmlFile_;
  }

  MonitoringIn::lmlFile_optional& MonitoringIn::
  lmlFile ()
  {
    return this->lmlFile_;
  }

  void MonitoringIn::
  lmlFile (const lmlFile_type& x)
  {
    this->lmlFile_.set (x);
  }

  void MonitoringIn::
  lmlFile (const lmlFile_optional& x)
  {
    this->lmlFile_ = x;
  }

  void MonitoringIn::
  lmlFile (::std::auto_ptr< lmlFile_type > x)
  {
    this->lmlFile_.set (x);
  }

  const MonitoringIn::simulator_type& MonitoringIn::
  simulator () const
  {
    return this->simulator_.get ();
  }

  MonitoringIn::simulator_type& MonitoringIn::
  simulator ()
  {
    return this->simulator_.get ();
  }

  void MonitoringIn::
  simulator (const simulator_type& x)
  {
    this->simulator_.set (x);
  }

  void MonitoringIn::
  simulator (::std::auto_ptr< simulator_type > x)
  {
    this->simulator_.set (x);
  }

  const MonitoringIn::stoppingCriteria_optional& MonitoringIn::
  stoppingCriteria () const
  {
    return this->stoppingCriteria_;
  }

  MonitoringIn::stoppingCriteria_optional& MonitoringIn::
  stoppingCriteria ()
  {
    return this->stoppingCriteria_;
  }

  void MonitoringIn::
  stoppingCriteria (const stoppingCriteria_type& x)
  {
    this->stoppingCriteria_.set (x);
  }

  void MonitoringIn::
  stoppingCriteria (const stoppingCriteria_optional& x)
  {
    this->stoppingCriteria_ = x;
  }

  void MonitoringIn::
  stoppingCriteria (::std::auto_ptr< stoppingCriteria_type > x)
  {
    this->stoppingCriteria_.set (x);
  }

  const MonitoringIn::monitors_optional& MonitoringIn::
  monitors () const
  {
    return this->monitors_;
  }

  MonitoringIn::monitors_optional& MonitoringIn::
  monitors ()
  {
    return this->monitors_;
  }

  void MonitoringIn::
  monitors (const monitors_type& x)
  {
    this->monitors_.set (x);
  }

  void MonitoringIn::
  monitors (const monitors_optional& x)
  {
    this->monitors_ = x;
  }

  void MonitoringIn::
  monitors (::std::auto_ptr< monitors_type > x)
  {
    this->monitors_.set (x);
  }


  // TimeParameter
  // 

  const TimeParameter::value_type& TimeParameter::
  value () const
  {
    return this->value_.get ();
  }

  TimeParameter::value_type& TimeParameter::
  value ()
  {
    return this->value_.get ();
  }

  void TimeParameter::
  value (const value_type& x)
  {
    this->value_.set (x);
  }

  const TimeParameter::unit_type& TimeParameter::
  unit () const
  {
    return this->unit_.get ();
  }

  TimeParameter::unit_type& TimeParameter::
  unit ()
  {
    return this->unit_.get ();
  }

  void TimeParameter::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void TimeParameter::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }


  // TimeUnit
  // 

  TimeUnit::
  TimeUnit (value v)
  : ::xml_schema::string (_xsd_TimeUnit_literals_[v])
  {
  }

  TimeUnit::
  TimeUnit (const char* v)
  : ::xml_schema::string (v)
  {
  }

  TimeUnit::
  TimeUnit (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  TimeUnit::
  TimeUnit (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  TimeUnit::
  TimeUnit (const TimeUnit& v,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  TimeUnit& TimeUnit::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_TimeUnit_literals_[v]);

    return *this;
  }


  // StoppingCriteria
  // 

  const StoppingCriteria::criteria_optional& StoppingCriteria::
  criteria () const
  {
    return this->criteria_;
  }

  StoppingCriteria::criteria_optional& StoppingCriteria::
  criteria ()
  {
    return this->criteria_;
  }

  void StoppingCriteria::
  criteria (const criteria_type& x)
  {
    this->criteria_.set (x);
  }

  void StoppingCriteria::
  criteria (const criteria_optional& x)
  {
    this->criteria_ = x;
  }

  void StoppingCriteria::
  criteria (::std::auto_ptr< criteria_type > x)
  {
    this->criteria_.set (x);
  }

  const StoppingCriteria::multipleCriteria_optional& StoppingCriteria::
  multipleCriteria () const
  {
    return this->multipleCriteria_;
  }

  StoppingCriteria::multipleCriteria_optional& StoppingCriteria::
  multipleCriteria ()
  {
    return this->multipleCriteria_;
  }

  void StoppingCriteria::
  multipleCriteria (const multipleCriteria_type& x)
  {
    this->multipleCriteria_.set (x);
  }

  void StoppingCriteria::
  multipleCriteria (const multipleCriteria_optional& x)
  {
    this->multipleCriteria_ = x;
  }

  void StoppingCriteria::
  multipleCriteria (::std::auto_ptr< multipleCriteria_type > x)
  {
    this->multipleCriteria_.set (x);
  }


  // Criteria
  // 

  const Criteria::method_type& Criteria::
  method () const
  {
    return this->method_.get ();
  }

  Criteria::method_type& Criteria::
  method ()
  {
    return this->method_.get ();
  }

  void Criteria::
  method (const method_type& x)
  {
    this->method_.set (x);
  }

  void Criteria::
  method (::std::auto_ptr< method_type > x)
  {
    this->method_.set (x);
  }

  const Criteria::data_optional& Criteria::
  data () const
  {
    return this->data_;
  }

  Criteria::data_optional& Criteria::
  data ()
  {
    return this->data_;
  }

  void Criteria::
  data (const data_type& x)
  {
    this->data_.set (x);
  }

  void Criteria::
  data (const data_optional& x)
  {
    this->data_ = x;
  }

  void Criteria::
  data (::std::auto_ptr< data_type > x)
  {
    this->data_.set (x);
  }


  // KineticEnergy
  // 


  // Speed
  // 

  const Speed::unit_type& Speed::
  unit () const
  {
    return this->unit_.get ();
  }

  Speed::unit_type& Speed::
  unit ()
  {
    return this->unit_.get ();
  }

  void Speed::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void Speed::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }


  // SpeedUnit
  // 

  SpeedUnit::
  SpeedUnit (value v)
  : ::xml_schema::string (_xsd_SpeedUnit_literals_[v])
  {
  }

  SpeedUnit::
  SpeedUnit (const char* v)
  : ::xml_schema::string (v)
  {
  }

  SpeedUnit::
  SpeedUnit (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  SpeedUnit::
  SpeedUnit (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  SpeedUnit::
  SpeedUnit (const SpeedUnit& v,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  SpeedUnit& SpeedUnit::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_SpeedUnit_literals_[v]);

    return *this;
  }


  // Position
  // 

  const Position::unit_type& Position::
  unit () const
  {
    return this->unit_.get ();
  }

  Position::unit_type& Position::
  unit ()
  {
    return this->unit_.get ();
  }

  void Position::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void Position::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }


  // PositionUnit
  // 

  PositionUnit::
  PositionUnit (value v)
  : ::xml_schema::string (_xsd_PositionUnit_literals_[v])
  {
  }

  PositionUnit::
  PositionUnit (const char* v)
  : ::xml_schema::string (v)
  {
  }

  PositionUnit::
  PositionUnit (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  PositionUnit::
  PositionUnit (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  PositionUnit::
  PositionUnit (const PositionUnit& v,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  PositionUnit& PositionUnit::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_PositionUnit_literals_[v]);

    return *this;
  }


  // Time
  // 

  const Time::unit_type& Time::
  unit () const
  {
    return this->unit_.get ();
  }

  Time::unit_type& Time::
  unit ()
  {
    return this->unit_.get ();
  }

  void Time::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void Time::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }


  // Force
  // 

  const Force::unit_type& Force::
  unit () const
  {
    return this->unit_.get ();
  }

  Force::unit_type& Force::
  unit ()
  {
    return this->unit_.get ();
  }

  void Force::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void Force::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }


  // ForceUnit
  // 

  ForceUnit::
  ForceUnit (value v)
  : ::xml_schema::string (_xsd_ForceUnit_literals_[v])
  {
  }

  ForceUnit::
  ForceUnit (const char* v)
  : ::xml_schema::string (v)
  {
  }

  ForceUnit::
  ForceUnit (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  ForceUnit::
  ForceUnit (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  ForceUnit::
  ForceUnit (const ForceUnit& v,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  ForceUnit& ForceUnit::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_ForceUnit_literals_[v]);

    return *this;
  }


  // Method
  // 

  const Method::scope_optional& Method::
  scope () const
  {
    return this->scope_;
  }

  Method::scope_optional& Method::
  scope ()
  {
    return this->scope_;
  }

  void Method::
  scope (const scope_type& x)
  {
    this->scope_.set (x);
  }

  void Method::
  scope (const scope_optional& x)
  {
    this->scope_ = x;
  }

  void Method::
  scope (::std::auto_ptr< scope_type > x)
  {
    this->scope_.set (x);
  }


  // Threshold
  // 

  const Threshold::maxValue_type& Threshold::
  maxValue () const
  {
    return this->maxValue_.get ();
  }

  Threshold::maxValue_type& Threshold::
  maxValue ()
  {
    return this->maxValue_.get ();
  }

  void Threshold::
  maxValue (const maxValue_type& x)
  {
    this->maxValue_.set (x);
  }


  // MinThreshold
  // 

  const MinThreshold::minValue_type& MinThreshold::
  minValue () const
  {
    return this->minValue_.get ();
  }

  MinThreshold::minValue_type& MinThreshold::
  minValue ()
  {
    return this->minValue_.get ();
  }

  void MinThreshold::
  minValue (const minValue_type& x)
  {
    this->minValue_.set (x);
  }


  // Scope
  // 

  Scope::
  Scope (value v)
  : ::xml_schema::string (_xsd_Scope_literals_[v])
  {
  }

  Scope::
  Scope (const char* v)
  : ::xml_schema::string (v)
  {
  }

  Scope::
  Scope (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  Scope::
  Scope (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  Scope::
  Scope (const Scope& v,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  Scope& Scope::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_Scope_literals_[v]);

    return *this;
  }


  // MultipleCriteria
  // 

  const MultipleCriteria::multipleCriteria_sequence& MultipleCriteria::
  multipleCriteria () const
  {
    return this->multipleCriteria_;
  }

  MultipleCriteria::multipleCriteria_sequence& MultipleCriteria::
  multipleCriteria ()
  {
    return this->multipleCriteria_;
  }

  void MultipleCriteria::
  multipleCriteria (const multipleCriteria_sequence& s)
  {
    this->multipleCriteria_ = s;
  }

  const MultipleCriteria::criteria_sequence& MultipleCriteria::
  criteria () const
  {
    return this->criteria_;
  }

  MultipleCriteria::criteria_sequence& MultipleCriteria::
  criteria ()
  {
    return this->criteria_;
  }

  void MultipleCriteria::
  criteria (const criteria_sequence& s)
  {
    this->criteria_ = s;
  }

  const MultipleCriteria::op_type& MultipleCriteria::
  op () const
  {
    return this->op_.get ();
  }

  MultipleCriteria::op_type& MultipleCriteria::
  op ()
  {
    return this->op_.get ();
  }

  void MultipleCriteria::
  op (const op_type& x)
  {
    this->op_.set (x);
  }

  void MultipleCriteria::
  op (::std::auto_ptr< op_type > x)
  {
    this->op_.set (x);
  }


  // LogicalOp
  // 

  LogicalOp::
  LogicalOp (value v)
  : ::xml_schema::string (_xsd_LogicalOp_literals_[v])
  {
  }

  LogicalOp::
  LogicalOp (const char* v)
  : ::xml_schema::string (v)
  {
  }

  LogicalOp::
  LogicalOp (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  LogicalOp::
  LogicalOp (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  LogicalOp::
  LogicalOp (const LogicalOp& v,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  LogicalOp& LogicalOp::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_LogicalOp_literals_[v]);

    return *this;
  }


  // Monitors
  // 

  const Monitors::monitor_sequence& Monitors::
  monitor () const
  {
    return this->monitor_;
  }

  Monitors::monitor_sequence& Monitors::
  monitor ()
  {
    return this->monitor_;
  }

  void Monitors::
  monitor (const monitor_sequence& s)
  {
    this->monitor_ = s;
  }


  // Reference
  // 

  const Reference::document_type& Reference::
  document () const
  {
    return this->document_.get ();
  }

  Reference::document_type& Reference::
  document ()
  {
    return this->document_.get ();
  }

  void Reference::
  document (const document_type& x)
  {
    this->document_.set (x);
  }

  void Reference::
  document (::std::auto_ptr< document_type > x)
  {
    this->document_.set (x);
  }

  const Reference::monitorIndex_optional& Reference::
  monitorIndex () const
  {
    return this->monitorIndex_;
  }

  Reference::monitorIndex_optional& Reference::
  monitorIndex ()
  {
    return this->monitorIndex_;
  }

  void Reference::
  monitorIndex (const monitorIndex_type& x)
  {
    this->monitorIndex_.set (x);
  }

  void Reference::
  monitorIndex (const monitorIndex_optional& x)
  {
    this->monitorIndex_ = x;
  }

  const Reference::target_optional& Reference::
  target () const
  {
    return this->target_;
  }

  Reference::target_optional& Reference::
  target ()
  {
    return this->target_;
  }

  void Reference::
  target (const target_type& x)
  {
    this->target_.set (x);
  }

  void Reference::
  target (const target_optional& x)
  {
    this->target_ = x;
  }

  void Reference::
  target (::std::auto_ptr< target_type > x)
  {
    this->target_.set (x);
  }


  // Monitor
  // 

  const Monitor::startAt_type& Monitor::
  startAt () const
  {
    return this->startAt_.get ();
  }

  Monitor::startAt_type& Monitor::
  startAt ()
  {
    return this->startAt_.get ();
  }

  void Monitor::
  startAt (const startAt_type& x)
  {
    this->startAt_.set (x);
  }

  void Monitor::
  startAt (::std::auto_ptr< startAt_type > x)
  {
    this->startAt_.set (x);
  }

  const Monitor::stopAt_type& Monitor::
  stopAt () const
  {
    return this->stopAt_.get ();
  }

  Monitor::stopAt_type& Monitor::
  stopAt ()
  {
    return this->stopAt_.get ();
  }

  void Monitor::
  stopAt (const stopAt_type& x)
  {
    this->stopAt_.set (x);
  }

  void Monitor::
  stopAt (::std::auto_ptr< stopAt_type > x)
  {
    this->stopAt_.set (x);
  }

  const Monitor::reference_sequence& Monitor::
  reference () const
  {
    return this->reference_;
  }

  Monitor::reference_sequence& Monitor::
  reference ()
  {
    return this->reference_;
  }

  void Monitor::
  reference (const reference_sequence& s)
  {
    this->reference_ = s;
  }

  const Monitor::indexes_optional& Monitor::
  indexes () const
  {
    return this->indexes_;
  }

  Monitor::indexes_optional& Monitor::
  indexes ()
  {
    return this->indexes_;
  }

  void Monitor::
  indexes (const indexes_type& x)
  {
    this->indexes_.set (x);
  }

  void Monitor::
  indexes (const indexes_optional& x)
  {
    this->indexes_ = x;
  }

  void Monitor::
  indexes (::std::auto_ptr< indexes_type > x)
  {
    this->indexes_.set (x);
  }

  const Monitor::data_optional& Monitor::
  data () const
  {
    return this->data_;
  }

  Monitor::data_optional& Monitor::
  data ()
  {
    return this->data_;
  }

  void Monitor::
  data (const data_type& x)
  {
    this->data_.set (x);
  }

  void Monitor::
  data (const data_optional& x)
  {
    this->data_ = x;
  }

  void Monitor::
  data (::std::auto_ptr< data_type > x)
  {
    this->data_.set (x);
  }

  const Monitor::type_type& Monitor::
  type () const
  {
    return this->type_.get ();
  }

  Monitor::type_type& Monitor::
  type ()
  {
    return this->type_.get ();
  }

  void Monitor::
  type (const type_type& x)
  {
    this->type_.set (x);
  }

  void Monitor::
  type (::std::auto_ptr< type_type > x)
  {
    this->type_.set (x);
  }

  const Monitor::index_type& Monitor::
  index () const
  {
    return this->index_.get ();
  }

  Monitor::index_type& Monitor::
  index ()
  {
    return this->index_.get ();
  }

  void Monitor::
  index (const index_type& x)
  {
    this->index_.set (x);
  }

  const Monitor::target_type& Monitor::
  target () const
  {
    return this->target_.get ();
  }

  Monitor::target_type& Monitor::
  target ()
  {
    return this->target_.get ();
  }

  void Monitor::
  target (const target_type& x)
  {
    this->target_.set (x);
  }

  void Monitor::
  target (::std::auto_ptr< target_type > x)
  {
    this->target_.set (x);
  }

  const Monitor::dx_optional& Monitor::
  dx () const
  {
    return this->dx_;
  }

  Monitor::dx_optional& Monitor::
  dx ()
  {
    return this->dx_;
  }

  void Monitor::
  dx (const dx_type& x)
  {
    this->dx_.set (x);
  }

  void Monitor::
  dx (const dx_optional& x)
  {
    this->dx_ = x;
  }

  const Monitor::dy_optional& Monitor::
  dy () const
  {
    return this->dy_;
  }

  Monitor::dy_optional& Monitor::
  dy ()
  {
    return this->dy_;
  }

  void Monitor::
  dy (const dy_type& x)
  {
    this->dy_.set (x);
  }

  void Monitor::
  dy (const dy_optional& x)
  {
    this->dy_ = x;
  }

  const Monitor::dz_optional& Monitor::
  dz () const
  {
    return this->dz_;
  }

  Monitor::dz_optional& Monitor::
  dz ()
  {
    return this->dz_;
  }

  void Monitor::
  dz (const dz_type& x)
  {
    this->dz_.set (x);
  }

  void Monitor::
  dz (const dz_optional& x)
  {
    this->dz_ = x;
  }


  // MonitorType
  // 

  MonitorType::
  MonitorType (value v)
  : ::xml_schema::string (_xsd_MonitorType_literals_[v])
  {
  }

  MonitorType::
  MonitorType (const char* v)
  : ::xml_schema::string (v)
  {
  }

  MonitorType::
  MonitorType (const ::std::string& v)
  : ::xml_schema::string (v)
  {
  }

  MonitorType::
  MonitorType (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  MonitorType::
  MonitorType (const MonitorType& v,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  MonitorType& MonitorType::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_MonitorType_literals_[v]);

    return *this;
  }


  // MonitoringOut
  // 

  const MonitoringOut::pmlFile_type& MonitoringOut::
  pmlFile () const
  {
    return this->pmlFile_.get ();
  }

  MonitoringOut::pmlFile_type& MonitoringOut::
  pmlFile ()
  {
    return this->pmlFile_.get ();
  }

  void MonitoringOut::
  pmlFile (const pmlFile_type& x)
  {
    this->pmlFile_.set (x);
  }

  void MonitoringOut::
  pmlFile (::std::auto_ptr< pmlFile_type > x)
  {
    this->pmlFile_.set (x);
  }

  const MonitoringOut::time_sequence& MonitoringOut::
  time () const
  {
    return this->time_;
  }

  MonitoringOut::time_sequence& MonitoringOut::
  time ()
  {
    return this->time_;
  }

  void MonitoringOut::
  time (const time_sequence& s)
  {
    this->time_ = s;
  }


  // TimeStep
  // 

  const TimeStep::stoppingCriteria_optional& TimeStep::
  stoppingCriteria () const
  {
    return this->stoppingCriteria_;
  }

  TimeStep::stoppingCriteria_optional& TimeStep::
  stoppingCriteria ()
  {
    return this->stoppingCriteria_;
  }

  void TimeStep::
  stoppingCriteria (const stoppingCriteria_type& x)
  {
    this->stoppingCriteria_.set (x);
  }

  void TimeStep::
  stoppingCriteria (const stoppingCriteria_optional& x)
  {
    this->stoppingCriteria_ = x;
  }

  void TimeStep::
  stoppingCriteria (::std::auto_ptr< stoppingCriteria_type > x)
  {
    this->stoppingCriteria_.set (x);
  }

  const TimeStep::monitor_sequence& TimeStep::
  monitor () const
  {
    return this->monitor_;
  }

  TimeStep::monitor_sequence& TimeStep::
  monitor ()
  {
    return this->monitor_;
  }

  void TimeStep::
  monitor (const monitor_sequence& s)
  {
    this->monitor_ = s;
  }

  const TimeStep::value_type& TimeStep::
  value () const
  {
    return this->value_.get ();
  }

  TimeStep::value_type& TimeStep::
  value ()
  {
    return this->value_.get ();
  }

  void TimeStep::
  value (const value_type& x)
  {
    this->value_.set (x);
  }

  const TimeStep::unit_type& TimeStep::
  unit () const
  {
    return this->unit_.get ();
  }

  TimeStep::unit_type& TimeStep::
  unit ()
  {
    return this->unit_.get ();
  }

  void TimeStep::
  unit (const unit_type& x)
  {
    this->unit_.set (x);
  }

  void TimeStep::
  unit (::std::auto_ptr< unit_type > x)
  {
    this->unit_.set (x);
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace mml
{
  // MonitoringIn
  //

  MonitoringIn::
  MonitoringIn (const dt_type& dt,
                const refresh_type& refresh,
                const simulator_type& simulator)
  : ::xml_schema::type (),
    dt_ (dt, ::xml_schema::flags (), this),
    refresh_ (refresh, ::xml_schema::flags (), this),
    pmlFile_ (::xml_schema::flags (), this),
    simulatorFile_ (::xml_schema::flags (), this),
    lmlFile_ (::xml_schema::flags (), this),
    simulator_ (simulator, ::xml_schema::flags (), this),
    stoppingCriteria_ (::xml_schema::flags (), this),
    monitors_ (::xml_schema::flags (), this)
  {
  }

  MonitoringIn::
  MonitoringIn (::std::auto_ptr< dt_type >& dt,
                ::std::auto_ptr< refresh_type >& refresh,
                const simulator_type& simulator)
  : ::xml_schema::type (),
    dt_ (dt, ::xml_schema::flags (), this),
    refresh_ (refresh, ::xml_schema::flags (), this),
    pmlFile_ (::xml_schema::flags (), this),
    simulatorFile_ (::xml_schema::flags (), this),
    lmlFile_ (::xml_schema::flags (), this),
    simulator_ (simulator, ::xml_schema::flags (), this),
    stoppingCriteria_ (::xml_schema::flags (), this),
    monitors_ (::xml_schema::flags (), this)
  {
  }

  MonitoringIn::
  MonitoringIn (::std::auto_ptr< dt_type >& dt,
                ::std::auto_ptr< refresh_type >& refresh,
                ::std::auto_ptr< simulator_type >& simulator)
  : ::xml_schema::type (),
    dt_ (dt, ::xml_schema::flags (), this),
    refresh_ (refresh, ::xml_schema::flags (), this),
    pmlFile_ (::xml_schema::flags (), this),
    simulatorFile_ (::xml_schema::flags (), this),
    lmlFile_ (::xml_schema::flags (), this),
    simulator_ (simulator, ::xml_schema::flags (), this),
    stoppingCriteria_ (::xml_schema::flags (), this),
    monitors_ (::xml_schema::flags (), this)
  {
  }

  MonitoringIn::
  MonitoringIn (const MonitoringIn& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    dt_ (x.dt_, f, this),
    refresh_ (x.refresh_, f, this),
    pmlFile_ (x.pmlFile_, f, this),
    simulatorFile_ (x.simulatorFile_, f, this),
    lmlFile_ (x.lmlFile_, f, this),
    simulator_ (x.simulator_, f, this),
    stoppingCriteria_ (x.stoppingCriteria_, f, this),
    monitors_ (x.monitors_, f, this)
  {
  }

  MonitoringIn::
  MonitoringIn (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    dt_ (f, this),
    refresh_ (f, this),
    pmlFile_ (f, this),
    simulatorFile_ (f, this),
    lmlFile_ (f, this),
    simulator_ (f, this),
    stoppingCriteria_ (f, this),
    monitors_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false);
      this->parse (p, f);
    }
  }

  void MonitoringIn::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // dt
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "dt",
            "",
            &::xsd::cxx::tree::factory_impl< dt_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!dt_.present ())
          {
            ::std::auto_ptr< dt_type > r (
              dynamic_cast< dt_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->dt_.set (r);
            continue;
          }
        }
      }

      // refresh
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "refresh",
            "",
            &::xsd::cxx::tree::factory_impl< refresh_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!refresh_.present ())
          {
            ::std::auto_ptr< refresh_type > r (
              dynamic_cast< refresh_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->refresh_.set (r);
            continue;
          }
        }
      }

      // pmlFile
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "pmlFile",
            "",
            &::xsd::cxx::tree::factory_impl< pmlFile_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->pmlFile_)
          {
            ::std::auto_ptr< pmlFile_type > r (
              dynamic_cast< pmlFile_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->pmlFile_.set (r);
            continue;
          }
        }
      }

      // simulatorFile
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "simulatorFile",
            "",
            &::xsd::cxx::tree::factory_impl< simulatorFile_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->simulatorFile_)
          {
            ::std::auto_ptr< simulatorFile_type > r (
              dynamic_cast< simulatorFile_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->simulatorFile_.set (r);
            continue;
          }
        }
      }

      // lmlFile
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "lmlFile",
            "",
            &::xsd::cxx::tree::factory_impl< lmlFile_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->lmlFile_)
          {
            ::std::auto_ptr< lmlFile_type > r (
              dynamic_cast< lmlFile_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->lmlFile_.set (r);
            continue;
          }
        }
      }

      // simulator
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "simulator",
            "",
            &::xsd::cxx::tree::factory_impl< simulator_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!simulator_.present ())
          {
            ::std::auto_ptr< simulator_type > r (
              dynamic_cast< simulator_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->simulator_.set (r);
            continue;
          }
        }
      }

      // stoppingCriteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "stoppingCriteria",
            "",
            &::xsd::cxx::tree::factory_impl< stoppingCriteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->stoppingCriteria_)
          {
            ::std::auto_ptr< stoppingCriteria_type > r (
              dynamic_cast< stoppingCriteria_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->stoppingCriteria_.set (r);
            continue;
          }
        }
      }

      // monitors
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "monitors",
            "",
            &::xsd::cxx::tree::factory_impl< monitors_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->monitors_)
          {
            ::std::auto_ptr< monitors_type > r (
              dynamic_cast< monitors_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->monitors_.set (r);
            continue;
          }
        }
      }

      break;
    }

    if (!dt_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "dt",
        "");
    }

    if (!refresh_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "refresh",
        "");
    }

    if (!simulator_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "simulator",
        "");
    }
  }

  MonitoringIn* MonitoringIn::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MonitoringIn (*this, f, c);
  }

  MonitoringIn::
  ~MonitoringIn ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MonitoringIn >
  _xsd_MonitoringIn_type_factory_init (
    "MonitoringIn",
    "");

  // TimeParameter
  //

  TimeParameter::
  TimeParameter (const value_type& value,
                 const unit_type& unit)
  : ::xml_schema::type (),
    value_ (value, ::xml_schema::flags (), this),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  TimeParameter::
  TimeParameter (const ::xml_schema::type& _xsd_type_base,
                 const value_type& value,
                 const unit_type& unit)
  : ::xml_schema::type (_xsd_type_base),
    value_ (value, ::xml_schema::flags (), this),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  TimeParameter::
  TimeParameter (const TimeParameter& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    value_ (x.value_, f, this),
    unit_ (x.unit_, f, this)
  {
  }

  TimeParameter::
  TimeParameter (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    value_ (f, this),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, true);
      this->parse (p, f);
    }
  }

  void TimeParameter::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "value" && n.namespace_ ().empty ())
      {
        this->value_.set (value_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "value",
        "");
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  TimeParameter* TimeParameter::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TimeParameter (*this, f, c);
  }

  TimeParameter::
  ~TimeParameter ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TimeParameter >
  _xsd_TimeParameter_type_factory_init (
    "TimeParameter",
    "");

  // TimeUnit
  //

  TimeUnit::
  TimeUnit (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_TimeUnit_convert ();
  }

  TimeUnit::
  TimeUnit (const ::xercesc::DOMAttr& a,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_TimeUnit_convert ();
  }

  TimeUnit::
  TimeUnit (const ::std::string& s,
            const ::xercesc::DOMElement* e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_TimeUnit_convert ();
  }

  TimeUnit* TimeUnit::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TimeUnit (*this, f, c);
  }

  TimeUnit::value TimeUnit::
  _xsd_TimeUnit_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_TimeUnit_literals_);
    const value* i (::std::lower_bound (
                      _xsd_TimeUnit_indexes_,
                      _xsd_TimeUnit_indexes_ + 3,
                      *this,
                      c));

    if (i == _xsd_TimeUnit_indexes_ + 3 || _xsd_TimeUnit_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const TimeUnit::
  _xsd_TimeUnit_literals_[3] =
  {
    "ms",
    "s",
    "min"
  };

  const TimeUnit::value TimeUnit::
  _xsd_TimeUnit_indexes_[3] =
  {
    ::mml::TimeUnit::min,
    ::mml::TimeUnit::ms,
    ::mml::TimeUnit::s
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TimeUnit >
  _xsd_TimeUnit_type_factory_init (
    "TimeUnit",
    "");

  // StoppingCriteria
  //

  StoppingCriteria::
  StoppingCriteria ()
  : ::xml_schema::type (),
    criteria_ (::xml_schema::flags (), this),
    multipleCriteria_ (::xml_schema::flags (), this)
  {
  }

  StoppingCriteria::
  StoppingCriteria (const StoppingCriteria& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    criteria_ (x.criteria_, f, this),
    multipleCriteria_ (x.multipleCriteria_, f, this)
  {
  }

  StoppingCriteria::
  StoppingCriteria (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    criteria_ (f, this),
    multipleCriteria_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false);
      this->parse (p, f);
    }
  }

  void StoppingCriteria::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // criteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "criteria",
            "",
            &::xsd::cxx::tree::factory_impl< criteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->criteria_)
          {
            ::std::auto_ptr< criteria_type > r (
              dynamic_cast< criteria_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->criteria_.set (r);
            continue;
          }
        }
      }

      // multipleCriteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "multipleCriteria",
            "",
            &::xsd::cxx::tree::factory_impl< multipleCriteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->multipleCriteria_)
          {
            ::std::auto_ptr< multipleCriteria_type > r (
              dynamic_cast< multipleCriteria_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->multipleCriteria_.set (r);
            continue;
          }
        }
      }

      break;
    }
  }

  StoppingCriteria* StoppingCriteria::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class StoppingCriteria (*this, f, c);
  }

  StoppingCriteria::
  ~StoppingCriteria ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, StoppingCriteria >
  _xsd_StoppingCriteria_type_factory_init (
    "StoppingCriteria",
    "");

  // Criteria
  //

  Criteria::
  Criteria (const method_type& method)
  : ::xml_schema::type (),
    method_ (method, ::xml_schema::flags (), this),
    data_ (::xml_schema::flags (), this)
  {
  }

  Criteria::
  Criteria (::std::auto_ptr< method_type >& method)
  : ::xml_schema::type (),
    method_ (method, ::xml_schema::flags (), this),
    data_ (::xml_schema::flags (), this)
  {
  }

  Criteria::
  Criteria (const Criteria& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    method_ (x.method_, f, this),
    data_ (x.data_, f, this)
  {
  }

  Criteria::
  Criteria (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    method_ (f, this),
    data_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false);
      this->parse (p, f);
    }
  }

  void Criteria::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // method
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "method",
            "",
            &::xsd::cxx::tree::factory_impl< method_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!method_.present ())
          {
            ::std::auto_ptr< method_type > r (
              dynamic_cast< method_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->method_.set (r);
            continue;
          }
        }
      }

      // data
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "data",
            "",
            &::xsd::cxx::tree::factory_impl< data_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->data_)
          {
            ::std::auto_ptr< data_type > r (
              dynamic_cast< data_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->data_.set (r);
            continue;
          }
        }
      }

      break;
    }

    if (!method_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "method",
        "");
    }
  }

  Criteria* Criteria::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Criteria (*this, f, c);
  }

  Criteria::
  ~Criteria ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Criteria >
  _xsd_Criteria_type_factory_init (
    "Criteria",
    "");

  // KineticEnergy
  //

  KineticEnergy::
  KineticEnergy (const method_type& method)
  : ::mml::Criteria (method)
  {
  }

  KineticEnergy::
  KineticEnergy (::std::auto_ptr< method_type >& method)
  : ::mml::Criteria (method)
  {
  }

  KineticEnergy::
  KineticEnergy (const KineticEnergy& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::mml::Criteria (x, f, c)
  {
  }

  KineticEnergy::
  KineticEnergy (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::mml::Criteria (e, f, c)
  {
  }

  KineticEnergy* KineticEnergy::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class KineticEnergy (*this, f, c);
  }

  KineticEnergy::
  ~KineticEnergy ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, KineticEnergy >
  _xsd_KineticEnergy_type_factory_init (
    "KineticEnergy",
    "");

  // Speed
  //

  Speed::
  Speed (const method_type& method,
         const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Speed::
  Speed (::std::auto_ptr< method_type >& method,
         const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Speed::
  Speed (const Speed& x,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::mml::Criteria (x, f, c),
    unit_ (x.unit_, f, this)
  {
  }

  Speed::
  Speed (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::mml::Criteria (e, f | ::xml_schema::flags::base, c),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void Speed::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Criteria::parse (p, f);

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  Speed* Speed::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Speed (*this, f, c);
  }

  Speed::
  ~Speed ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Speed >
  _xsd_Speed_type_factory_init (
    "Speed",
    "");

  // SpeedUnit
  //

  SpeedUnit::
  SpeedUnit (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_SpeedUnit_convert ();
  }

  SpeedUnit::
  SpeedUnit (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_SpeedUnit_convert ();
  }

  SpeedUnit::
  SpeedUnit (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_SpeedUnit_convert ();
  }

  SpeedUnit* SpeedUnit::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SpeedUnit (*this, f, c);
  }

  SpeedUnit::value SpeedUnit::
  _xsd_SpeedUnit_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_SpeedUnit_literals_);
    const value* i (::std::lower_bound (
                      _xsd_SpeedUnit_indexes_,
                      _xsd_SpeedUnit_indexes_ + 1,
                      *this,
                      c));

    if (i == _xsd_SpeedUnit_indexes_ + 1 || _xsd_SpeedUnit_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const SpeedUnit::
  _xsd_SpeedUnit_literals_[1] =
  {
    "m/s"
  };

  const SpeedUnit::value SpeedUnit::
  _xsd_SpeedUnit_indexes_[1] =
  {
    ::mml::SpeedUnit::m_s
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, SpeedUnit >
  _xsd_SpeedUnit_type_factory_init (
    "SpeedUnit",
    "");

  // Position
  //

  Position::
  Position (const method_type& method,
            const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Position::
  Position (::std::auto_ptr< method_type >& method,
            const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Position::
  Position (const Position& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::mml::Criteria (x, f, c),
    unit_ (x.unit_, f, this)
  {
  }

  Position::
  Position (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::mml::Criteria (e, f | ::xml_schema::flags::base, c),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void Position::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Criteria::parse (p, f);

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  Position* Position::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Position (*this, f, c);
  }

  Position::
  ~Position ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Position >
  _xsd_Position_type_factory_init (
    "Position",
    "");

  // PositionUnit
  //

  PositionUnit::
  PositionUnit (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_PositionUnit_convert ();
  }

  PositionUnit::
  PositionUnit (const ::xercesc::DOMAttr& a,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_PositionUnit_convert ();
  }

  PositionUnit::
  PositionUnit (const ::std::string& s,
                const ::xercesc::DOMElement* e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_PositionUnit_convert ();
  }

  PositionUnit* PositionUnit::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PositionUnit (*this, f, c);
  }

  PositionUnit::value PositionUnit::
  _xsd_PositionUnit_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_PositionUnit_literals_);
    const value* i (::std::lower_bound (
                      _xsd_PositionUnit_indexes_,
                      _xsd_PositionUnit_indexes_ + 2,
                      *this,
                      c));

    if (i == _xsd_PositionUnit_indexes_ + 2 || _xsd_PositionUnit_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const PositionUnit::
  _xsd_PositionUnit_literals_[2] =
  {
    "nm",
    "mm"
  };

  const PositionUnit::value PositionUnit::
  _xsd_PositionUnit_indexes_[2] =
  {
    ::mml::PositionUnit::mm,
    ::mml::PositionUnit::nm
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, PositionUnit >
  _xsd_PositionUnit_type_factory_init (
    "PositionUnit",
    "");

  // Time
  //

  Time::
  Time (const method_type& method,
        const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Time::
  Time (::std::auto_ptr< method_type >& method,
        const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Time::
  Time (const Time& x,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::mml::Criteria (x, f, c),
    unit_ (x.unit_, f, this)
  {
  }

  Time::
  Time (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::mml::Criteria (e, f | ::xml_schema::flags::base, c),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void Time::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Criteria::parse (p, f);

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  Time* Time::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Time (*this, f, c);
  }

  Time::
  ~Time ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Time >
  _xsd_Time_type_factory_init (
    "Time",
    "");

  // Force
  //

  Force::
  Force (const method_type& method,
         const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Force::
  Force (::std::auto_ptr< method_type >& method,
         const unit_type& unit)
  : ::mml::Criteria (method),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  Force::
  Force (const Force& x,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::mml::Criteria (x, f, c),
    unit_ (x.unit_, f, this)
  {
  }

  Force::
  Force (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::mml::Criteria (e, f | ::xml_schema::flags::base, c),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void Force::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Criteria::parse (p, f);

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  Force* Force::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Force (*this, f, c);
  }

  Force::
  ~Force ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Force >
  _xsd_Force_type_factory_init (
    "Force",
    "");

  // ForceUnit
  //

  ForceUnit::
  ForceUnit (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_ForceUnit_convert ();
  }

  ForceUnit::
  ForceUnit (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_ForceUnit_convert ();
  }

  ForceUnit::
  ForceUnit (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_ForceUnit_convert ();
  }

  ForceUnit* ForceUnit::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ForceUnit (*this, f, c);
  }

  ForceUnit::value ForceUnit::
  _xsd_ForceUnit_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_ForceUnit_literals_);
    const value* i (::std::lower_bound (
                      _xsd_ForceUnit_indexes_,
                      _xsd_ForceUnit_indexes_ + 2,
                      *this,
                      c));

    if (i == _xsd_ForceUnit_indexes_ + 2 || _xsd_ForceUnit_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const ForceUnit::
  _xsd_ForceUnit_literals_[2] =
  {
    "mN",
    "N"
  };

  const ForceUnit::value ForceUnit::
  _xsd_ForceUnit_indexes_[2] =
  {
    ::mml::ForceUnit::N,
    ::mml::ForceUnit::mN
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ForceUnit >
  _xsd_ForceUnit_type_factory_init (
    "ForceUnit",
    "");

  // Method
  //

  Method::
  Method ()
  : ::xml_schema::type (),
    scope_ (::xml_schema::flags (), this)
  {
  }

  Method::
  Method (const Method& x,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    scope_ (x.scope_, f, this)
  {
  }

  Method::
  Method (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    scope_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, true);
      this->parse (p, f);
    }
  }

  void Method::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "scope" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< scope_type > r (
          scope_traits::create (i, f, this));

        this->scope_.set (r);
        continue;
      }
    }
  }

  Method* Method::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Method (*this, f, c);
  }

  Method::
  ~Method ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Method >
  _xsd_Method_type_factory_init (
    "Method",
    "");

  // Threshold
  //

  Threshold::
  Threshold (const maxValue_type& maxValue)
  : ::mml::Method (),
    maxValue_ (maxValue, ::xml_schema::flags (), this)
  {
  }

  Threshold::
  Threshold (const Threshold& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::mml::Method (x, f, c),
    maxValue_ (x.maxValue_, f, this)
  {
  }

  Threshold::
  Threshold (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::mml::Method (e, f | ::xml_schema::flags::base, c),
    maxValue_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, true);
      this->parse (p, f);
    }
  }

  void Threshold::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Method::parse (p, f);

    p.reset_attributes ();

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "maxValue" && n.namespace_ ().empty ())
      {
        this->maxValue_.set (maxValue_traits::create (i, f, this));
        continue;
      }
    }

    if (!maxValue_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "maxValue",
        "");
    }
  }

  Threshold* Threshold::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Threshold (*this, f, c);
  }

  Threshold::
  ~Threshold ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Threshold >
  _xsd_Threshold_type_factory_init (
    "Threshold",
    "");

  // MinThreshold
  //

  MinThreshold::
  MinThreshold (const minValue_type& minValue)
  : ::mml::Method (),
    minValue_ (minValue, ::xml_schema::flags (), this)
  {
  }

  MinThreshold::
  MinThreshold (const MinThreshold& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::mml::Method (x, f, c),
    minValue_ (x.minValue_, f, this)
  {
  }

  MinThreshold::
  MinThreshold (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::mml::Method (e, f | ::xml_schema::flags::base, c),
    minValue_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, true);
      this->parse (p, f);
    }
  }

  void MinThreshold::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::mml::Method::parse (p, f);

    p.reset_attributes ();

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "minValue" && n.namespace_ ().empty ())
      {
        this->minValue_.set (minValue_traits::create (i, f, this));
        continue;
      }
    }

    if (!minValue_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "minValue",
        "");
    }
  }

  MinThreshold* MinThreshold::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MinThreshold (*this, f, c);
  }

  MinThreshold::
  ~MinThreshold ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MinThreshold >
  _xsd_MinThreshold_type_factory_init (
    "MinThreshold",
    "");

  // Scope
  //

  Scope::
  Scope (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_Scope_convert ();
  }

  Scope::
  Scope (const ::xercesc::DOMAttr& a,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_Scope_convert ();
  }

  Scope::
  Scope (const ::std::string& s,
         const ::xercesc::DOMElement* e,
         ::xml_schema::flags f,
         ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_Scope_convert ();
  }

  Scope* Scope::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Scope (*this, f, c);
  }

  Scope::value Scope::
  _xsd_Scope_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_Scope_literals_);
    const value* i (::std::lower_bound (
                      _xsd_Scope_indexes_,
                      _xsd_Scope_indexes_ + 3,
                      *this,
                      c));

    if (i == _xsd_Scope_indexes_ + 3 || _xsd_Scope_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const Scope::
  _xsd_Scope_literals_[3] =
  {
    "Any",
    "Average",
    "Sum"
  };

  const Scope::value Scope::
  _xsd_Scope_indexes_[3] =
  {
    ::mml::Scope::Any,
    ::mml::Scope::Average,
    ::mml::Scope::Sum
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Scope >
  _xsd_Scope_type_factory_init (
    "Scope",
    "");

  // MultipleCriteria
  //

  MultipleCriteria::
  MultipleCriteria (const op_type& op)
  : ::xml_schema::type (),
    multipleCriteria_ (::xml_schema::flags (), this),
    criteria_ (::xml_schema::flags (), this),
    op_ (op, ::xml_schema::flags (), this)
  {
  }

  MultipleCriteria::
  MultipleCriteria (const MultipleCriteria& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    multipleCriteria_ (x.multipleCriteria_, f, this),
    criteria_ (x.criteria_, f, this),
    op_ (x.op_, f, this)
  {
  }

  MultipleCriteria::
  MultipleCriteria (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    multipleCriteria_ (f, this),
    criteria_ (f, this),
    op_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void MultipleCriteria::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // multipleCriteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "multipleCriteria",
            "",
            &::xsd::cxx::tree::factory_impl< multipleCriteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< multipleCriteria_type > r (
            dynamic_cast< multipleCriteria_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->multipleCriteria_.push_back (r);
          continue;
        }
      }

      // criteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "criteria",
            "",
            &::xsd::cxx::tree::factory_impl< criteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< criteria_type > r (
            dynamic_cast< criteria_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->criteria_.push_back (r);
          continue;
        }
      }

      break;
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "op" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< op_type > r (
          op_traits::create (i, f, this));

        this->op_.set (r);
        continue;
      }
    }

    if (!op_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "op",
        "");
    }
  }

  MultipleCriteria* MultipleCriteria::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MultipleCriteria (*this, f, c);
  }

  MultipleCriteria::
  ~MultipleCriteria ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MultipleCriteria >
  _xsd_MultipleCriteria_type_factory_init (
    "MultipleCriteria",
    "");

  // LogicalOp
  //

  LogicalOp::
  LogicalOp (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_LogicalOp_convert ();
  }

  LogicalOp::
  LogicalOp (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_LogicalOp_convert ();
  }

  LogicalOp::
  LogicalOp (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_LogicalOp_convert ();
  }

  LogicalOp* LogicalOp::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class LogicalOp (*this, f, c);
  }

  LogicalOp::value LogicalOp::
  _xsd_LogicalOp_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_LogicalOp_literals_);
    const value* i (::std::lower_bound (
                      _xsd_LogicalOp_indexes_,
                      _xsd_LogicalOp_indexes_ + 2,
                      *this,
                      c));

    if (i == _xsd_LogicalOp_indexes_ + 2 || _xsd_LogicalOp_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const LogicalOp::
  _xsd_LogicalOp_literals_[2] =
  {
    "And",
    "Or"
  };

  const LogicalOp::value LogicalOp::
  _xsd_LogicalOp_indexes_[2] =
  {
    ::mml::LogicalOp::And,
    ::mml::LogicalOp::Or
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, LogicalOp >
  _xsd_LogicalOp_type_factory_init (
    "LogicalOp",
    "");

  // Monitors
  //

  Monitors::
  Monitors ()
  : ::xml_schema::type (),
    monitor_ (::xml_schema::flags (), this)
  {
  }

  Monitors::
  Monitors (const Monitors& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    monitor_ (x.monitor_, f, this)
  {
  }

  Monitors::
  Monitors (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    monitor_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false);
      this->parse (p, f);
    }
  }

  void Monitors::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // monitor
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "monitor",
            "",
            &::xsd::cxx::tree::factory_impl< monitor_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< monitor_type > r (
            dynamic_cast< monitor_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->monitor_.push_back (r);
          continue;
        }
      }

      break;
    }
  }

  Monitors* Monitors::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Monitors (*this, f, c);
  }

  Monitors::
  ~Monitors ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Monitors >
  _xsd_Monitors_type_factory_init (
    "Monitors",
    "");

  // Reference
  //

  Reference::
  Reference (const document_type& document)
  : ::xml_schema::type (),
    document_ (document, ::xml_schema::flags (), this),
    monitorIndex_ (::xml_schema::flags (), this),
    target_ (::xml_schema::flags (), this)
  {
  }

  Reference::
  Reference (const ::xml_schema::type& _xsd_type_base,
             const document_type& document)
  : ::xml_schema::type (_xsd_type_base),
    document_ (document, ::xml_schema::flags (), this),
    monitorIndex_ (::xml_schema::flags (), this),
    target_ (::xml_schema::flags (), this)
  {
  }

  Reference::
  Reference (const Reference& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    document_ (x.document_, f, this),
    monitorIndex_ (x.monitorIndex_, f, this),
    target_ (x.target_, f, this)
  {
  }

  Reference::
  Reference (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    document_ (f, this),
    monitorIndex_ (f, this),
    target_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, true);
      this->parse (p, f);
    }
  }

  void Reference::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "document" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< document_type > r (
          document_traits::create (i, f, this));

        this->document_.set (r);
        continue;
      }

      if (n.name () == "monitorIndex" && n.namespace_ ().empty ())
      {
        this->monitorIndex_.set (monitorIndex_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "target" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< target_type > r (
          target_traits::create (i, f, this));

        this->target_.set (r);
        continue;
      }
    }

    if (!document_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "document",
        "");
    }
  }

  Reference* Reference::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Reference (*this, f, c);
  }

  Reference::
  ~Reference ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Reference >
  _xsd_Reference_type_factory_init (
    "Reference",
    "");

  // Monitor
  //

  Monitor::
  Monitor (const startAt_type& startAt,
           const stopAt_type& stopAt,
           const type_type& type,
           const index_type& index,
           const target_type& target)
  : ::xml_schema::type (),
    startAt_ (startAt, ::xml_schema::flags (), this),
    stopAt_ (stopAt, ::xml_schema::flags (), this),
    reference_ (::xml_schema::flags (), this),
    indexes_ (::xml_schema::flags (), this),
    data_ (::xml_schema::flags (), this),
    type_ (type, ::xml_schema::flags (), this),
    index_ (index, ::xml_schema::flags (), this),
    target_ (target, ::xml_schema::flags (), this),
    dx_ (::xml_schema::flags (), this),
    dy_ (::xml_schema::flags (), this),
    dz_ (::xml_schema::flags (), this)
  {
  }

  Monitor::
  Monitor (::std::auto_ptr< startAt_type >& startAt,
           ::std::auto_ptr< stopAt_type >& stopAt,
           const type_type& type,
           const index_type& index,
           const target_type& target)
  : ::xml_schema::type (),
    startAt_ (startAt, ::xml_schema::flags (), this),
    stopAt_ (stopAt, ::xml_schema::flags (), this),
    reference_ (::xml_schema::flags (), this),
    indexes_ (::xml_schema::flags (), this),
    data_ (::xml_schema::flags (), this),
    type_ (type, ::xml_schema::flags (), this),
    index_ (index, ::xml_schema::flags (), this),
    target_ (target, ::xml_schema::flags (), this),
    dx_ (::xml_schema::flags (), this),
    dy_ (::xml_schema::flags (), this),
    dz_ (::xml_schema::flags (), this)
  {
  }

  Monitor::
  Monitor (const Monitor& x,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    startAt_ (x.startAt_, f, this),
    stopAt_ (x.stopAt_, f, this),
    reference_ (x.reference_, f, this),
    indexes_ (x.indexes_, f, this),
    data_ (x.data_, f, this),
    type_ (x.type_, f, this),
    index_ (x.index_, f, this),
    target_ (x.target_, f, this),
    dx_ (x.dx_, f, this),
    dy_ (x.dy_, f, this),
    dz_ (x.dz_, f, this)
  {
  }

  Monitor::
  Monitor (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    startAt_ (f, this),
    stopAt_ (f, this),
    reference_ (f, this),
    indexes_ (f, this),
    data_ (f, this),
    type_ (f, this),
    index_ (f, this),
    target_ (f, this),
    dx_ (f, this),
    dy_ (f, this),
    dz_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void Monitor::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // startAt
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "startAt",
            "",
            &::xsd::cxx::tree::factory_impl< startAt_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!startAt_.present ())
          {
            ::std::auto_ptr< startAt_type > r (
              dynamic_cast< startAt_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->startAt_.set (r);
            continue;
          }
        }
      }

      // stopAt
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "stopAt",
            "",
            &::xsd::cxx::tree::factory_impl< stopAt_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!stopAt_.present ())
          {
            ::std::auto_ptr< stopAt_type > r (
              dynamic_cast< stopAt_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->stopAt_.set (r);
            continue;
          }
        }
      }

      // reference
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "reference",
            "",
            &::xsd::cxx::tree::factory_impl< reference_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< reference_type > r (
            dynamic_cast< reference_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->reference_.push_back (r);
          continue;
        }
      }

      // indexes
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "indexes",
            "",
            &::xsd::cxx::tree::factory_impl< indexes_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->indexes_)
          {
            ::std::auto_ptr< indexes_type > r (
              dynamic_cast< indexes_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->indexes_.set (r);
            continue;
          }
        }
      }

      // data
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "data",
            "",
            &::xsd::cxx::tree::factory_impl< data_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->data_)
          {
            ::std::auto_ptr< data_type > r (
              dynamic_cast< data_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->data_.set (r);
            continue;
          }
        }
      }

      break;
    }

    if (!startAt_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "startAt",
        "");
    }

    if (!stopAt_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "stopAt",
        "");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "type" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< type_type > r (
          type_traits::create (i, f, this));

        this->type_.set (r);
        continue;
      }

      if (n.name () == "index" && n.namespace_ ().empty ())
      {
        this->index_.set (index_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "target" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< target_type > r (
          target_traits::create (i, f, this));

        this->target_.set (r);
        continue;
      }

      if (n.name () == "dx" && n.namespace_ ().empty ())
      {
        this->dx_.set (dx_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "dy" && n.namespace_ ().empty ())
      {
        this->dy_.set (dy_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "dz" && n.namespace_ ().empty ())
      {
        this->dz_.set (dz_traits::create (i, f, this));
        continue;
      }
    }

    if (!type_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "type",
        "");
    }

    if (!index_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "index",
        "");
    }

    if (!target_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "target",
        "");
    }
  }

  Monitor* Monitor::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Monitor (*this, f, c);
  }

  Monitor::
  ~Monitor ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, Monitor >
  _xsd_Monitor_type_factory_init (
    "Monitor",
    "");

  // MonitorType
  //

  MonitorType::
  MonitorType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_MonitorType_convert ();
  }

  MonitorType::
  MonitorType (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_MonitorType_convert ();
  }

  MonitorType::
  MonitorType (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_MonitorType_convert ();
  }

  MonitorType* MonitorType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MonitorType (*this, f, c);
  }

  MonitorType::value MonitorType::
  _xsd_MonitorType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_MonitorType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_MonitorType_indexes_,
                      _xsd_MonitorType_indexes_ + 10,
                      *this,
                      c));

    if (i == _xsd_MonitorType_indexes_ + 10 || _xsd_MonitorType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const MonitorType::
  _xsd_MonitorType_literals_[10] =
  {
    "Position",
    "REN",
    "GeomDeviation",
    "Force",
    "PointSetDistance",
    "PointFinalSetDistance",
    "Volume",
    "Surface",
    "Displacement",
    "NormDisplacement"
  };

  const MonitorType::value MonitorType::
  _xsd_MonitorType_indexes_[10] =
  {
    ::mml::MonitorType::Displacement,
    ::mml::MonitorType::Force,
    ::mml::MonitorType::GeomDeviation,
    ::mml::MonitorType::NormDisplacement,
    ::mml::MonitorType::PointFinalSetDistance,
    ::mml::MonitorType::PointSetDistance,
    ::mml::MonitorType::Position,
    ::mml::MonitorType::REN,
    ::mml::MonitorType::Surface,
    ::mml::MonitorType::Volume
  };

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MonitorType >
  _xsd_MonitorType_type_factory_init (
    "MonitorType",
    "");

  // MonitoringOut
  //

  MonitoringOut::
  MonitoringOut (const pmlFile_type& pmlFile)
  : ::xml_schema::type (),
    pmlFile_ (pmlFile, ::xml_schema::flags (), this),
    time_ (::xml_schema::flags (), this)
  {
  }

  MonitoringOut::
  MonitoringOut (::std::auto_ptr< pmlFile_type >& pmlFile)
  : ::xml_schema::type (),
    pmlFile_ (pmlFile, ::xml_schema::flags (), this),
    time_ (::xml_schema::flags (), this)
  {
  }

  MonitoringOut::
  MonitoringOut (const MonitoringOut& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    pmlFile_ (x.pmlFile_, f, this),
    time_ (x.time_, f, this)
  {
  }

  MonitoringOut::
  MonitoringOut (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    pmlFile_ (f, this),
    time_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false);
      this->parse (p, f);
    }
  }

  void MonitoringOut::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // pmlFile
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "pmlFile",
            "",
            &::xsd::cxx::tree::factory_impl< pmlFile_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!pmlFile_.present ())
          {
            ::std::auto_ptr< pmlFile_type > r (
              dynamic_cast< pmlFile_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->pmlFile_.set (r);
            continue;
          }
        }
      }

      // time
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "time",
            "",
            &::xsd::cxx::tree::factory_impl< time_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< time_type > r (
            dynamic_cast< time_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->time_.push_back (r);
          continue;
        }
      }

      break;
    }

    if (!pmlFile_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "pmlFile",
        "");
    }
  }

  MonitoringOut* MonitoringOut::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MonitoringOut (*this, f, c);
  }

  MonitoringOut::
  ~MonitoringOut ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MonitoringOut >
  _xsd_MonitoringOut_type_factory_init (
    "MonitoringOut",
    "");

  // TimeStep
  //

  TimeStep::
  TimeStep (const value_type& value,
            const unit_type& unit)
  : ::xml_schema::type (),
    stoppingCriteria_ (::xml_schema::flags (), this),
    monitor_ (::xml_schema::flags (), this),
    value_ (value, ::xml_schema::flags (), this),
    unit_ (unit, ::xml_schema::flags (), this)
  {
  }

  TimeStep::
  TimeStep (const TimeStep& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    stoppingCriteria_ (x.stoppingCriteria_, f, this),
    monitor_ (x.monitor_, f, this),
    value_ (x.value_, f, this),
    unit_ (x.unit_, f, this)
  {
  }

  TimeStep::
  TimeStep (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    stoppingCriteria_ (f, this),
    monitor_ (f, this),
    value_ (f, this),
    unit_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, true);
      this->parse (p, f);
    }
  }

  void TimeStep::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // stoppingCriteria
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "stoppingCriteria",
            "",
            &::xsd::cxx::tree::factory_impl< stoppingCriteria_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->stoppingCriteria_)
          {
            ::std::auto_ptr< stoppingCriteria_type > r (
              dynamic_cast< stoppingCriteria_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->stoppingCriteria_.set (r);
            continue;
          }
        }
      }

      // monitor
      //
      {
        ::xsd::cxx::tree::type_factory_map< char >& tfm (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ());

        ::std::auto_ptr< ::xsd::cxx::tree::type > tmp (
          tfm.create (
            "monitor",
            "",
            &::xsd::cxx::tree::factory_impl< monitor_type >,
            false, false, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::auto_ptr< monitor_type > r (
            dynamic_cast< monitor_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->monitor_.push_back (r);
          continue;
        }
      }

      break;
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "value" && n.namespace_ ().empty ())
      {
        this->value_.set (value_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "unit" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< unit_type > r (
          unit_traits::create (i, f, this));

        this->unit_.set (r);
        continue;
      }
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "value",
        "");
    }

    if (!unit_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "unit",
        "");
    }
  }

  TimeStep* TimeStep::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TimeStep (*this, f, c);
  }

  TimeStep::
  ~TimeStep ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TimeStep >
  _xsd_TimeStep_type_factory_init (
    "TimeStep",
    "");
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace mml
{
}

#include <ostream>
#include <xsd/cxx/xml/dom/serialization-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace mml
{
  void
  operator<< (::xercesc::DOMElement& e, const MonitoringIn& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // dt
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const MonitoringIn::dt_type& x (i.dt ());
      if (typeid (MonitoringIn::dt_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "dt",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "dt",
          "",
          false, false, e, x);
    }

    // refresh
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const MonitoringIn::refresh_type& x (i.refresh ());
      if (typeid (MonitoringIn::refresh_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "refresh",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "refresh",
          "",
          false, false, e, x);
    }

    // pmlFile
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.pmlFile ())
      {
        const MonitoringIn::pmlFile_type& x (*i.pmlFile ());
        if (typeid (MonitoringIn::pmlFile_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "pmlFile",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "pmlFile",
            "",
            false, false, e, x);
      }
    }

    // simulatorFile
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.simulatorFile ())
      {
        const MonitoringIn::simulatorFile_type& x (*i.simulatorFile ());
        if (typeid (MonitoringIn::simulatorFile_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "simulatorFile",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "simulatorFile",
            "",
            false, false, e, x);
      }
    }

    // lmlFile
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.lmlFile ())
      {
        const MonitoringIn::lmlFile_type& x (*i.lmlFile ());
        if (typeid (MonitoringIn::lmlFile_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "lmlFile",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "lmlFile",
            "",
            false, false, e, x);
      }
    }

    // simulator
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const MonitoringIn::simulator_type& x (i.simulator ());
      if (typeid (MonitoringIn::simulator_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "simulator",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "simulator",
          "",
          false, false, e, x);
    }

    // stoppingCriteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.stoppingCriteria ())
      {
        const MonitoringIn::stoppingCriteria_type& x (*i.stoppingCriteria ());
        if (typeid (MonitoringIn::stoppingCriteria_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "stoppingCriteria",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "stoppingCriteria",
            "",
            false, false, e, x);
      }
    }

    // monitors
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.monitors ())
      {
        const MonitoringIn::monitors_type& x (*i.monitors ());
        if (typeid (MonitoringIn::monitors_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "monitors",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "monitors",
            "",
            false, false, e, x);
      }
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MonitoringIn >
  _xsd_MonitoringIn_type_serializer_init (
    "MonitoringIn",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const TimeParameter& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // value
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "value",
          e));

      a << ::xml_schema::as_double(i.value ());
    }

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TimeParameter >
  _xsd_TimeParameter_type_serializer_init (
    "TimeParameter",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const TimeUnit& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const TimeUnit& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const TimeUnit& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TimeUnit >
  _xsd_TimeUnit_type_serializer_init (
    "TimeUnit",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const StoppingCriteria& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // criteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.criteria ())
      {
        const StoppingCriteria::criteria_type& x (*i.criteria ());
        if (typeid (StoppingCriteria::criteria_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "criteria",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "criteria",
            "",
            false, false, e, x);
      }
    }

    // multipleCriteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.multipleCriteria ())
      {
        const StoppingCriteria::multipleCriteria_type& x (*i.multipleCriteria ());
        if (typeid (StoppingCriteria::multipleCriteria_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "multipleCriteria",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "multipleCriteria",
            "",
            false, false, e, x);
      }
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, StoppingCriteria >
  _xsd_StoppingCriteria_type_serializer_init (
    "StoppingCriteria",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Criteria& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // method
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const Criteria::method_type& x (i.method ());
      if (typeid (Criteria::method_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "method",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "method",
          "",
          false, false, e, x);
    }

    // data
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.data ())
      {
        const Criteria::data_type& x (*i.data ());
        if (typeid (Criteria::data_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "data",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "data",
            "",
            false, false, e, x);
      }
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Criteria >
  _xsd_Criteria_type_serializer_init (
    "Criteria",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const KineticEnergy& i)
  {
    e << static_cast< const ::mml::Criteria& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, KineticEnergy >
  _xsd_KineticEnergy_type_serializer_init (
    "KineticEnergy",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Speed& i)
  {
    e << static_cast< const ::mml::Criteria& > (i);

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Speed >
  _xsd_Speed_type_serializer_init (
    "Speed",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const SpeedUnit& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const SpeedUnit& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const SpeedUnit& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, SpeedUnit >
  _xsd_SpeedUnit_type_serializer_init (
    "SpeedUnit",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Position& i)
  {
    e << static_cast< const ::mml::Criteria& > (i);

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Position >
  _xsd_Position_type_serializer_init (
    "Position",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const PositionUnit& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const PositionUnit& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const PositionUnit& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, PositionUnit >
  _xsd_PositionUnit_type_serializer_init (
    "PositionUnit",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Time& i)
  {
    e << static_cast< const ::mml::Criteria& > (i);

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Time >
  _xsd_Time_type_serializer_init (
    "Time",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Force& i)
  {
    e << static_cast< const ::mml::Criteria& > (i);

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Force >
  _xsd_Force_type_serializer_init (
    "Force",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const ForceUnit& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ForceUnit& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ForceUnit& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ForceUnit >
  _xsd_ForceUnit_type_serializer_init (
    "ForceUnit",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Method& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // scope
    //
    if (i.scope ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "scope",
          e));

      a << *i.scope ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Method >
  _xsd_Method_type_serializer_init (
    "Method",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Threshold& i)
  {
    e << static_cast< const ::mml::Method& > (i);

    // maxValue
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "maxValue",
          e));

      a << ::xml_schema::as_double(i.maxValue ());
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Threshold >
  _xsd_Threshold_type_serializer_init (
    "Threshold",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const MinThreshold& i)
  {
    e << static_cast< const ::mml::Method& > (i);

    // minValue
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "minValue",
          e));

      a << ::xml_schema::as_double(i.minValue ());
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MinThreshold >
  _xsd_MinThreshold_type_serializer_init (
    "MinThreshold",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Scope& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const Scope& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const Scope& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Scope >
  _xsd_Scope_type_serializer_init (
    "Scope",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const MultipleCriteria& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // multipleCriteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (MultipleCriteria::multipleCriteria_const_iterator
           b (i.multipleCriteria ().begin ()), n (i.multipleCriteria ().end ());
           b != n; ++b)
      {
        if (typeid (MultipleCriteria::multipleCriteria_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "multipleCriteria",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "multipleCriteria",
            "",
            false, false, e, *b);
      }
    }

    // criteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (MultipleCriteria::criteria_const_iterator
           b (i.criteria ().begin ()), n (i.criteria ().end ());
           b != n; ++b)
      {
        if (typeid (MultipleCriteria::criteria_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "criteria",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "criteria",
            "",
            false, false, e, *b);
      }
    }

    // op
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "op",
          e));

      a << i.op ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MultipleCriteria >
  _xsd_MultipleCriteria_type_serializer_init (
    "MultipleCriteria",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const LogicalOp& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const LogicalOp& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const LogicalOp& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, LogicalOp >
  _xsd_LogicalOp_type_serializer_init (
    "LogicalOp",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Monitors& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // monitor
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (Monitors::monitor_const_iterator
           b (i.monitor ().begin ()), n (i.monitor ().end ());
           b != n; ++b)
      {
        if (typeid (Monitors::monitor_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "monitor",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "monitor",
            "",
            false, false, e, *b);
      }
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Monitors >
  _xsd_Monitors_type_serializer_init (
    "Monitors",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Reference& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // document
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "document",
          e));

      a << i.document ();
    }

    // monitorIndex
    //
    if (i.monitorIndex ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "monitorIndex",
          e));

      a << *i.monitorIndex ();
    }

    // target
    //
    if (i.target ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "target",
          e));

      a << *i.target ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Reference >
  _xsd_Reference_type_serializer_init (
    "Reference",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const Monitor& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // startAt
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const Monitor::startAt_type& x (i.startAt ());
      if (typeid (Monitor::startAt_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "startAt",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "startAt",
          "",
          false, false, e, x);
    }

    // stopAt
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const Monitor::stopAt_type& x (i.stopAt ());
      if (typeid (Monitor::stopAt_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "stopAt",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "stopAt",
          "",
          false, false, e, x);
    }

    // reference
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (Monitor::reference_const_iterator
           b (i.reference ().begin ()), n (i.reference ().end ());
           b != n; ++b)
      {
        if (typeid (Monitor::reference_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "reference",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "reference",
            "",
            false, false, e, *b);
      }
    }

    // indexes
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.indexes ())
      {
        const Monitor::indexes_type& x (*i.indexes ());
        if (typeid (Monitor::indexes_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "indexes",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "indexes",
            "",
            false, false, e, x);
      }
    }

    // data
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.data ())
      {
        const Monitor::data_type& x (*i.data ());
        if (typeid (Monitor::data_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "data",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "data",
            "",
            false, false, e, x);
      }
    }

    // type
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "type",
          e));

      a << i.type ();
    }

    // index
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "index",
          e));

      a << i.index ();
    }

    // target
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "target",
          e));

      a << i.target ();
    }

    // dx
    //
    if (i.dx ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "dx",
          e));

      a << ::xml_schema::as_double(*i.dx ());
    }

    // dy
    //
    if (i.dy ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "dy",
          e));

      a << ::xml_schema::as_double(*i.dy ());
    }

    // dz
    //
    if (i.dz ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "dz",
          e));

      a << ::xml_schema::as_double(*i.dz ());
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, Monitor >
  _xsd_Monitor_type_serializer_init (
    "Monitor",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const MonitorType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const MonitorType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const MonitorType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MonitorType >
  _xsd_MonitorType_type_serializer_init (
    "MonitorType",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const MonitoringOut& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // pmlFile
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const MonitoringOut::pmlFile_type& x (i.pmlFile ());
      if (typeid (MonitoringOut::pmlFile_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "pmlFile",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "pmlFile",
          "",
          false, false, e, x);
    }

    // time
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (MonitoringOut::time_const_iterator
           b (i.time ().begin ()), n (i.time ().end ());
           b != n; ++b)
      {
        if (typeid (MonitoringOut::time_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "time",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "time",
            "",
            false, false, e, *b);
      }
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MonitoringOut >
  _xsd_MonitoringOut_type_serializer_init (
    "MonitoringOut",
    "");


  void
  operator<< (::xercesc::DOMElement& e, const TimeStep& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // stoppingCriteria
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.stoppingCriteria ())
      {
        const TimeStep::stoppingCriteria_type& x (*i.stoppingCriteria ());
        if (typeid (TimeStep::stoppingCriteria_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "stoppingCriteria",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "stoppingCriteria",
            "",
            false, false, e, x);
      }
    }

    // monitor
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (TimeStep::monitor_const_iterator
           b (i.monitor ().begin ()), n (i.monitor ().end ());
           b != n; ++b)
      {
        if (typeid (TimeStep::monitor_type) == typeid (*b))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "monitor",
              e));

          s << *b;
        }
        else
          tsm.serialize (
            "monitor",
            "",
            false, false, e, *b);
      }
    }

    // value
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "value",
          e));

      a << ::xml_schema::as_double(i.value ());
    }

    // unit
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "unit",
          e));

      a << i.unit ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TimeStep >
  _xsd_TimeStep_type_serializer_init (
    "TimeStep",
    "");
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

