/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef SINGLEIMAGEVOLUMEComponentPOPUP_H
#define SINGLEIMAGEVOLUMEComponentPOPUP_H

// -- Core stuff
#include "ComponentPopupMenu.h"

namespace camitk
{
  
  
// -- Core image component stuff classes
class SingleImageComponent;


/** The popup menu of the SingleImage data component.
  *
  */

class SingleImageComponentPopup : public ComponentPopupMenu  {

    Q_OBJECT

  public:
    SingleImageComponentPopup(camitk::Component *, QWidget*);

	/// Update the menu depending on the state
	void updateDisplayIn3D(bool visible);


  public slots:

    /// Show/hide the current slice in the 3D viewer.
    void displayIn3D();



  private:
    /// The id of the displayIn3D action in the popup menu
    QAction* displayIn3Did;
};

}
#endif
