/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core image component stuff
#include "SingleImageComponentPopup.h"

// -- Core stuff
#include "Component.h"
#include "InteractiveViewer.h"


namespace camitk {
// ---------------------- constructor ----------------------------
SingleImageComponentPopup::SingleImageComponentPopup ( Component *dc, QWidget *parent )
        : ComponentPopupMenu ( dc, parent ) {
    displayIn3Did = addAction ( "Show Slice In 3D", SLOT ( displayIn3D() ), true );
    displayIn3Did->setChecked ( true );
}


// ---------------------- displayIn3D ----------------------------
void SingleImageComponentPopup::displayIn3D() {
    // if true, display in 3D, else hide.
    myComponent->setVisibility ( InteractiveViewer::get3DViewer(), displayIn3Did->isChecked() );
    InteractiveViewer::get3DViewer()->refresh();
}

// ---------------------- updateDisplayIn3D ----------------------------
void SingleImageComponentPopup::updateDisplayIn3D ( bool visible ) {
    displayIn3Did->blockSignals ( true );
    displayIn3Did->setChecked ( visible );
    displayIn3Did->blockSignals ( false );
}
}
