/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#include "ActionWidget.h"
#include "Action.h"
#include "ObjectController.h"
#include "Component.h"

namespace camitk {

// -------------------- constructor --------------------
ActionWidget::ActionWidget(Action *action): QFrame() {
    myAction = action;
    // create the property editor tab itself
    setObjectName(myAction->getName());

    QVBoxLayout * widgetLayout = new QVBoxLayout;

    QHBoxLayout *nameLayout = new QHBoxLayout;
    QLabel *iconPicture = new QLabel;
    iconPicture->setPixmap(myAction->getIcon());
    nameLayout->addWidget(iconPicture);
    actionNameLabel= new QLabel(myAction->getName());
    nameLayout->addWidget(actionNameLabel);
    widgetLayout->addLayout(nameLayout);

    // get the proper text height
    actionNameLabel->adjustSize();
    // fix the icon height
    iconPicture->setFixedSize(actionNameLabel->height(), actionNameLabel->height());
    iconPicture->setScaledContents(true);

    descriptionLabel = new QLabel("Description : " + myAction->getDescription());
    descriptionLabel->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    descriptionLabel->setLineWidth(3);
    descriptionLabel->setWordWrap(true);
    widgetLayout->addWidget(descriptionLabel);

    targetLabel = new QLabel(getTargetLabel());
    targetLabel->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    targetLabel->setLineWidth(3);
    targetLabel->setWordWrap(true);
    widgetLayout->addWidget(targetLabel);

    // first the property editor
    objectController = new ObjectController(this, ObjectController::BUTTON);
    widgetLayout->addWidget(objectController);

    // then the buttons
    buttonFrame = new QFrame();
    QHBoxLayout *buttonLayout = new QHBoxLayout;

    QPushButton *applyButton = new QPushButton("Apply");
    buttonLayout->addWidget(applyButton);

    QPushButton *revertButton = new QPushButton("Revert");
    buttonLayout->addWidget(revertButton);

    buttonFrame->setLayout(buttonLayout);
    widgetLayout->addWidget(buttonFrame);

    // connect the buttons
    QObject::connect(applyButton, SIGNAL(clicked()), objectController, SLOT(apply()));
    // from http://doc.trolltech.com/4.7/signalsandslots.html
    // "If several slots are connected to one signal, the slots will be executed one after the other,
    // in the order they have been connected, when the signal is emitted."
    // it means that here when the user click on apply, it will first update the properties
    // and then call the apply() method
    QObject::connect(applyButton, SIGNAL(clicked()), myAction, SLOT(apply()));
    QObject::connect(revertButton, SIGNAL(clicked()), objectController, SLOT(revert()));

    setLayout(widgetLayout);

    // Now tell the ObjectController that this Action itself is the one to manage
    objectController->setObject(myAction);
}

// -------------------- destructor --------------------
ActionWidget::~ActionWidget() {
    // TODO delete
}

// -------------------- setButtonVisibility --------------------
void ActionWidget::setButtonVisibility(bool visible) {
    buttonFrame->setVisible(visible);
}

// -------------------- setNameVisibility --------------------
void ActionWidget::setNameVisibility(bool visible) {
    this->actionNameLabel->setVisible(visible);
}

// -------------------- setDescriptionVisibility --------------------
void ActionWidget::setDescriptionVisibility(bool visible) {
    this->descriptionLabel->setVisible(visible);
}

// -------------------- update --------------------
void ActionWidget::updateTargets() {
    // force update
    objectController->setObject(NULL);
    objectController->setObject(myAction);
    targetLabel->setText(getTargetLabel());
}

// -------------------- getTargetLabel --------------------
QString ActionWidget::getTargetLabel() {
    QString targetNames;
    foreach (Component * comp, myAction->getTargets()) {
        targetNames += comp->getName() + " (" + comp->metaObject()->className() + ")" + "<br/>";
    }
    return targetNames;
}

}
