/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290)
#endif

#ifndef VTK_MANAGER_Component_PROPERTIES_H
#define VTK_MANAGER_Component_PROPERTIES_H

// SPECIFIC includes
#include "VtkMeshComponent.h"
using namespace camitk;

// Camitk includes
#include "VtkMeshComponentAPI.h"
// QT includes
#include <QObject>
#include <QMap>
#include <QColor>

/**
*	The class VtkMeshComponentProperties defines properties for VtkMeshComponent.
*
*/
class VTK_COMPONENT_API VtkMeshComponentProperties : public QObject {
    Q_OBJECT

    /// Shading interpolation
    //Q_PROPERTY( ShadingInterpolation interpolation READ getInterpolation WRITE setInterpolation )

    /// Color
    //Q_PROPERTY(QMap color READ getColor WRITE setColor )

    /// Ambient ligthing coefficient.
    Q_PROPERTY( double ambient READ getAmbient WRITE setAmbient )

    /// Diffuse ligthing coefficient.
    Q_PROPERTY( double diffuse READ getDiffuse WRITE setDiffuse )

    /// Specular ligthing coefficient.
    Q_PROPERTY( double specular READ getSpecular WRITE setSpecular )

    /// Specular power ligthing coefficient.
    Q_PROPERTY( double specularPower READ getSpecularPower WRITE setSpecularPower )

    /// Specular opacity coefficient.
    Q_PROPERTY( double opacity READ getOpacity WRITE setOpacity )

    /// Ambient color
    //Q_PROPERTY(QMap ambientColor READ getAmbientColor WRITE setAmbientColor )

    /// Diffuse color
    //Q_PROPERTY(QMap diffuseColor READ getDiffuseColor WRITE setDiffuseColor )

    /// Specular color
    //Q_PROPERTY(QMap specularColor READ getSpecularColor WRITE setSpecularColor )

    /// Specular color
    Q_PROPERTY(QColor specularColor READ getSpecularColor WRITE setSpecularColor )

    /// Line width.
    //Q_PROPERTY( float lineWidth READ getLineWidth WRITE setLineWidth )

    /// Point size.
    //Q_PROPERTY( float pointSize READ getPointSize WRITE setPointSize )


public:

    /// Available source devices.
    enum ShadingInterpolation {
        FLAT,			///< FLAT interpolation
        GOURAUD,		///< GOURAUD interpolation
        PHONG			///< PHONG interpolation
    };

    /** Default construtor.
    * @param comp The associated Component. 
    */
    VtkMeshComponentProperties( VtkMeshComponent * comp );

    /** Destructor. */
    ~VtkMeshComponentProperties() {}

// ####################   GETTERS   ###########################################

    /** Get the shading interpolation. */
    //ShadingInterpolation getInterpolation() const;

    /** Get the color. */
    //QMap<double, QVariant> getColor() const;

    /** Get the ambient lighting coefficient. */
    double getAmbient() const;

    /** Get the diffuse lighting coefficient. */
    double getDiffuse() const;

    /** Get the specular lighting coefficient. */
    double getSpecular() const;

    /** Get the specular power lighting coefficient. */
    double getSpecularPower() const;

    /** Get the opacity coefficient. */
    double getOpacity() const;

    /** Get the ambient color. */
    //QMap<QString, QVariant> getAmbientColor() const;

    /** Get the ambient color. */
    //QMap<QString, QVariant> getDiffuseColor() const;

    /** Get the ambient color. */
    QColor getSpecularColor() const;

    /** Get the line width. */
    //double getLineWidth() const;

    /** Get the point size. */
    //double getPointSize() const;

// ####################   SETTERS   ###########################################

    /** Set the shading interpolation. */
    //void setInterpolation( ShadingInterpolation input );

    /** Get the color. */
    //void setColor( const QMap<double, QVariant> input );

    /** Set the ambient lighting coefficient. */
    void setAmbient( const double input );

    /** Set the diffuse lighting coefficient. */
    void setDiffuse( const double input );

    /** Set the specular lighting coefficient. */
    void setSpecular( const double input );

    /** Set the specular power lighting coefficient. */
    void setSpecularPower( const double input );

    /** Set the opacity coefficient. */
    void setOpacity( const double input );

    /** Set the ambient color. */
    //void setAmbientColor(const QMap<QString, QVariant> input );

    /** Set the diffuse color. */
    //void setDiffuseColor( const QMap<QString, QVariant> input );

    /** Set the specular color. */
    void setSpecularColor( const QColor input );

    /** Set the line width. */
    //void setLineWidth( const double input );

    /** Set the point size. */
    //void setPointSize( const double input );


protected:

    /// The data component associated.
    VtkMeshComponent * myComponent;

    /// The QMap table holding color
    //QMap<QString, QVariant> colorTable;

    /// The QMap table holding ambient color
    //QMap<QString, QVariant> ambientColorTable;

    /// The QMap table holding diffuse color
    //QMap<QString, QVariant> diffuseColorTable;

    /// The QMap table holding specular color
    //QColor specularColorTable;

};



#endif   // VTK_MANAGER_Component_PROPERTIES_H
