/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef VtkMeshComponentPopup_H
#define VtkMeshComponentPopup_H

#include <ComponentPopupMenu.h>
using namespace camitk;

class VtkMeshComponent;

/** The popup menu of the VTK data component.
  * 
  */
class VtkMeshComponentPopup : public ComponentPopupMenu  {

    Q_OBJECT

public:
    VtkMeshComponentPopup ( Component *, QWidget* );

public slots:

    /// Load a transformation file and apply it to the SC
    void loadTransformationFile();

    /// hide all point data
    void noPointData();

    /// show vtk point data
    void vtkPointData();

    /// show demo point data
    void demoPointData();

    /// load texture from file
    void loadTextureFromBMPFile( );

    /// Mesh registration
    void meshRegistration( );

    /** Load a transformation, then compute the displacement of each point with this transformation, then save it in a file.
     *  This Component is NOT transformed. */
    void getDisplacementFromTransformation();

    /// Export as MDL file
    void exportMDL();

    /// clean a poly data (remove redundant nodes)
    void cleanPolyData();

    /** */
    void processLibrary( QString libraryName );

private:

    VtkMeshComponent * myComponent;

};

#endif
