/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef STRUCTURALCOMPONENTDCPROPERTIES_H
#define STRUCTURALCOMPONENTDCPROPERTIES_H


#include <QObject>

class StructuralComponentDC;

/**
 *  The class StructuralComponentDCProperties defines an QObject that allows user interaction
 *  with properties of a structural component (in an automatically generated UI)
 *
 *  The default structural component properties are created thanks to Q_PROPERTY.
 *  The extra properties found in the PML document are also available thanks
 *  to the dynamic features of the Qt's Property System (see qt documentation).
 *
 * 

 */
class StructuralComponentDCProperties : public QObject  {
  Q_OBJECT

  /** the name property that will be managed in the property dialog */
  Q_PROPERTY( QString name READ getName WRITE setName )

public:

  /// Default construtor (give it he SCDC to edit)
  StructuralComponentDCProperties(StructuralComponentDC *);

  /// the destructor (oauh, really?!!)
  ~StructuralComponentDCProperties() {}

  /// change the currently managed SCDC and update the value of the properties
  void updateProperties(StructuralComponentDC*);

  /** Set and get method for all the properties */
    /// change the cell's name (if name is not an index)
  void setName( const QString );

  /// get the atom's index in a form the property editor understands
  QString getName() const;

  /** intercept signal for dynamic property changed. */
  virtual bool event(QEvent* e);

private:
  // the currently selected StructuralComponentDC
  StructuralComponentDC *myDC;

};

#endif

