/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file GridTopology.h
 * @brief Class for 3D grid mesh creation
 * @author Mathieu BAILET
 * @date July 5 2012
 */

#ifndef GRID_TOPOLOGY_HPP_
#define GRID_TOPOLOGY_HPP_

#include <Action.h>

using namespace camitk;

/**
 * @class GridTopology
 * @brief Create a 3D grid mesh.
 */
class GridTopology : public Action {

public:
  
    /// the constructor
    GridTopology(ActionExtension *);

    /// the destructor
    virtual ~GridTopology();
    
private:
  
    /// method called when the action is applied
    virtual ApplyStatus apply();

};

#endif // GRID_TOPOLOGY_HPP_