/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef ImageReconstructionAction_H
#define ImageReconstructionAction_H

// -- Core image component stuff
#include "ui_ImageReconstructionAction.h"

#include <Action.h>
#include <ImageComponent.h>
using namespace camitk;
  

// -- Core stuff classes
class InteractiveViewer;

  
//***************************************************************************

/**
 * The class ImageReconstructionAction interfaces the reconstruction
 * of 3D volumes from a set of images (ImageComponent), typically using the marching cubes algorithm.
 */
class ImageReconstructionAction : public Action {
  Q_OBJECT

public:
    /// the constructor
    ImageReconstructionAction(ActionExtension* extension);

    /// the destructor
    virtual ~ImageReconstructionAction();
    
    /// this method creates and returns the widget containing the user interface for the action
    virtual QWidget * getWidget();
    
    /// Initializes the dialog options
    void init();

    /** Return an isosurface reconstructed with the Marching Cubes algorithm, 
	 * from the original set of slices.
     *  @param isoValue  Grey levels corresponding to the isovalue the isosurface represents
     *  @param subsample If true, the image is subsampled by 1/2^3 to simplify the output object
     *  @param keepLargestConnectedComponent If true, keep only the largest component.
     */
    static vtkSmartPointer<vtkPointSet> getMarchingCubesReconstruction(
		ImageComponent * image,
		int isoValue, bool keepLargestConnectedComponent, 
		bool subsample, int subSampledDimX, int subSampledDimY, int subSampledDimZ);

public slots:
  /// method called when the action is applied (nothing to do here, everything will be done by the widget)
  virtual ApplyStatus apply() { return SUCCESS; };

private:   
    /// The initial images, used for the reconstruction.
    ImageComponent *myComponent;

    /// Do I keep the largest component ?
    bool keepLargestComponent;

    /// Subsample original image ?
    bool subSample;
    int subSampledImageXDim;
    int subSampledImageYDim;
    int subSampledImageZDim;
  
    /// Qt model designed by QtDesigner (with qt4, nor more inheritance from the ui)
    Ui::ui_ImageReconstructionAction ui;
    
public slots:
    void build3DModel();
    void keepComponentcheckBox_toggled(bool toggled);
    void subSamplecheckBox_toggled(bool toggled);
};

//**************************************************************************
#endif
