/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ShowConsoleAction.h"

#include <Application.h>
#include <MainWindow.h>

using namespace camitk;

// --------------- constructor -------------------
ShowConsoleAction::ShowConsoleAction(ActionExtension * extension) : Action(extension) {
    // Setting name, description and input component
    setName("Show Console");
    setEmbedded(false);
    setDescription("Show the redirection console window (view debugging information, cout, cerr,...)");
    setComponent("");
    setIcon(QPixmap(":/showConsole"));

    // Setting classification family and tags
    setFamily("Application");
    addTag("Console");
    addTag("Terminal");
}

// --------------- destructor -------------------
ShowConsoleAction::~ShowConsoleAction() {
    // do not delete the widget has it might have been used in the ActionViewer (i.e. the ownership might have been taken by the stacked widget)
}

// --------------- getWidget --------------
QWidget * ShowConsoleAction::getWidget() {
    return NULL;
}

// --------------- apply -------------------
Action::ApplyStatus ShowConsoleAction::apply() {
    Application::getMainWindow()->showConsole(true);
    return SUCCESS;
}
