# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Tab widgets for particular purposes.

Widget are named according to purpose, not presentation style.
The presentation style is implied and the style may vary across
GUI platforms. The broad intention of each is:

  * PreferencesTW - sections within a preferences dialog

  * ScopeTW - a scope bar for filtering content where each
    category of content has a custom planel

  * NavigationTW - resizable sections all shown on the one panel.
    Resizing can be provided by splitters or may be provided
    by collapsible sections ala Qt-Designer's widget box.

These classes are designed to be drop-in replacements for QTabWidget
and therefore need to support the following methods:

 * def addTab(self, widget, icon, label)
"""

from PyQt4 import QtGui
from PyQt4.QtCore import Qt


class QBzrPreferencesTabWidget(QtGui.QFrame):

    def __init__(self, *args):
        QtGui.QFrame.__init__(self, *args)
        self._ui = QtGui.QTabWidget()
        # TODO: set the style so text below the icon
        layout = QtGui.QVBoxLayout()
        layout.addWidget(self._ui)
        self.setLayout(layout)

    def addTab(self, widget, icon, label):
        if icon is None:
            self._ui.addTab(widget, label)
        else:
            self._ui.addTab(widget, icon, label)


class QBzrScopeTabWidget(QtGui.QFrame):

    def __init__(self, *args):
        QtGui.QFrame.__init__(self, *args)
        self._selector = QtGui.QTabBar()
        self._viewer = QtGui.StackedWidget()
        layout = QtGui.QVBoxLayout()
        layout.addWidget(self._selector)
        layout.addWidget(self._viewer)
        self.setLayout(layout)

    def addTab(self, widget, icon, label):
        self._selector.addTab(icon, label)
        self._viewer.addItem(widget)


class QBzrNavigationTabWidget(QtGui.QFrame):

    def __init__(self, *args):
        QtGui.QFrame.__init__(self, *args)
        splitter = QtGui.QSplitter() 
        splitter.setOrientation(Qt.Vertical)
        splitter.setChildrenCollapsible(True)
        self._container = splitter
        layout = QtGui.QVBoxLayout()
        layout.addWidget(splitter)
        self.setLayout(layout)

    def addTab(self, widget, icon, label):
        # note: icon is ignored in this presentation
        ui = QtGui.QGroupBox(label)
        layout = QtGui.QVBoxLayout()
        layout.addWidget(widget)
        ui.setLayout(layout)
        self._container.addWidget(ui)
