# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

class clueCondition(object):
    def __init__(self, and_cond, or_cond, simple_cond, not_cond, cond_field = None):
        self.and_cond = and_cond
        self.or_cond = or_cond
        self.simple_cond = simple_cond
        self.not_cond = not_cond
        self.cond_field = cond_field

    def __str__(self):
        if self.simple_cond:
            if self.not_cond:
                return "!clueCondition(field='%s', '%s')" % self.cond_field, self.simple_cond
            else:
                return "clueCondition(field='%s', '%s')" % self.cond_field, self.simple_cond
        if self.and_cond:
            return "clueCondition(%s)" % ' && '.join([str(cond) 
                                                     for cond in self.and_cond])
        if self.or_cond:
            return "clueCondition(%s)" % ' || '.join([str(cond) 
                                                     for cond in self.or_cond])
        return "clueCondition(?)"

class bugClue(object):
    def __init__(self, info, conditions):
        self.info = info
        self.conditions = conditions

    def __str__(self):
        return "bugClue: %s" % ', '.join([str(cond) for cond in self.conditions])
