import os
from singleton_store import Screen

def convert_file( filename):
  plugin = "PNG (Cairo)" # the name of the export plugin
  if App.load_CDML( filename):
    outname = os.path.splitext( filename)[0] + ".png"
    plugin = App.plugins[ plugin]
    exporter = plugin.exporter( App.paper)
    exporter.interactive = False
    exporter.on_begin()
    exporter.background_color = (0,0,0,0)
    exporter.write_to_file( outname)
    print filename, "=>", outname

for arg in Args:
  if os.path.isdir( arg):
    for f in os.listdir( arg):
      if f.endswith( ".svg"):
        convert_file( os.path.join( arg, f))
  elif os.path.isfile( arg):
    convert_file( arg)
  else:
    print "%s is neither a file nor a directory, skipping" % arg



