
import os
import oasa
import math
import oasa.oasa.periodic_table as PT
import marks


totalCharge = 0


def update_svgs_in_path( dir):
  """calls update_svg for an argument file,
  in case of directory for all .svg files in the directory"""

  made = 0
  ignored = 0

  if os.path.isfile( dir):
    # a filename was given
    update_svg( dir)

  elif os.path.isdir( dir):
    # a directory name was given
    for f in os.listdir( dir):
      if os.path.splitext( f)[1] == ".svg":
        i = update_svg( os.path.join( dir, f))

        # just count the processed / invalid files
        if i:
          made += 1
        else:
          ignored += 1

  print "resaved %d files, ignored %d" % (made, ignored)



def update_svg( f):
  """tries to open a file in BKchem, in case of success sets font size of
  all atoms to 12 and resaves the file."""

  print f, "...",

  # App.load_CDML returns true on successful load;
  # if replace argument is set to 1 the file is loaded to the same tab,
  # instead of opening a new one;
  # this prevents memory comsumption to raise to incredible values
  # when many files are processed
  if App.load_CDML( f, replace=1):
    print "OK"
    main_process()
    return 1
  else:
    print "ignoring"
    return 0



# z Bedova plug-inu

class formal_charge_mark( marks.referencing_text_mark):

  #meta__mark_positioning = 'righttop'
  refname = "formal_charge"
  meta__save_attrs = {"text":str,
                      "refname":str}

  



def log( a):
  print a



def main_process():

  # trochu zvetsime delku vazeb
  App.paper.select_all()
  App.paper.scale_selected( 1.3, 1.3, scale_font=0, fix_centers=True)

  basename = App.paper.get_base_name()

  for mol in App.paper.molecules:

    App.paper.fix_current_cropping_bbox()
    save( basename + "-0")

    ### najdi a oznac centralni a koncove atomy
    ## nejdriv hledam atomy s nejnizsi elektronegativitou

    central_atoms = []

    ## zaciname hackem, kterej osetruje nestandardni pripady
    if len( mol.vertices) == 3:
      symbols = [v.symbol for v in mol.vertices]
      symbols.sort()
      if symbols in [['Br','Br','O'],['Cl','Cl','O']]:
        central_atoms = [v for v in mol.vertices if v.symbol == 'O']
        log( "Tahle molekula je specialni, centralni atom je O")
    
    if not central_atoms:
      min_en = min( [v.electronegativity for v in mol.vertices if not v.symbol == "H"])    
      candidates = [v for v in mol.vertices if v.electronegativity == min_en]    
      if len( candidates) > 1:
        ## pak pripadne ty s nejvice vazbama
        log( "Podle elektronegativity je vic kandidatu na centralni atom " + str([v.symbol for v in candidates]))
        max_degree = max( [v.degree for v in candidates])
        candidates = [v for v in candidates if v.degree == max_degree]
      if len( candidates) > 1:
        log( "Podle elektronegativity i konectivity je vic kandidatu na centralni atom " + str([v.symbol for v in candidates]) + "- bacha na to.")

      central_atoms = candidates

    log( "centralni atom(y): "+str( [a.symbol for a in central_atoms]))
    
    [highlight( v) for v in central_atoms]
    save( basename + "-1")
    [unhighlight( v) for v in central_atoms]



    ### dopln elektronove pary na ne-centralni atomy

    electrons_to_put = sum( [PT.periodic_table[ v.symbol]['els'] for v in mol.vertices]) - 2*len( mol.edges) - sum( [v.charge for v in mol.vertices]) - totalCharge

    added_pairs = []
    for v in mol.vertices:
      if v not in central_atoms:
        to_have = min( [PT.periodic_table[ v.symbol]['els'], 4]) # kolik chce mit atom kolem sebe paru (4 kdyz to jde)
        ep_number = to_have - v.degree
        if electrons_to_put >= 2*ep_number:
          added_pairs.extend( put_electron_pairs_to_atom( v, ep_number))
          electrons_to_put -= 2*ep_number
        else:
          log( "sakra, tolik elektronu uz k disposici neni")

    [highlight( e) for e in added_pairs]
    save( basename + "-2")
    [unhighlight( e) for e in added_pairs]


    
    ### zbytek elektronu se da jako volne pary na central

    log( "na centralni atom(y) zbyva %d elektronu" % electrons_to_put) 
    assert( not electrons_to_put % 2)
    added_pairs = []
    for central in central_atoms:
      added_pairs.extend( put_electron_pairs_to_atom( central, int( electrons_to_put/2.0/len( central_atoms)), central=1))

    [highlight( e) for e in added_pairs]
    save( basename + "-3")
    [unhighlight( e) for e in added_pairs]



    ### spocitej formalni naboje

    added_marks = []
    for v in mol.vertices:
      v.formal_charge = int( PT.periodic_table[ v.symbol][ 'els'] - (sum( [b.order for b in v.neighbor_edges]) +2*len( v.get_marks_by_type( "electronpair")) +v.multiplicity-1))
      added_marks.append( v.set_mark( formal_charge_mark))

    [highlight( e) for e in added_marks]
    save( basename + "-4")
    [unhighlight( e) for e in added_marks]




def put_electron_pairs_to_atom( v, number, central=0):

  ret = []

  if (central == 1):
      angle = 45
  else:
      angle = 90


  for i in range( number):
    ret.append( v.set_mark( "electronpair", angle_resolution=angle))
  return ret



def save( filename):
  [o.redraw() for o in App.paper.stack]
  App.paper.set_paper_properties( crop_svg=1, crop_margin=10)
  App.save_CDML(name=filename+".svg")
  App.plugin_export( "PNG (Cairo)", filename=filename+".png", interactive=False)




def highlight( what):
  what.line_color = "#ff0000"
  what.redraw()


def unhighlight( what):
  what.line_color = "#000000"
  what.redraw()










# this starts the script base on the command line arguments given

if Args:
  filename = Args[0]
  totalCharge = int(Args[1])
  log( "Soubor: " + filename)
  log( "Celkovy naboj: " + `totalCharge`)
  update_svgs_in_path( filename)
else:
  print """You must supply a path as first argument to the batch script
  and total charge as a second argument"""

