<?xml version="1.0"?>
<api version="1.0">
	<namespace name="Bkl">
		<function name="audio_field_get_string" symbol="bkl_audio_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklAudioField"/>
			</parameters>
		</function>
		<function name="broken_field_get_string" symbol="bkl_broken_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklBrokenField"/>
			</parameters>
		</function>
		<function name="db_add_item" symbol="bkl_db_add_item">
			<return-type type="gboolean"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="key" type="char*"/>
				<parameter name="item" type="BklItem*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_get" symbol="bkl_db_get">
			<return-type type="KozoDB*"/>
			<parameters>
				<parameter name="db_name" type="char*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_get_for_name" symbol="bkl_db_get_for_name">
			<return-type type="KozoDB*"/>
			<parameters>
				<parameter name="filename" type="char*"/>
				<parameter name="db_name" type="char*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_get_for_path" symbol="bkl_db_get_for_path">
			<return-type type="KozoDB*"/>
			<parameters>
				<parameter name="path" type="char*"/>
				<parameter name="db_name" type="char*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_get_item" symbol="bkl_db_get_item">
			<return-type type="BklItem*"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="key" type="char*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_get_items" symbol="bkl_db_get_items">
			<return-type type="GPtrArray*"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="include_broken" type="gboolean"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_remove" symbol="bkl_db_remove">
			<return-type type="gboolean"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="key" type="char*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="db_replace_item" symbol="bkl_db_replace_item">
			<return-type type="gboolean"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="key" type="char*"/>
				<parameter name="item" type="BklItem*"/>
				<parameter name="error" type="GError**"/>
			</parameters>
		</function>
		<function name="entry_get_field" symbol="bkl_entry_get_field">
			<return-type type="KozoField*"/>
			<parameters>
				<parameter name="entry" type="KozoEntry*"/>
				<parameter name="type" type="BklFieldType"/>
			</parameters>
		</function>
		<function name="extended_field_get_string" symbol="bkl_extended_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklExtendedField"/>
			</parameters>
		</function>
		<function name="file_field_get_string" symbol="bkl_file_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklFileField"/>
			</parameters>
		</function>
		<function name="image_field_get_string" symbol="bkl_image_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklImageField"/>
			</parameters>
		</function>
		<function name="init" symbol="bkl_init">
			<return-type type="void"/>
		</function>
		<function name="playlist_field_get_string" symbol="bkl_playlist_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklPlaylistField"/>
			</parameters>
		</function>
		<function name="shutdown" symbol="bkl_shutdown">
			<return-type type="void"/>
		</function>
		<function name="video_field_get_string" symbol="bkl_video_field_get_string">
			<return-type type="char*"/>
			<parameters>
				<parameter name="f" type="KozoField*"/>
				<parameter name="field" type="BklVideoField"/>
			</parameters>
		</function>
		<struct name="BklDBSource">
			<field name="db_uri" type="char*"/>
			<field name="name" type="char*"/>
		</struct>
		<enum name="BklAudioField">
			<member name="BKL_AUDIO_FIELD_TITLE" value="0"/>
			<member name="BKL_AUDIO_FIELD_ALBUM" value="1"/>
			<member name="BKL_AUDIO_FIELD_ARTISTS" value="2"/>
			<member name="BKL_AUDIO_FIELD_PERFORMERS" value="3"/>
			<member name="BKL_AUDIO_FIELD_CONDUCTOR" value="4"/>
			<member name="BKL_AUDIO_FIELD_COMPOSER" value="5"/>
			<member name="BKL_AUDIO_FIELD_GENRE" value="6"/>
			<member name="BKL_AUDIO_FIELD_COMMENT" value="7"/>
			<member name="BKL_AUDIO_FIELD_COPYRIGHT" value="8"/>
			<member name="BKL_AUDIO_FIELD_LICENSE" value="9"/>
			<member name="BKL_AUDIO_FIELD_ORGANISATION" value="10"/>
			<member name="BKL_AUDIO_FIELD_ISRC" value="11"/>
			<member name="BKL_AUDIO_FIELD_CONTACT" value="12"/>
			<member name="BKL_AUDIO_FIELD_YEAR" value="13"/>
			<member name="BKL_AUDIO_FIELD_TRACK" value="14"/>
			<member name="BKL_AUDIO_FIELD_MAXTRACKS" value="15"/>
			<member name="BKL_AUDIO_FIELD_DISC" value="16"/>
			<member name="BKL_AUDIO_FIELD_MAXDISCS" value="17"/>
			<member name="BKL_AUDIO_FIELD_DURATION" value="18"/>
		</enum>
		<enum name="BklBrokenField">
			<member name="BKL_BROKEN_FIELD_REASON" value="0"/>
		</enum>
		<enum name="BklExtendedField">
			<member name="BKL_EXTENDED_FIELD_THUMBNAIL" value="0"/>
			<member name="BKL_EXTENDED_FIELD_LAST_USED" value="1"/>
			<member name="BKL_EXTENDED_FIELD_USE_COUNT" value="2"/>
			<member name="BKL_EXTENDED_FIELD_RATING" value="3"/>
			<member name="BKL_EXTENDED_FIELD_PINNED" value="4"/>
			<member name="BKL_EXTENDED_FIELD_DATE_INDEXED" value="5"/>
			<member name="BKL_EXTENDED_FIELD_TAGS" value="6"/>
		</enum>
		<enum name="BklFieldType">
			<member name="BKL_FIELD_TYPE" value="0"/>
			<member name="BKL_FIELD_FILE" value="1"/>
			<member name="BKL_FIELD_AUDIO" value="2"/>
			<member name="BKL_FIELD_IMAGE" value="3"/>
			<member name="BKL_FIELD_VIDEO" value="4"/>
			<member name="BKL_FIELD_BROKEN" value="5"/>
			<member name="BKL_FIELD_PLAYLIST" value="6"/>
			<member name="BKL_FIELD_EXTENDED" value="7"/>
		</enum>
		<enum name="BklFileField">
			<member name="BKL_FILE_FIELD_URI" value="0"/>
			<member name="BKL_FILE_FIELD_MIMETYPE" value="1"/>
			<member name="BKL_FILE_FIELD_SIZE" value="2"/>
			<member name="BKL_FILE_FIELD_MODIFICATION_TIME" value="3"/>
		</enum>
		<enum name="BklImageField">
			<member name="BKL_IMAGE_FIELD_TITLE" value="0"/>
			<member name="BKL_IMAGE_FIELD_MAKE" value="1"/>
			<member name="BKL_IMAGE_FIELD_MODEL" value="2"/>
			<member name="BKL_IMAGE_FIELD_DATE" value="3"/>
			<member name="BKL_IMAGE_FIELD_DATE_ORIGINAL" value="4"/>
			<member name="BKL_IMAGE_FIELD_DATE_DIGITIZED" value="5"/>
			<member name="BKL_IMAGE_FIELD_ORIENTATION" value="6"/>
			<member name="BKL_IMAGE_FIELD_EXPOSURE" value="7"/>
			<member name="BKL_IMAGE_FIELD_APERTURE" value="8"/>
			<member name="BKL_IMAGE_FIELD_METERING_MODE" value="9"/>
			<member name="BKL_IMAGE_FIELD_FLASH" value="10"/>
			<member name="BKL_IMAGE_FIELD_ISO" value="11"/>
			<member name="BKL_IMAGE_FIELD_SOFTWARE" value="12"/>
			<member name="BKL_IMAGE_FIELD_AUTHOR" value="13"/>
			<member name="BKL_IMAGE_FIELD_COPYRIGHT" value="14"/>
			<member name="BKL_IMAGE_FIELD_COMMENT" value="15"/>
			<member name="BKL_IMAGE_FIELD_USER_COMMENT" value="16"/>
			<member name="BKL_IMAGE_FIELD_KEYWORDS" value="17"/>
			<member name="BKL_IMAGE_FIELD_SUBJECT" value="18"/>
			<member name="BKL_IMAGE_FIELD_FOCAL_LENGTH" value="19"/>
			<member name="BKL_IMAGE_FIELD_SHUTTER_SPEED" value="20"/>
			<member name="BKL_IMAGE_FIELD_WIDTH" value="21"/>
			<member name="BKL_IMAGE_FIELD_HEIGHT" value="22"/>
		</enum>
		<enum name="BklItemType">
			<member name="BKL_ITEM_TYPE_NONE" value="0"/>
			<member name="BKL_ITEM_TYPE_IMAGE" value="1"/>
			<member name="BKL_ITEM_TYPE_AUDIO" value="2"/>
			<member name="BKL_ITEM_TYPE_VIDEO" value="4"/>
			<member name="BKL_ITEM_TYPE_BROKEN" value="8"/>
			<member name="BKL_ITEM_TYPE_PLAYLIST" value="16"/>
		</enum>
		<enum name="BklPlaylistField">
			<member name="BKL_PLAYLIST_FIELD_NAME" value="0"/>
			<member name="BKL_PLAYLIST_FIELD_URIS" value="1"/>
		</enum>
		<enum name="BklVideoField">
			<member name="BKL_VIDEO_FIELD_TITLE" value="0"/>
			<member name="BKL_VIDEO_FIELD_DIRECTOR" value="1"/>
			<member name="BKL_VIDEO_FIELD_SERIES_NAME" value="2"/>
			<member name="BKL_VIDEO_FIELD_SEASON" value="3"/>
			<member name="BKL_VIDEO_FIELD_EPISODE" value="4"/>
			<member name="BKL_VIDEO_FIELD_YEAR" value="5"/>
			<member name="BKL_VIDEO_FIELD_DURATION" value="6"/>
			<member name="BKL_VIDEO_FIELD_WIDTH" value="7"/>
			<member name="BKL_VIDEO_FIELD_HEIGHT" value="8"/>
		</enum>
		<object name="BklDBus" parent="GObject" type-name="BklDBus" get-type="bkl_dbus_get_type">
			<constructor name="new" symbol="bkl_dbus_new">
				<return-type type="BklDBus*"/>
			</constructor>
			<method name="notify_uri_added" symbol="bkl_dbus_notify_uri_added">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="BklDBus*"/>
					<parameter name="source" type="char*"/>
					<parameter name="uri" type="char*"/>
				</parameters>
			</method>
			<method name="notify_uri_changed" symbol="bkl_dbus_notify_uri_changed">
				<return-type type="void"/>
				<parameters>
					<parameter name="dbus" type="BklDBus*"/>
					<parameter name="source" type="char*"/>
					<parameter name="uri" type="char*"/>
				</parameters>
			</method>
			<method name="notify_uri_deleted" symbol="bkl_dbus_notify_uri_deleted">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="BklDBus*"/>
					<parameter name="source" type="char*"/>
					<parameter name="uri" type="char*"/>
				</parameters>
			</method>
			<signal name="uri-added" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklDBus*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="uri-changed" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklDBus*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="uri-deleted" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklDBus*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
		</object>
		<object name="BklItem" parent="GObject" type-name="BklItem" get-type="bkl_item_get_type">
			<method name="get_fields" symbol="bkl_item_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="get_item_type" symbol="bkl_item_get_item_type">
				<return-type type="BklItemType"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="get_mimetype" symbol="bkl_item_get_mimetype">
				<return-type type="char*"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="get_modification_time" symbol="bkl_item_get_modification_time">
				<return-type type="glong"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="get_size" symbol="bkl_item_get_size">
				<return-type type="goffset"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="get_uri" symbol="bkl_item_get_uri">
				<return-type type="char*"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
				</parameters>
			</method>
			<method name="set_from_field" symbol="bkl_item_set_from_field">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</method>
			<method name="set_item_type" symbol="bkl_item_set_item_type">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="type" type="BklItemType"/>
				</parameters>
			</method>
			<method name="set_mimetype" symbol="bkl_item_set_mimetype">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="mimetype" type="char*"/>
				</parameters>
			</method>
			<method name="set_modification_time" symbol="bkl_item_set_modification_time">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="mtime" type="glong"/>
				</parameters>
			</method>
			<method name="set_size" symbol="bkl_item_set_size">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="size" type="goffset"/>
				</parameters>
			</method>
			<method name="set_uri" symbol="bkl_item_set_uri">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItem*"/>
					<parameter name="uri" type="char*"/>
				</parameters>
			</method>
			<property name="mimetype" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="modification-time" type="glong" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="size" type="guint64" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="uri" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklItemAudio" parent="BklItemExtended" type-name="BklItemAudio" get-type="bkl_item_audio_get_type">
			<method name="get_album" symbol="bkl_item_audio_get_album">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_artists" symbol="bkl_item_audio_get_artists">
				<return-type type="GPtrArray*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_comment" symbol="bkl_item_audio_get_comment">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_composer" symbol="bkl_item_audio_get_composer">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_conductor" symbol="bkl_item_audio_get_conductor">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_contact" symbol="bkl_item_audio_get_contact">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_copyright" symbol="bkl_item_audio_get_copyright">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_disc" symbol="bkl_item_audio_get_disc">
				<return-type type="guint"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_duration" symbol="bkl_item_audio_get_duration">
				<return-type type="guint"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_fields" symbol="bkl_item_audio_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_genre" symbol="bkl_item_audio_get_genre">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_isrc" symbol="bkl_item_audio_get_isrc">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_license" symbol="bkl_item_audio_get_license">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_max_tracks" symbol="bkl_item_audio_get_max_tracks">
				<return-type type="guint"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_maxdiscs" symbol="bkl_item_audio_get_maxdiscs">
				<return-type type="guint"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_organisation" symbol="bkl_item_audio_get_organisation">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_performers" symbol="bkl_item_audio_get_performers">
				<return-type type="GPtrArray*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_title" symbol="bkl_item_audio_get_title">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_track" symbol="bkl_item_audio_get_track">
				<return-type type="guint"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<method name="get_year" symbol="bkl_item_audio_get_year">
				<return-type type="char*"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="bkl_item_audio_new">
				<return-type type="BklItemAudio*"/>
			</constructor>
			<constructor name="new_from_field" symbol="bkl_item_audio_new_from_field">
				<return-type type="BklItemAudio*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</constructor>
			<method name="set_album" symbol="bkl_item_audio_set_album">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="album" type="char*"/>
				</parameters>
			</method>
			<method name="set_artists" symbol="bkl_item_audio_set_artists">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="artists" type="GPtrArray*"/>
				</parameters>
			</method>
			<method name="set_comment" symbol="bkl_item_audio_set_comment">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="comment" type="char*"/>
				</parameters>
			</method>
			<method name="set_composer" symbol="bkl_item_audio_set_composer">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="composer" type="char*"/>
				</parameters>
			</method>
			<method name="set_conductor" symbol="bkl_item_audio_set_conductor">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="conductor" type="char*"/>
				</parameters>
			</method>
			<method name="set_contact" symbol="bkl_item_audio_set_contact">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="contact" type="char*"/>
				</parameters>
			</method>
			<method name="set_copyright" symbol="bkl_item_audio_set_copyright">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="copyright" type="char*"/>
				</parameters>
			</method>
			<method name="set_disc" symbol="bkl_item_audio_set_disc">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="disc" type="guint"/>
				</parameters>
			</method>
			<method name="set_duration" symbol="bkl_item_audio_set_duration">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="duration" type="guint"/>
				</parameters>
			</method>
			<method name="set_genre" symbol="bkl_item_audio_set_genre">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="genre" type="char*"/>
				</parameters>
			</method>
			<method name="set_isrc" symbol="bkl_item_audio_set_isrc">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="isrc" type="char*"/>
				</parameters>
			</method>
			<method name="set_license" symbol="bkl_item_audio_set_license">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="license" type="char*"/>
				</parameters>
			</method>
			<method name="set_maxdiscs" symbol="bkl_item_audio_set_maxdiscs">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="maxdiscs" type="guint"/>
				</parameters>
			</method>
			<method name="set_maxtracks" symbol="bkl_item_audio_set_maxtracks">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="maxtracks" type="guint"/>
				</parameters>
			</method>
			<method name="set_organisation" symbol="bkl_item_audio_set_organisation">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="organisation" type="char*"/>
				</parameters>
			</method>
			<method name="set_performers" symbol="bkl_item_audio_set_performers">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="performers" type="GPtrArray*"/>
				</parameters>
			</method>
			<method name="set_title" symbol="bkl_item_audio_set_title">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="title" type="char*"/>
				</parameters>
			</method>
			<method name="set_track" symbol="bkl_item_audio_set_track">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="track" type="guint"/>
				</parameters>
			</method>
			<method name="set_year" symbol="bkl_item_audio_set_year">
				<return-type type="void"/>
				<parameters>
					<parameter name="audio" type="BklItemAudio*"/>
					<parameter name="year" type="char*"/>
				</parameters>
			</method>
			<property name="album" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="artists" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="comment" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="composer" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="conductor" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="contact" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="copyright" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="disc" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="duration" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="genre" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="isrc" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="license" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="maxdiscs" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="maxtracks" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="organisation" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="performers" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="title" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="track" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="year" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklItemBroken" parent="BklItemExtended" type-name="BklItemBroken" get-type="bkl_item_broken_get_type">
			<method name="get_fields" symbol="bkl_item_broken_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItemBroken*"/>
				</parameters>
			</method>
			<method name="get_reason" symbol="bkl_item_broken_get_reason">
				<return-type type="char*"/>
				<parameters>
					<parameter name="broken" type="BklItemBroken*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="bkl_item_broken_new">
				<return-type type="BklItemBroken*"/>
			</constructor>
			<constructor name="new_from_field" symbol="bkl_item_broken_new_from_field">
				<return-type type="BklItemBroken*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</constructor>
			<method name="set_reason" symbol="bkl_item_broken_set_reason">
				<return-type type="void"/>
				<parameters>
					<parameter name="broken" type="BklItemBroken*"/>
					<parameter name="reason" type="char*"/>
				</parameters>
			</method>
			<property name="reason" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklItemExtended" parent="BklItem" type-name="BklItemExtended" get-type="bkl_item_extended_get_type">
			<method name="get_date_indexed" symbol="bkl_item_extended_get_date_indexed">
				<return-type type="glong"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_fields" symbol="bkl_item_extended_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_last_used" symbol="bkl_item_extended_get_last_used">
				<return-type type="glong"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_pinned" symbol="bkl_item_extended_get_pinned">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_rating" symbol="bkl_item_extended_get_rating">
				<return-type type="int"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_tags" symbol="bkl_item_extended_get_tags">
				<return-type type="GPtrArray*"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_thumbnail" symbol="bkl_item_extended_get_thumbnail">
				<return-type type="char*"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="get_use_count" symbol="bkl_item_extended_get_use_count">
				<return-type type="glong"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
				</parameters>
			</method>
			<method name="set_date_indexed" symbol="bkl_item_extended_set_date_indexed">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="date_indexed" type="glong"/>
				</parameters>
			</method>
			<method name="set_from_field" symbol="bkl_item_extended_set_from_field">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</method>
			<method name="set_last_used" symbol="bkl_item_extended_set_last_used">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="last_used" type="glong"/>
				</parameters>
			</method>
			<method name="set_pinned" symbol="bkl_item_extended_set_pinned">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="pinned" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_rating" symbol="bkl_item_extended_set_rating">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="rating" type="int"/>
				</parameters>
			</method>
			<method name="set_tags" symbol="bkl_item_extended_set_tags">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="tags" type="GPtrArray*"/>
				</parameters>
			</method>
			<method name="set_thumbnail" symbol="bkl_item_extended_set_thumbnail">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="thumbnail" type="char*"/>
				</parameters>
			</method>
			<method name="set_use_count" symbol="bkl_item_extended_set_use_count">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="BklItemExtended*"/>
					<parameter name="use_count" type="glong"/>
				</parameters>
			</method>
			<property name="date-indexed" type="glong" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="last-used" type="glong" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="pinned" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="rating" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="tags" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="thumbnail" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="use-count" type="glong" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklItemImage" parent="BklItemExtended" type-name="BklItemImage" get-type="bkl_item_image_get_type">
			<method name="get_aperture" symbol="bkl_item_image_get_aperture">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_author" symbol="bkl_item_image_get_author">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_camera_make" symbol="bkl_item_image_get_camera_make">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_camera_model" symbol="bkl_item_image_get_camera_model">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_comment" symbol="bkl_item_image_get_comment">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_copyright" symbol="bkl_item_image_get_copyright">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_exposure" symbol="bkl_item_image_get_exposure">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_fields" symbol="bkl_item_image_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_flash" symbol="bkl_item_image_get_flash">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_focal_length" symbol="bkl_item_image_get_focal_length">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_height" symbol="bkl_item_image_get_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_iso" symbol="bkl_item_image_get_iso">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_keywords" symbol="bkl_item_image_get_keywords">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_metering_mode" symbol="bkl_item_image_get_metering_mode">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_orientation" symbol="bkl_item_image_get_orientation">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_shutter_speed" symbol="bkl_item_image_get_shutter_speed">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_software" symbol="bkl_item_image_get_software">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_subject" symbol="bkl_item_image_get_subject">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_time" symbol="bkl_item_image_get_time">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_time_digitized" symbol="bkl_item_image_get_time_digitized">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_time_original" symbol="bkl_item_image_get_time_original">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_title" symbol="bkl_item_image_get_title">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_user_comment" symbol="bkl_item_image_get_user_comment">
				<return-type type="char*"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<method name="get_width" symbol="bkl_item_image_get_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="bkl_item_image_new">
				<return-type type="BklItemImage*"/>
			</constructor>
			<constructor name="new_from_field" symbol="bkl_item_image_new_from_field">
				<return-type type="BklItemImage*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</constructor>
			<method name="set_aperture" symbol="bkl_item_image_set_aperture">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="aperture" type="char*"/>
				</parameters>
			</method>
			<method name="set_author" symbol="bkl_item_image_set_author">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="author" type="char*"/>
				</parameters>
			</method>
			<method name="set_camera_make" symbol="bkl_item_image_set_camera_make">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="make" type="char*"/>
				</parameters>
			</method>
			<method name="set_camera_model" symbol="bkl_item_image_set_camera_model">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="model" type="char*"/>
				</parameters>
			</method>
			<method name="set_comment" symbol="bkl_item_image_set_comment">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="comment" type="char*"/>
				</parameters>
			</method>
			<method name="set_copyright" symbol="bkl_item_image_set_copyright">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="copyright" type="char*"/>
				</parameters>
			</method>
			<method name="set_exposure" symbol="bkl_item_image_set_exposure">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="exposure" type="char*"/>
				</parameters>
			</method>
			<method name="set_flash" symbol="bkl_item_image_set_flash">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="flash" type="char*"/>
				</parameters>
			</method>
			<method name="set_focal_length" symbol="bkl_item_image_set_focal_length">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="focal_length" type="char*"/>
				</parameters>
			</method>
			<method name="set_height" symbol="bkl_item_image_set_height">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_iso" symbol="bkl_item_image_set_iso">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="iso" type="char*"/>
				</parameters>
			</method>
			<method name="set_keywords" symbol="bkl_item_image_set_keywords">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="keywords" type="char*"/>
				</parameters>
			</method>
			<method name="set_metering_mode" symbol="bkl_item_image_set_metering_mode">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="metering_mode" type="char*"/>
				</parameters>
			</method>
			<method name="set_orientation" symbol="bkl_item_image_set_orientation">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="orientation" type="char*"/>
				</parameters>
			</method>
			<method name="set_shutter_speed" symbol="bkl_item_image_set_shutter_speed">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="shutter_speed" type="char*"/>
				</parameters>
			</method>
			<method name="set_software" symbol="bkl_item_image_set_software">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="software" type="char*"/>
				</parameters>
			</method>
			<method name="set_subject" symbol="bkl_item_image_set_subject">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="subject" type="char*"/>
				</parameters>
			</method>
			<method name="set_time" symbol="bkl_item_image_set_time">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="date" type="char*"/>
				</parameters>
			</method>
			<method name="set_time_digitized" symbol="bkl_item_image_set_time_digitized">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="time_digitized" type="char*"/>
				</parameters>
			</method>
			<method name="set_time_original" symbol="bkl_item_image_set_time_original">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="time_original" type="char*"/>
				</parameters>
			</method>
			<method name="set_title" symbol="bkl_item_image_set_title">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="title" type="char*"/>
				</parameters>
			</method>
			<method name="set_user_comment" symbol="bkl_item_image_set_user_comment">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="user_comment" type="char*"/>
				</parameters>
			</method>
			<method name="set_width" symbol="bkl_item_image_set_width">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="BklItemImage*"/>
					<parameter name="width" type="guint"/>
				</parameters>
			</method>
			<property name="aperture" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="author" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="camera-make" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="camera-model" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="comment" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="copyright" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="exposure" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="flash" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="focal-length" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="height" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="iso" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="keywords" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="location" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="metering-mode" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="orientation" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="shutter-speed" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="software" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="subject" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="time" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="time-digitized" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="time-original" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="title" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="user-comment" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="width" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklItemVideo" parent="BklItemExtended" type-name="BklItemVideo" get-type="bkl_item_video_get_type">
			<method name="get_director" symbol="bkl_item_video_get_director">
				<return-type type="char*"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_duration" symbol="bkl_item_video_get_duration">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_episode" symbol="bkl_item_video_get_episode">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_fields" symbol="bkl_item_video_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="item" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_height" symbol="bkl_item_video_get_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_season" symbol="bkl_item_video_get_season">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_series_name" symbol="bkl_item_video_get_series_name">
				<return-type type="char*"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_title" symbol="bkl_item_video_get_title">
				<return-type type="char*"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_width" symbol="bkl_item_video_get_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<method name="get_year" symbol="bkl_item_video_get_year">
				<return-type type="guint"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="bkl_item_video_new">
				<return-type type="BklItemVideo*"/>
			</constructor>
			<constructor name="new_from_field" symbol="bkl_item_video_new_from_field">
				<return-type type="BklItemVideo*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</constructor>
			<method name="set_director" symbol="bkl_item_video_set_director">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="director" type="char*"/>
				</parameters>
			</method>
			<method name="set_duration" symbol="bkl_item_video_set_duration">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="duration" type="guint"/>
				</parameters>
			</method>
			<method name="set_episode" symbol="bkl_item_video_set_episode">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="episode" type="guint"/>
				</parameters>
			</method>
			<method name="set_height" symbol="bkl_item_video_set_height">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_season" symbol="bkl_item_video_set_season">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="season" type="guint"/>
				</parameters>
			</method>
			<method name="set_series_name" symbol="bkl_item_video_set_series_name">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="series_name" type="char*"/>
				</parameters>
			</method>
			<method name="set_title" symbol="bkl_item_video_set_title">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="title" type="char*"/>
				</parameters>
			</method>
			<method name="set_width" symbol="bkl_item_video_set_width">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="width" type="guint"/>
				</parameters>
			</method>
			<method name="set_year" symbol="bkl_item_video_set_year">
				<return-type type="void"/>
				<parameters>
					<parameter name="video" type="BklItemVideo*"/>
					<parameter name="year" type="guint"/>
				</parameters>
			</method>
			<property name="director" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="duration" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="episode" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="height" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="name" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="season" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="title" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="width" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="year" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="BklWatcher" parent="GObject" type-name="BklWatcher" get-type="bkl_watcher_get_type">
			<method name="get_sources" symbol="bkl_watcher_get_sources">
				<return-type type="GList*"/>
				<parameters>
					<parameter name="watcher" type="BklWatcher*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<signal name="source-added" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklWatcher*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="source-removed" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklWatcher*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="uri-added" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklWatcher*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="uri-changed" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklWatcher*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="uri-deleted" when="FIRST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="BklWatcher*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
		</object>
		<constant name="BICKLEY_DB_VERSION" type="int" value="3"/>
	</namespace>
</api>
