/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "bkl-marshal.h"
#include "bkl-orbiter.h"
#include "bkl-orbiter-dbus.h"

G_DEFINE_TYPE (BklOrbiterDBus, bkl_orbiter_dbus, G_TYPE_OBJECT);

static gboolean bkl_orbiter_index_uri (BklOrbiterDBus *dbus,
                                       const char     *IN_uri,
                                       GError        **error);
static gboolean bkl_orbiter_remove_uri (BklOrbiterDBus *dbus,
                                        const char     *IN_uri,
                                        GError        **error);
static gboolean bkl_orbiter_replace (BklOrbiterDBus *dbus,
                                     GError        **error);

#include "bkl-orbiter-glue.h"

static gboolean
bkl_orbiter_index_uri (BklOrbiterDBus *dbus,
                       const char     *IN_uri,
                       GError        **error)
{
    return TRUE;
}

static gboolean
bkl_orbiter_remove_uri (BklOrbiterDBus *dbus,
                        const char     *IN_uri,
                        GError        **error)
{
    return TRUE;
}

static gboolean
bkl_orbiter_replace (BklOrbiterDBus *dbus,
                     GError        **error)
{
    bkl_orbiter_shutdown ();
    return TRUE;
}

static void
bkl_orbiter_dbus_class_init (BklOrbiterDBusClass *klass)
{
    dbus_g_object_type_install_info (G_TYPE_FROM_CLASS (klass),
                                     &dbus_glib_bkl_orbiter_object_info);
}

static void
bkl_orbiter_dbus_init (BklOrbiterDBus *self)
{
}

BklOrbiterDBus *
bkl_orbiter_dbus_new (void)
{
    BklOrbiterDBus *dbus;

    dbus = g_object_new (BKL_TYPE_ORBITER_DBUS, NULL);

    return dbus;
}
