<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    wap-about.php                                           */
/* Author:      Paul Waite                                              */
/* Date:        March 2004                                              */
/* Description: This page has info on WAP and has a link                */
/*              for people who want to login manually.                  */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// ABOUT CARD
$RESPONSE->card("About " . APP_NAME, "index");
include_once("site-wappage.php");

$CARD->insert_para(
  "You have arrived at the " . APP_NAME . " web-site for WAP-enabled " .
  "mobile phones."
  );

if ($RESPONSE->ismemberof_group("Guest")) {
  $msg = "If you have a login account for " . APP_NAME . ", then you can "
  . "login by following the link at the bottom of this screen.";
  if ($WEBMASTER_EMAIL != "") {
    $msg .= "If not then please send an e-mail to: $WEBMASTER_EMAIL "
          . "for further details.";
  }
  $CARD->insert_para($msg);
  $loginlink = new Link("/wap-login.php", "Login..");
  $CARD->insert_para($loginlink->render());
}
else {
  $CARD->insert_para(
    "You are currently logged in as '$RESPONSE->name'. We hope that you are " .
    "finding the access on your mobile phone useful."
    );
  $CARD->insert_para($HOMELINK);
  $CARD->insert_go("home", "Home", "/wap-index.php");
}

//-----------------------------------------------------------------------
// Plug it in
$RESPONSE->plugin("MAIN_CONTENT", $CARD->render());

//-----------------------------------------------------------------------
// Deliver it..
$RESPONSE->send();
?>