<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-queries.php                                       */
/* Author:      Paul Waite                                              */
/* Description: Built-in query facility maintenance page.               */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// ALLOWED TABLES TO QUERY
// In general you will want to restrict the tables which can be used to
// make queries. Define the list of these here including or excluding
// Axyl tables as you see fit. For all tables, leave the variable
// either undefined, or set to a null array.
$ALLOWED_TABLES = array(
    "ax_user",
    "ax_organisation",
    "ax_contactinfo",
    "ax_catalog",
    "ax_story"
    );

// -----------------------------------------------------------------------
$HEADING = "Query Resources";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take
$recvalid = false;

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// #######################################################################
// POST PROCESSING

// SAVE SETUP
if (isset($save_x)) {
  if (isset($quid)) {
    // QUERY DETAILS
    if ($mode == "add") {
      $query = new dbinsert("ax_query_resource");
      $query->set("quid", $quid);
    }
    else {
      $query = new dbupdate("ax_query_resource");
      $query->where("quid='$quid'");
    }
    // Determine tables..
    $q_tables = array();
    $table = "";
    foreach ($q_fields as $field) {
      $fbits = explode(".", $field);
      if ($fbits[0] != "" && $fbits[0] != $table) {
        $table = $fbits[0];
        $q_tables[] = $table;
      }
    }
    // Build the SQL query object..
    $QUERY = new dbselect();

    // Tables
    $QUERY->from($q_tables);

    // Manual From clause
    $QUERY->from($q_from);

    // Fields
    $QUERY->fieldlist($q_fields);

    // Where
    $QUERY->where($q_where);

    // Orderby
    $QUERY->orderby($q_orderby);

    // Limit
    $QUERY->limit($q_limit);

    $query->set("q_desc",    $q_desc);
    $query->set("q_query",   serialize($QUERY));
    $query->set("q_script",  $q_script);
    $query->set("enabled",   isset($q_enabled));
    $query->execute();
    $mode = "edit";
  } // isset org_id
}
// DELETE QUERY
elseif ($mode == "remove") {
  if (isset($quid)) {
    dbcommand("DELETE FROM ax_query_resource WHERE quid=$quid");
  }
  $quid = 0;
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW QUERY
elseif (isset($add_x)) {
  $quid = get_next_sequencevalue("seq_query_resource_id", "ax_query_resource", "quid");
  $q_desc = "";
  $q_tables = array();
  $q_fields = array();
  $q_where = "";
  $q_from = "";
  $q_orderby = array();
  $q_limit = "";
  $q_script = "";
  $q_enabled = true;
  $HEADING .= " - New";
  $recvalid = true;
  $mode = "add";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------
// Get current query, if any..
if ($mode != "add" && isset($quid) && $quid != 0) {
  $QUERY = new dbselect();
  $Q = dbrecordset("SELECT * FROM ax_query_resource WHERE quid=$quid");
  if ($Q->hasdata) {
    $q_desc = $Q->field("q_desc");
    if ($Q->field("q_query") != "") {
      $QUERY = unserialize($Q->field("q_query"));
    }
    $q_script  = $Q->field("q_script");
    $q_enabled   = ($Q->field("enabled") == "t");
    $HEADING .= " - $q_desc";
    $recvalid = true;
  }
  // Unpack SQL query object..
  $q_tables  = explode(",", $QUERY->tables->listed());
  $q_fields  = explode(",", $QUERY->fields->listed());
  $q_where   = $QUERY->where->listed(" ");
  $q_from    = $QUERY->tables->listed(",");
  $q_orderby = explode(",", $QUERY->orderby->listed());
  $q_limit   = $QUERY->limit;
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new query",         57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this query",     57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// QUERY SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("quid", "Queries", $quid, EDITABLE, "width: 250px");
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $Q = dbrecordset("SELECT * FROM ax_query_resource WHERE quid > 0 ORDER BY q_desc");
  if ($Q->rowcount > 0) {
    do {
      $qid = $Q->field("quid");
      $qdesc = $Q->field("q_desc");
      $Sel_F->additem($qid, $qdesc);
    } while ($Q->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Select:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$QUERY_SELECT = $s;

// -----------------------------------------------------------------------
// DETAILS
$s = "";
if ($recvalid) {
  // Main element width..
  $ewidth = "350px;";

  // The subform we are populating with fields..
  $q_form = new subform();
  $q_form->labelcss = "axfmlbl";

  $Tdetail = new table("details");
  $Tdetail->setpadding(2);

  // FIELD - Query ID
  if ($mode == "add") {
    $quid_F = new form_hiddenfield("quid", $quid);
  }
  else {
    $quid_F = new form_labelfield("Query ID", $quid);
  }
  $q_form->add($quid_F);


  // FIELD - Query Description
  $q_desc_F = new form_textfield("q_desc", "Description", $q_desc);
  $q_desc_F->setclass("axtxtbox");
  $q_desc_F->setstyle("width:$ewidth");
  $q_form->add($q_desc_F);


  // FIELD - Query Fields
  $q_fields_F = new form_combofield("q_fields", "Fields", $q_fields, EDITABLE, "width:$ewidth", 10, MULTISELECT);
  $q_fields_F->setclass("axlistbox");
  $q_fields_F->additem("");
  $q  = "SELECT pgc.relname as tablename, pgc.oid, pga.attname as fieldname";
  $q .= "  FROM pg_class pgc, pg_attribute pga";
  $q .= " WHERE pgc.relkind != 'i'";
  $q .= "   AND pgc.relowner > 31";
  if (isset($ALLOWED_TABLES) && count($ALLOWED_TABLES) > 0) {
    $tablelist = implode("','", $ALLOWED_TABLES);
    $q .= " AND pgc.relname IN ('$tablelist')";
  }
  $q .= "   AND pga.attrelid=pgc.oid";
  $q .= "   AND pga.attnum > 0";
  $q .= " ORDER BY pgc.relname, pga.attnum";
  $Qf = dbrecordset($q);
  if ($Qf->hasdata) {
    do {
      $q_fields_F->additem( $Qf->field("tablename") . "." . $Qf->field("fieldname") );
    } while ($Qf->get_next());
  }
  $q_form->add($q_fields_F);

  // FIELD - From clause (additional)
  $q_from_F = new form_memofield("q_from", "FROM clause", $q_from);
  $q_from_F->setclass("axmemo");
  $q_from_F->setstyle("width:$ewidth;height:80px;");
  $q_form->add($q_from_F);

  // FIELD - Where clause
  $q_where_F = new form_memofield("q_where", "WHERE clause", $q_where);
  $q_where_F->setclass("axmemo");
  $q_where_F->setstyle("width:$ewidth;height:160px;");
  $q_form->add($q_where_F);


  // FIELD - ORDER BY clause
  $q_orderby_F = new form_combofield("q_orderby", "ORDER BY", $q_orderby, EDITABLE, "width:$ewidth", 10, MULTISELECT);
  $q_orderby_F->setclass("axlistbox");
  $q_orderby_F->additem("");
  $Qf->get_first();
  if ($Qf->hasdata) {
    do {
      $q_orderby_F->additem( $Qf->field("tablename") . "." . $Qf->field("fieldname") );
    } while ($Qf->get_next());
  }
  $q_form->add($q_orderby_F);


  // FIELD - Limit
  $q_limit_F = new form_textfield("q_limit", "LIMIT", $q_limit);
  $q_limit_F->setclass("axnumbox");
  $q_form->add($q_limit_F);


  // FIELD - Script
  $q_script_F = new form_textfield("q_script", "Php Script", $q_script);
  $q_script_F->setclass("axtxtbox");
  $q_script_F->setstyle("width:$ewidth");
  $q_form->add($q_script_F);


  // FIELD - Enabled flag
  $q_enabled_F = new form_checkbox("q_enabled", "Enabled");
  $q_enabled_F->setclass("axchkbox");
  $q_enabled_F->checked = $q_enabled;
  $q_form->add($q_enabled_F);


  // PREVIEW Query text
  if ($mode != "add") {
    $sqltext = "";
    if (isset($QUERY)) {
      $QUERY->build();
      $sqltext = str_replace(",", ", ", $QUERY->sql);
    }
    $q_preview_F = new form_memofield("q_preview", "SQL Preview", $sqltext);
    $q_preview_F->setclass("axmemo");
    $q_preview_F->wrapmode = "virtual";
    $q_preview_F->setstyle("width:$ewidth;height:160px;");
    $q_preview_F->disabled = true;
    $q_form->add($q_preview_F);
  }

  $Tdetail->tr();
  $Tdetail->td( $q_form->render() );
  $Tdetail->td_alignment("center", "top");
  $s = $Tdetail->render();
}
$QUERY_DETAILS = $s;

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = "<span class=\"axerror\">$s</span>";

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="main_fm" method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--QUERY_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--QUERY_DETAILS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("QUERY_SELECT",      $QUERY_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("QUERY_DETAILS",     $QUERY_DETAILS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>