<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-login.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Axyl login page.                                        */
/*              Most website provide login forms on one of the main     */
/*              website pages, however if you need a dedicated page     */
/*              to do it, then this one will suffice.                   */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("form-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Member Login", "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// MAIN CONTENT

// Initialise..
$msgs = array();
$s = "";

// POSTed stuff - password changing..
if (isset($passwd_change_auth)) {  
  $user = new authorised_user($passwd_change_auth);
  if ($user->valid) {
    if (isset($oldPassword) && isset($newPassword)) {
      $login_result = $RESPONSE->authenticate_userid($user->userid, $oldPassword);
      if ($login_result == LOGIN_BY_PASSWD) {
        if ($newPassword != $oldPassword) {
          if ($confPassword == $newPassword) {
            if ($RESPONSE->valid_password($newPassword, $msgs)) {
              $RESPONSE->set_password($newPassword);
              $RESPONSE->save_password_data();
              if (isset($changepassword)) {
                unset($changepassword);
              }
            }
          }        
          else {
            $msgs[] = "Passwords do not match. Please try again.";
          }
        }
        else {
          $msgs[] = "Please choose a DIFFERENT password from the old one!";
        }
      }
      else {
        $msgs[] = "Change password failed - invalid original password.";
      }
    }
  }
  // Report errors from POST..
  if (count($msgs) > 0) {
    $ERROR_MSG = implode("<br>", $msgs);
  }
}

$s .= "<form name=login_fm method=POST>";
$Tlog = new table("auth");
$Tlog->setwidth("");
$Tlog->setpadding(2);
$Tlog->setalign("center");
$Tlog->setstyle("margin-top:40px;padding:30px");
$Tlog->setclass("tablestyle_7");
$Tlog->tbody("font-size:8pt;");
if ($RESPONSE->ismemberof_group("Guest")) {
  $HEADING = "Please Log In";
  
  // Prompt..
  $Tlog->tr();
  $Tlog->th( "Enter a user name and password to login" );
  $Tlog->th_colspan(3);
  $Tlog->th_alignment("center");
    
  // Username..
  $username_F = new form_textfield("user");
  $username_F->setcss("loginentry");
  $Tlog->tr();
  $Tlog->td( "Username:" );
  $Tlog->td_alignment("right");
  $Tlog->td( $username_F->render() );
  $Tlog->td( "&nbsp;" );

  // Password..
  $password_F = new form_passwordfield("pass");
  $password_F->setcss("loginentry");
  $Tlog->tr();
  $Tlog->td( "Password:" );
  $Tlog->td_alignment("right");
  $Tlog->td( $password_F->render() );
  // Login button..
  $loginbtn = new form_imagebutton("login", "Login", "", "$LIBDIR/img/_logon.gif", "Click to Login", 77, 17);
  $Tlog->td( $loginbtn->render() );
}
else {
  if (isset($changepassword) || $RESPONSE->password_expired()) {
    if ($RESPONSE->password_expired()) {
      $HEADING = "Please Change Your Expired Password";      
    }
    else {
      $HEADING = "Change of Password";
    }

    // Prompt..
    $Tlog->tr();
    $Tlog->th( "Enter a new password for " . $RESPONSE->name);
    $Tlog->th_colspan(3);
    $Tlog->th_alignment("center");
    
    // Authentication protection..
    $hidauth = new form_hiddenfield("passwd_change_auth", $RESPONSE->get_auth_code());
    $s .= $hidauth->render();
    
    // Old Password..
    $old_password_F = new form_passwordfield("oldPassword");
    $old_password_F->setcss("loginentry");
    $Tlog->tr();
    $Tlog->td( "Old Password:" );
    $Tlog->td_alignment("right");
    $Tlog->td( $old_password_F->render() );
    $Tlog->td( "&nbsp;" );
    
    // New Password..
    $password_F = new form_passwordfield("newPassword");
    $password_F->setcss("loginentry");
    $Tlog->tr();
    $Tlog->td( "New Password:" );
    $Tlog->td_alignment("right");
    $Tlog->td( $password_F->render() );
    $Tlog->td( "&nbsp;" );
    
    // Confirm Password..
    $conf_password_F = new form_passwordfield("confPassword");
    $conf_password_F->setcss("loginentry");
    $Tlog->tr();
    $Tlog->td( "Confirm:" );
    $Tlog->td_alignment("right");
    $Tlog->td( $conf_password_F->render() );    
    // Save button..
    $savebtn = new form_imagebutton("save", "Save", "", "$LIBDIR/img/_save.gif", "Change password", 57, 17);
    $Tlog->td( $savebtn->render() );
  }
  else {
    $HEADING = "You Are Logged In";

    // Prompt..
    $Tlog->tr();
    $Tlog->th( "Currently logged in as " . $RESPONSE->name);
    $Tlog->th_alignment("center");
    
    // Logout button..
    $logoutbtn = new form_imagebutton("logout", "Logout", "", "$LIBDIR/img/_logoff.gif", "Logout", 77, 17);
    $logout_F = new form_hiddenfield("tbxLogoff", "Logoff");
    $Tlog->tr();
    $Tlog->td( $logoutbtn->render() . $logout_F->render() );
    $Tlog->td_alignment("center");
    
    $href = "/axyl-login.php";
    $href = href_addparm($href, "changepassword", "yes");
    $change_password_link = new anchor($href, "Change Your Password");
    $Tlog->tr();
    $Tlog->td( $change_password_link->render(), "text-align:center;padding-top:30px;padding-bottom:10px" );
    $Tlog->td_alignment("center");    
  }
}
$s .= $Tlog->render();
$s .= "</form>";
$AXYL_LOGIN = $s;

if ($RESPONSE->microsite_detected != "") {
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
}

// #######################################################################
// CONTENT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="main_fm" method="post">
  <table border="0" cellspacing="3" cellpadding="0" width="100%" align="center">
    <tr class="axtitle">
      <td colspan="2" align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align="center" colspan="2" class="axerror"><!--ERROR_MSG--></td>
    </tr>
    <tr><td colspan="2"><hr noshade></td></tr>
    <tr>
      <td valign="top" colspan="2"><!--AXYL_LOGIN--></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("HEADING",          $HEADING);
$RESPONSE->plugin("ERROR_MSG",        $ERROR_MSG);
$RESPONSE->plugin("AXYL_LOGIN",       $AXYL_LOGIN);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>