#!/bin/bash

# Gotta have the power..
if [ $(id -u) != 0 ]
then
  echo "You must be root to run this script."
  exit 11
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL CONFIGURATION

# See if the config file is present - if so it will define
# our directories, and Axyl admin user..

# Defaults..
AXUSER=
AXYL_HOME=
AXYL_DATA=
AXYL_LOGS=
LUCENE_PORT=
AXYL_VERSION="unknown"

CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ -f $CONF ]
then
  . $CONF
  # But if they are invalid dirs, then nullify them again..
  [ ! -d $AXYL_HOME ] && AXYL_HOME=
  [ ! -d $AXYL_DATA ] && AXYL_DATA=
  [ ! -d $AXYL_LOGS ] && AXYL_LOGS=
fi

VERSIONFILE=${CONFDIR}/axyl.version
if [ -f $VERSIONFILE ]
then
  AXYL_VERSION=`cat $VERSIONFILE`
  if [ "$AXYL_VERSION" = "" ]
  then
    AXYL_VERSION="unknown"
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# GET COMMON AXYL SHELL FUNCTIONS
if [ ! -z $AXYL_HOME ] ; then
  if [ -f ${AXYL_HOME}/install/axyl-common-funcs.sh ] ; then
  	. ${AXYL_HOME}/install/axyl-common-funcs.sh
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Detect the APACHE configuration settings. Sets up the following vars:
# APACHE_NAME     # Name of the apache instance eg. 'apache2'
# APACHE_CONFDIR  # Configuration files live here
# APACHE_CONFSYS  # Type of config system: 'ap2', 'confd' or 'httpd'
# APACHE_CONF     # Path to main apache configuration file
# APACHE_USER     # User apache runs as eg. 'www-data'
# APACHE_GROUP    # Group apache runs under eg. 'www-data'
if [ ! -z $AXYL_HOME ] ; then
  if [ -f ${AXYL_HOME}/install/detect-apache.sh ] ; then
  	. ${AXYL_HOME}/install/detect-apache.sh
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# END