<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/*                                                                      */
/* Filename:    axyl-encoding-schems.php                                */
/* Author:      Paul Waite                                              */
/* Date:        September 2004                                          */
/* Description: Encoding Schemes setup page.                            */
/*              DEPRECATED in favour of the schema independent approach */
/*              using the maintainer-defs.php module. This is retained  */
/*              for non-Postgres implementations of Axyl due to the     */
/*              schema-independent parts not being written as yet.      */
/*                                                                      */
/************************************************************************/
include_once("application.php");
include_once("recmaint-defs.php");

// -----------------------------------------------------------------------
// You can customise these values, and most of the work of changing to
// maintain another single-key table is done. You still have to go
// and define the individual field retreival/save/widgets though!

// Heading for the maintainer..
$HEADING = "METADATA ENCODING SCHEMES";

$maint_formname = "main_fm";

// Name of the table being maintained..
$maint_tablename = "ax_enc_scheme";

// Name of the key field for this record..
$record_keyfield = "enc_scheme_id";

// Name of field to display in dropdown menu..
$record_displayfield = "enc_scheme_name";

// Width style for the selector dropdown..
$selector_width = "width:250px";

// Short form widget width - eg. for dates, abrrevs etc.
$smallpx = "width:150px";
// General textbox widget width
$normpx = "width:250px";
// Wide widget width - eg. memo fields, drop-downs
$widepx = "width:350px";
// Extra-Wide widget width - eg. long URL text fields etc.
$ewidepx = "width:450px";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take
$recvalid = false;
if (isset($$record_keyfield)) {
  $record_keyvalue = $$record_keyfield;
}
// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);


// #######################################################################
// POST PROCESSING

// SAVE SETUP
if ($mode == "save") {
  if (isset($record_keyvalue)) {
    if ($mode == "add") {
      $query = new dbinsert($maint_tablename);
      $query->set($record_keyfield, $record_keyvalue);
    }
    else {
      $query = new dbupdate("$maint_tablename");
      $query->where("$record_keyfield='$record_keyvalue'");
    }
    $query->set("enc_scheme_name", $enc_scheme_name);
    $query->set("label",           $label);
    $query->set("tag_name",        $tag_name);
    $query->set("description",     $description);
    $query->set("datasrc_uri",     $datasrc_uri);
    $query->set("reference_url",   $reference_url);
    $query->set("enabled",         isset($enabled));
    $query->execute();
    $mode = "edit";

    // Scheme Value Deletes..
    if (isset($vals_recmaintpost_dels) && $vals_recmaintpost_dels != "") {
      $delids = explode(FIELD_DELIM, $vals_recmaintpost_dels);
      foreach ($delids as $delid) {
        $vdel = new dbdelete("ax_enc_value");
        $vdel->where("enc_scheme_id=$record_keyvalue");
        $vdel->where("AND enc_value='" . escape_string($delid) . "'");
        $vdel->execute();
      }
    }
    // Scheme Value Add and Save..
    if (isset($vals_recmaintpost_data) && $vals_recmaintpost_data != "") {
      $recs = explode(RECORD_DELIM, $vals_recmaintpost_data);
      foreach ($recs as $rec) {
        $values = explode(FIELD_DELIM, $rec);
        $recid = array_shift($values);
        $fields = explode(",", $vals_recmaintpost_flds);
        if (strstr($recid, "NEW_")) {
          $up = new dbinsert("ax_enc_value");
          $up->set("enc_scheme_id", $record_keyvalue);
          $new = true;
        }
        else {
          $up = new dbupdate("ax_enc_value");
          $up->where("enc_scheme_id=$record_keyvalue");
          $up->where("AND enc_value='" . escape_string($recid) . "'");
          $new = false;
        }
        $pos = 0;
        foreach ($fields as $field) {
          if ($new || $field != "enc_value") {
            $value = $values[$pos];
            $up->set($field, $value);
          }
          $pos += 1;
        }
        $up->execute();
      } // foreach saved record
    }
    // Scheme Qualifier Deletes..
    if (isset($qual_recmaintpost_dels) && $qual_recmaintpost_dels != "") {
      $delids = explode(FIELD_DELIM, $qual_recmaintpost_dels);
      foreach ($delids as $delid) {
        $vdel = new dbdelete("ax_enc_qualifier");
        $vdel->where("enc_scheme_id=$record_keyvalue");
        $vdel->where("AND qual_name='" . escape_string($delid) . "'");
        $vdel->execute();
      }
    }
    // Scheme Qualifier Add and Save..
    if (isset($qual_recmaintpost_data) && $qual_recmaintpost_data != "") {
      $recs = explode(RECORD_DELIM, $qual_recmaintpost_data);
      foreach ($recs as $rec) {
        $values = explode(FIELD_DELIM, $rec);
        $recid = array_shift($values);
        $fields = explode(",", $qual_recmaintpost_flds);
        if (strstr($recid, "NEW_")) {
          $up = new dbinsert("ax_enc_qualifier");
          $up->set("enc_scheme_id", $record_keyvalue);
          $new = true;
        }
        else {
          $up = new dbupdate("ax_enc_qualifier");
          $up->where("enc_scheme_id=$record_keyvalue");
          $up->where("AND qual_name='" . escape_string($recid) . "'");
          $new = false;
        }
        $pos = 0;
        foreach ($fields as $field) {
          if ($new || $field != "qual_name") {
            $value = $values[$pos];
            $up->set($field, $value);
          }
          $pos += 1;
        }
        $up->execute();
      } // foreach saved record
    }
    // Scheme Qualifier Ordering..
    if (isset($qual_recmaintpost_order) && $qual_recmaintpost_order != "") {
      $ord = 1;
      $idlist = explode(FIELD_DELIM, $qual_recmaintpost_order);
      foreach ($idlist as $recid) {
        $up = new dbupdate("ax_enc_qualifier");
        $up->where("enc_scheme_id=$record_keyvalue");
        $up->where("AND qual_name='" . escape_string($recid) . "'");
        $up->set("display_order", $ord);
        $up->execute();
        $ord += 1;
      }
    }

  }
}
// DELETE PACKAGE
elseif ($mode == "remove") {
  if (isset($record_keyvalue)) {
    dbcommand("DELETE FROM $maint_tablename WHERE $record_keyfield=$record_keyvalue");
  }
  $record_keyvalue = 0;
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW PACKAGE
elseif (isset($add_x)) {
  $record_keyvalue = get_next_sequencevalue("seq_$record_keyfield", "$maint_tablename", "$record_keyfield");
  $enc_scheme_name = "";
  $label = "";
  $tag_name = "";
  $description = "";
  $datasrc_uri = "";
  $reference_url = "";
  $enabled = true;
  $HEADING .= " - New";
  $recvalid = true;
  $mode = "add";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------
// Get current package, if any..
if ($mode != "add" && isset($record_keyvalue)) {
  $recordQ = dbrecordset("SELECT * FROM $maint_tablename WHERE $record_keyfield=$record_keyvalue");
  if ($recordQ->hasdata) {
    // Populate all table field values here..
    $enc_scheme_name = $recordQ->field("enc_scheme_name");
    $label           = $recordQ->field("label");
    $tag_name        = $recordQ->field("tag_name");
    $description     = $recordQ->field("description");
    $datasrc_uri     = $recordQ->field("datasrc_uri");
    $reference_url   = $recordQ->field("reference_url");
    $enabled         = $recordQ->istrue("enabled");
    $recvalid = true;
  }
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// DEFINE CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new record",        57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this record",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$savbtn->set_onclick("document.forms.$maint_formname.mode.value='save';");

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield($record_keyfield, ucfirst(strtolower($HEADING)));
  $Sel_F->setclass("axcombo");
  $Sel_F->setstyle($selector_width);
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $oQ = dbrecordset("SELECT * FROM $maint_tablename ORDER BY $record_displayfield");
  if ($oQ->rowcount > 0) {
    do {
      $keyvalue = $oQ->field($record_keyfield);
      $keylabel = $oQ->field($record_displayfield);
      $Sel_F->additem($keyvalue, $keylabel);
    } while ($oQ->get_next());
  }
  $Sel_F->setvalue($record_keyvalue);
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>" . ucfirst(strtolower($HEADING)) . ":</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$REC_SELECT = $s;

// -----------------------------------------------------------------------
// DETAILS
$s = "";
if ($recvalid) {
  $Tdetail = new table("details");
  $Tdetail->setpadding(2);
  $Tdetail->tr();
  $Tdetail->td("<h3>SCHEME DETAILS</h3>" );

  // FIELD - ID
  if ($mode == "add") {
    $oid_F = new form_hiddenfield($record_keyfield, $record_keyvalue);
  }
  else {
    $oid_F = new form_labelfield("Element ID", $record_keyvalue);
  }
  // FIELD - Encoding scheme name
  $schn_F = new form_textfield("enc_scheme_name", "Scheme name", $enc_scheme_name);
  $schn_F->setclass("axtxtbox");
  $schn_F->setstyle($normpx);

  // FIELD - Label
  $lab_F = new form_textfield("label", "Label", $label);
  $lab_F->setclass("axtxtbox");
  $lab_F->setstyle($widepx);

  // FIELD - Tag name
  $tag_F = new form_textfield("tag_name", "Tag name", $tag_name);
  $tag_F->setclass("axtxtbox");
  $tag_F->setstyle($smallpx);

  // FIELD - Description
  $desc_F = new form_memofield("description", "Description", $description);
  $desc_F->setclass("axmemo");
  $desc_F->setstyle("$widepx;height:100px");

  // FIELD - Datasource URI
  $dats_F = new form_textfield("datasrc_uri", "Datasource URI", $datasrc_uri);
  $dats_F->setclass("axtxtbox");
  $dats_F->setstyle($ewidepx);

  // FIELD - Reference URL
  $refurl_F = new form_textfield("reference_url", "Reference URL", $reference_url);
  $refurl_F->setclass("axtxtbox");
  $refurl_F->setstyle($ewidepx);

  // FIELD - Enabled
  $enb_F = new form_checkbox("enabled", "Enabled");
  $enb_F->setclass("axchkbox");
  $enb_F->checked = $enabled;

  // FORM..
  $oform = new subform();
  $oform->add($schn_F);
  $oform->add($oid_F);
  $oform->add($lab_F);
  $oform->add($tag_F);
  $oform->add($desc_F);
  $oform->add($dats_F);
  $oform->add($refurl_F);
  $oform->add($enb_F);

  $Tdetail->tr();
  $Tdetail->td( $oform->render() );
  $Tdetail->td_alignment("center", "top");
  $s = $Tdetail->render();
}
$REC_DETAILS = $s;

// ------------------------------------------------------------------
// SCHEME VALUES
// These are key/value pairs which are defined by this scheme.

// KEYFIELD and RECORD MAINTAINER
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$vals_listbox = new form_combofield("vals_keyvalue");
$vals_listbox->setclass("axlistbox");
$vals_listbox->setstyle("width:$ewidth;");
$vals_listbox->size = 16;

// Make a new record maintainer, and attach the buttons..
$vals_maintainer = new recmaintainer($maint_formname, $vals_listbox, "vals_");

// Register all relevant buttons to the maintainer..
$vadd = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new value", 57, 15 );
$vdel = new form_imagebutton("delete", "", "", "$LIBDIR/img/_delete.gif", "Delete value",  57, 15 );
$vals_maintainer->register_button("store",   $savbtn);
$vals_maintainer->register_button("delete", $vdel);
$vals_maintainer->register_button("add",    $vadd);

$Ted = new table("scheme_values");
$Ted->setpadding(2);
$Ted->setalign("center");

// ..................................................................
// Heading..
$Ted->tr("axhdg");
$Ted->td("<b>SCHEME VALUES</b>", "axhdg");
$Ted->td_colspan(2);

$Ted->tr("axbglite");
$Ted->td("&nbsp;");
$Ted->td_colspan(2);
$Ted->td_height(26);

// Continue defining listbox..
$q  = "SELECT *";
$q .= "  FROM ax_enc_value";
$q .= " WHERE enc_scheme_id=$record_keyvalue";
$q .= " ORDER BY enc_label";
$encvals = dbrecordset($q);
$encvals_count = $encvals->rowcount;
if ($encvals_count > 0) {
  do {
    // Populate listbox..
    $enc_val = $encvals->field("enc_value");
    $enc_lab = $encvals->field("enc_label");
    $vals_listbox->additem($enc_val, $enc_lab);

    // Populate maintainer data. The maintainer add_record method
    // requires an associative array keyed on listbox key id..
    $rec = array(
            "enc_value" => $enc_val,
            "enc_label" => $enc_lab
            );
    $vals_maintainer->add_record($enc_val, $rec);

    // If this is the element being edited, make sure
    // that it gets focussed..
    if (isset($enc_value) && $enc_value == $enc_val) {
      $vals_maintainer->initial_record($enc_value);
    }
  } while ($encvals->get_next());
}
$defaults = array(
  "enc_value" => "",
  "enc_label" => ""
  );
$vals_maintainer->add_defaults( $defaults );

// ..................................................................
// The listbox field..
$Ted->tr("axbgdark");
$Ted->td( $vals_listbox->render() );
$Ted->td_alignment("right");

// ..................................................................
$Tf = new table("value_fields");
$Tf->setpadding(3);

$Fld = new form_textfield("enc_value");
$Fld->setstyle($smallpx);
$Fld->setclass("axtxtbox");
$vals_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Value:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("enc_label");
$Fld->setstyle($normpx);
$Fld->setclass("axtxtbox");
$vals_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Label:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Tf->tr( "axbgdark" );
$Tf->td( "&nbsp;", "axfg" );
$Tf->td( $vadd->render() . "&nbsp;" . $vdel->render() );
$Tf->set_width_profile("30%,70%");

// ..................................................................
// Put fields & buttons in main table..
$Ted->td( $Tf->render() );
$Ted->td_alignment("", "bottom");

// ..................................................................
// Spacer..
$Ted->tr("axbglite");
$Ted->td("&nbsp;");
$Ted->td_colspan(2);
$Ted->td_height(26);

// ..................................................................
// Render the whole form..
$Ted->tr("axtitle");
$Ted->td("&nbsp;", "axtitle");
$Ted->td_colspan(2);

$Ted->set_width_profile("30%,70%");
$SCHEME_VALUES .= $Ted->render();

// Render the maintainer. This adds the Javascript data structures
// and renders the hidden fields for submitting changed field data..
$SCHEME_VALUES .= $vals_maintainer->render();

// ------------------------------------------------------------------
// SCHEME QUALIFIERS
// These are key/value pairs which are defined by this scheme.

// KEYFIELD and RECORD MAINTAINER
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$qual_listbox = new form_combofield("qual_keyvalue");
$qual_listbox->setclass("axlistbox");
$qual_listbox->setstyle("width:$ewidth;");
$qual_listbox->size = 16;

// Make a new record maintainer, and attach the buttons..
$qual_maintainer = new recmaintainer($maint_formname, $qual_listbox, "qual_");

// Register all relevant buttons to the maintainer..
$qadd  = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new qualifier", 57, 15 );
$qdel  = new form_imagebutton("delete", "", "", "$LIBDIR/img/_delete.gif", "Delete qualifier",  57, 15 );
$qup   = new form_imagebutton("up",     "", "", "$LIBDIR/img/_up.gif",     "Move up",           57, 15 );
$qdown = new form_imagebutton("down",   "", "", "$LIBDIR/img/_down.gif",   "Move down",         57, 15 );
$qual_maintainer->register_button("save",   $savbtn);
$qual_maintainer->register_button("add",    $qadd);
$qual_maintainer->register_button("delete", $qdel);
$qual_maintainer->register_button("up",     $qup);
$qual_maintainer->register_button("down",   $qdown);

$Ted = new table("scheme_qualifiers");
$Ted->setpadding(2);
$Ted->setalign("center");

// ..................................................................
// Heading..
$Ted->tr("axhdg");
$Ted->td("<b>SCHEME QUALIFIERS</b>", "axhdg");
$Ted->td_colspan(2);

$Ted->tr("axbglite");
$Ted->td("&nbsp;");
$Ted->td_colspan(2);
$Ted->td_height(26);

// Continue defining listbox..
$q  = "SELECT *";
$q .= "  FROM ax_enc_qualifier";
$q .= " WHERE enc_scheme_id=$record_keyvalue";
$q .= " ORDER BY display_order";
$encquals = dbrecordset($q);
$encqual_count = $encquals->rowcount;
if ($encqual_count > 0) {
  do {
    // Populate listbox..
    $qualname  = $encquals->field("qual_name");
    $quallabel = $encquals->field("qual_label");
    $qualcomm  = $encquals->field("comments");
    $defltval  = $encquals->field("default_value");
    $vallist   = $encquals->field("list_of_values");

    $qual_listbox->additem($qualname, $quallabel);

    // Populate maintainer data. The maintainer add_record method
    // requires an associative array keyed on listbox key id..
    $rec = array(
            "qual_name" => $qualname,
            "qual_label" => $quallabel,
            "comments" => $qualcomm,
            "default_value" => $defltval,
            "list_of_values" => $vallist
            );
    $qual_maintainer->add_record($qualname, $rec);

    // If this is the element being edited, make sure
    // that it gets focussed..
    if (isset($qual_name) && $qual_name == $qualname) {
      $qual_maintainer->initial_record($qual_name);
    }
  } while ($encquals->get_next());
}

$defaults = array(
  "qual_name" => "",
  "qual_label" => "",
  "comments" => "",
  "default_value" => "",
  "list_of_values" => ""
  );
$qual_maintainer->add_defaults( $defaults );

// ..................................................................
// The listbox field..
$Ted->tr("axbgdark");
$Ted->td( $qual_listbox->render() );
$Ted->td_alignment("right");

// ..................................................................
$Tf = new table("value_fields");
$Tf->setpadding(3);

$Fld = new form_textfield("qual_name");
$Fld->setstyle($smallpx);
$Fld->setclass("axtxtbox");
$qual_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Name:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("qual_label");
$Fld->setstyle($normpx);
$Fld->setclass("axtxtbox");
$qual_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Label:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Fld = new form_memofield("comments");
$Fld->setstyle("$normpx;height:100px;");
$Fld->setclass("axmemo");
$qual_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Comments:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("default_value");
$Fld->setstyle($normpx);
$Fld->setclass("axtxtbox");
$qual_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "Default:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("list_of_values");
$Fld->setstyle($widepx);
$Fld->setclass("axtxtbox");
$qual_maintainer->register_field($Fld);
$Tf->tr( "axbgdark" );
$Tf->td( "List of values:", "axfg" );
$Tf->td_alignment("right");
$Tf->td( $Fld->render() );

// ..................................................................
$Tf->tr( "axbgdark" );
$Tf->td( "&nbsp;", "axfg" );
$Tf->td( $vadd->render() . "&nbsp;" . $vdel->render() );
$Tf->set_width_profile("30%,70%");

// ..................................................................
// Put fields & buttons in main table..
$Ted->td( $Tf->render() );
$Ted->td_alignment("", "bottom");

// ..................................................................
// Spacer..
$Ted->tr("axbgdark");
$Ted->td( $qup->render() . "&nbsp;" . $qdown->render() );
$Ted->td_alignment("right");
$Ted->td();

// ..................................................................
// Spacer..
$Ted->tr("axbglite");
$Ted->td("&nbsp;");
$Ted->td_colspan(2);
$Ted->td_height(26);

// ..................................................................
// Render the whole form..
$Ted->tr("axtitle");
$Ted->td("&nbsp;", "axtitle");
$Ted->td_colspan(2);

$Ted->set_width_profile("30%,70%");
$SCHEME_QUALIFIERS .= $Ted->render();

// Render the maintainer. This adds the Javascript data structures
// and renders the hidden fields for submitting changed field data..
$SCHEME_QUALIFIERS .= $qual_maintainer->render();

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// RENDER CONTROL BUTTONS
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=main_fm method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--REC_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--REC_DETAILS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td valign=top colspan=2><!--SCHEME_VALUES--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--SCHEME_QUALIFIERS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("REC_SELECT",        $REC_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("REC_DETAILS",       $REC_DETAILS);
$RESPONSE->plugin("SCHEME_VALUES",     $SCHEME_VALUES);
$RESPONSE->plugin("SCHEME_QUALIFIERS", $SCHEME_QUALIFIERS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>