--
-- AXYL Microsites Sub-system
-- The data inserts below are the standard Axyl microsites definitions. These
-- include the basic support data for microsites, and the menu options for
-- accessing microsites functionality.
--
-- Name: axyl_microsite_data.sql
-- Created: 2005-02-17
--
insert into "ax_sitepage" ("page_id","page_title","page_path","managed","enabled") values (40,'Microsite Control','/axyl-microsites.php',0,1);
insert into "ax_sitepage" ("page_id","page_title","page_path","managed","enabled") values (41,'Plugin Areas','/axyl-plugin-areas.php',0,1);
insert into "ax_sitepage" ("page_id","page_title","page_path","managed","enabled") values (42,'Plugin Content','/axyl-plugin-content.php',0,1);

-- MICROSITE PAGES SITEPAGE SECURITY
-- Microsite Control
insert into "ax_sitepage_group" ("page_id","group_id") values(40,1);
insert into "ax_sitepage_group" ("page_id","group_id") values(40,3);
-- Plugin Areas
insert into "ax_sitepage_group" ("page_id","group_id") values(41,1);
insert into "ax_sitepage_group" ("page_id","group_id") values(41,3);
-- Plugin Content
insert into "ax_sitepage_group" ("page_id","group_id") values(42,1);
insert into "ax_sitepage_group" ("page_id","group_id") values(42,3);

-- MICROSITE MENU OPTIONS
insert into "ax_menuoption" ("menu_id","menuoption_id","is_parent","parent_id","user_groups","user_type","menu_level","label","description","display_order","action","auth_code","active","width","height","sitepage","sitepage_parms")
values (1,40,1,10,'Admin,Editor','',1,'MICROSITES','Microsites maintenance',40,'',0,1,110,20,'','');
insert into "ax_menuoption" ("menu_id","menuoption_id","is_parent","parent_id","user_groups","user_type","menu_level","label","description","display_order","action","auth_code","active","width","height","sitepage","sitepage_parms")
values (1,41,0,40,'Admin,Editor','',2,'Microsite control','Manage all microsites',1,'/axyl-microsites.php',0,1,120,20,'/axyl-microsites.php','');
insert into "ax_menuoption" ("menu_id","menuoption_id","is_parent","parent_id","user_groups","user_type","menu_level","label","description","display_order","action","auth_code","active","width","height","sitepage","sitepage_parms")
values (1,42,0,40,'Admin,Editor','',2,'Plugin areas','Maintain Axyl plugin areas',2,'/axyl-plugin-areas.php',0,1,140,20,'/axyl-plugin-areas.php','');
insert into "ax_menuoption" ("menu_id","menuoption_id","is_parent","parent_id","user_groups","user_type","menu_level","label","description","display_order","action","auth_code","active","width","height","sitepage","sitepage_parms")
values (1,43,0,40,'Admin,Editor','',2,'Plugin content','Maintain Axyl plugin content definitions',3,'/axyl-plugin-content.php',0,1,130,20,'/axyl-plugin-content.php','');

-- ENSURE SEQUENCES
select setval('seq_plugin_id', (select max(plugin_id) from ax_microsite_page_plugin));
select setval('seq_microsite_page_id', (select max(microsite_page_id) from ax_microsite_page));
select setval('seq_microsite_template_id', (select max(microsite_template_id) from ax_microsite_template));

-- PLUGIN AREA DATA
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('MAIN_CONTENT', 'Main content area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('MAIN_MENU', 'Main menu area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('MEMBER_LOGIN', 'User login area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('LEFT_SIDEBAR', 'Left sidebar area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('RIGHT_SIDEBAR', 'Right sidebar area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('HEADER', 'Header area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('FOOTER', 'Footer area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('FEATURED_NEWS_ITEM', 'Featured news item area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('LATEST_NEWS_ITEMS', 'Latest news items area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('FORUMS', 'Forums area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('SITE_SEARCH', 'Site search field area');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('CLOCK', 'Clock with time only');
insert into ax_plugin_area (plugin_pattern, plugin_desc) values ('CLOCK_WITH_DATE', 'Clock with date and time');

-- PLUGIN CONTENT DATA
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('search_form', 'Search form', 'search_form()', 'func', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('search_results', 'Search results', 'search_results()', 'func', 1);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('forums', 'Forums', '', 'lit', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('feat', 'Featured news item', 'featured_news_item()', 'defer', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('latest', 'Latest news items list', 'latest_news()', 'defer', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('main_menu', 'Main menu', 'main_menu()', 'defer', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('member_login', 'Member login form', 'member_login()', 'defer', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('cm', 'Content-managed layout', 'AutoCM', 'cm', 0);
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('clock', 'Updating clock', 'clock()', 'func', 'f');
insert into ax_plugin_content (plugin_content, plugin_content_desc, generator, generator_type, replace_content) values ('clock_with_date', 'Updating clock with date', 'clock_with_date()', 'func', 'f');

-- END