#!/bin/bash

# Find first free port above port $1 and allocate it in
# the services file, if <servicename> is given..
if [ "$1" = "" ]; then
  echo "usage: findport <startport> [<servicename> <service comment>]"
  exit 1
fi

SERVICES=/etc/services
STARTPORT=$1; shift
FOUNDPORT=
SERVICENAME=
SERVICECOMMENT=
[ "$1" != "" ] && SERVICENAME=$1; shift
[ "$1" != "" ] && SERVICECOMMENT=$*

# Check if <servicename> already assigned in /etc/services first..
if [ "$SERVICENAME" != "" ]; then
  A=`grep -E "^$SERVICENAME[[:space:]]" $SERVICES`
  if [ "$A" != "" ]; then
    FOUNDPORT=`echo $A | cut -d" " -f2`
    FOUNDPORT=`echo $FOUNDPORT | cut -d"/" -f1`
    echo $FOUNDPORT
    exit 0
  fi
fi

# Test for services allocation..
echo "searching.."
TRYPORT=$STARTPORT
FINISHED=0
while [ $FINISHED -eq 0 ]; do
  echo "trying port $TRYPORT"
  A=`grep -c -E -e "^[^#].*?[^0-9a-zA-Z]+${TRYPORT}/tcp" $SERVICES`
  if [ $A -eq 0 ]; then
    B=`netstat -apn|grep -c -E ":${TRYPORT}[[:space:]]"`
    if [ $B -eq 0 ]; then
      FOUNDPORT=$TRYPORT
      FINISHED=1
      if [ "$SERVICENAME" != "" ]; then
        NEWSERVICE="${SERVICENAME} ${FOUNDPORT}/tcp"
        if [ "$SERVICECOMMENT" != "" ]; then
          NEWSERVICE="$NEWSERVICE # $SERVICECOMMENT"
        fi
        echo $NEWSERVICE >> $SERVICES
      fi
    else
      echo "process listening on that port"
    fi
  else
    echo "found in services file"
  fi
  TRYPORT=`expr $TRYPORT + 1`
done

echo $FOUNDPORT