<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-groups.php                                         */
/* Author:      Paul Waite                                              */
/* Date:        February 2002                                           */
/* Description: Groups setup page                                       */
/*              DEPRECATED in favour of the schema independent approach */
/*              using the maintainer-defs.php module. This is retained  */
/*              for non-Postgres implementations of Axyl due to the     */
/*              schema-independent parts not being written as yet.      */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "User Groups Setup";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take
$recvalid = false;

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);


// #######################################################################
// POST PROCESSING

// SAVE SETUP
if (isset($save_x)) {
  if (isset($group_id)) {
    // DETAILS
    if ($mode == "add") {
      $query = new dbinsert("ax_group");
      $query->set("group_id", $group_id);
    }
    else {
      $query = new dbupdate("ax_group");
      $query->where("group_id='$group_id'");
    }
    $query->set("group_desc",   $group_desc);
    $query->execute();
    $mode = "edit";
  } // isset group_id
}
// DELETE
elseif ($mode == "remove") {
  if (isset($group_id)) {
    dbcommand("DELETE FROM ax_group WHERE group_id=$group_id");
  }
  $group_id = 0;
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW
elseif (isset($add_x)) {
  $group_id = get_next_sequencevalue("seq_group_id", "ax_group", "group_id");
  $role_name = "";
  $group_desc = "";
  $HEADING .= " - New";

  $recvalid = true;
  $mode = "add";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------
// Get current package, if any..
if ($mode != "add" && isset($group_id) && $group_id != 0) {
  $role = dbrecordset("SELECT * FROM ax_group WHERE group_id=$group_id");
  if ($role->hasdata) {
    $group_desc    = $role->field("group_desc");
    $HEADING .= " - $group_desc";
    $recvalid = true;
  }
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new record",        57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this record",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("group_id", "User Groups", $group_id, EDITABLE, "width: 250px");
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $oQ = dbrecordset("SELECT * FROM ax_group WHERE group_id > 0 ORDER BY group_desc");
  if ($oQ->rowcount > 0) {
    do {
      $groupid = $oQ->field("group_id");
      $groupdesc = $oQ->field("group_desc");
      $Sel_F->additem($groupid, $groupdesc);
    } while ($oQ->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Group:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$REC_SELECT = $s;

// -----------------------------------------------------------------------
// DETAILS
$s = "";
if ($recvalid) {
  $Tdetail = new table("details");
  $Tdetail->setpadding(2);
  $Tdetail->tr();
  $Tdetail->td("<h4>Details</h4>" );

  // FIELD - ID
  if ($mode == "add") {
    $oid_F = new form_hiddenfield("group_id", $group_id);
  }
  else {
    $oid_F = new form_labelfield("Group ID", $group_id);
  }

  // FIELD - Description
  $desc_F = new form_textfield("group_desc", "Description", $group_desc);
  $desc_F->setstyle("width: 300px");

  // FORM..
  $oform = new subform();
  $oform->add($oid_F);
  $oform->add($desc_F);

  $Tdetail->tr();
  $Tdetail->td( $oform->render() );
  $Tdetail->td_alignment("center", "top");
  $s = $Tdetail->render();
}
$REC_DETAILS = $s;

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=main_fm method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--REC_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--REC_DETAILS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("REC_SELECT",        $REC_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("REC_DETAILS",       $REC_DETAILS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>