
Name "Autopano-SIFT v2.3"
OutFile "autopano-sift-2.3-win-1.exe"

InstallDir $PROGRAMFILES\Autopano-SIFT-2.3
InstallDirRegKey HKLM "Software\Autopano_SIFT_23" "Install_Dir"

SetCompressor lzma

Page directory
Page instfiles

!define DOT_MAJOR "1"
!define DOT_MINOR "1"

Function .onInit
	Call IsDotNetInstalled

	; Not used anymore
	;Call IsGTKSharpInstalled
FunctionEnd

Section "Autopano-SIFT 2.3 (required)"
	SectionIn RO
	SetOutPath $INSTDIR
	File "windows-bin\ICSharpCode.SharpZipLib.dll"
	File "windows-bin\autopano.exe"
	File "windows-bin\autopanog.exe"
	File "windows-bin\autopano-win32.exe"
	CreateDirectory $INSTDIR\icons
	File /oname=icons\image-bottom-left.png "windows-bin\icons\image-bottom-left.png"
	File /oname=icons\image-bottom-right.png "windows-bin\icons\image-bottom-right.png"
	File "windows-bin\generatekeys.exe"
	File "windows-bin\libsift.dll"
	File "windows-bin\showone.exe"
	File "windows-bin\showtwo.exe"

	; supplementary files
	File "windows-bin\LICENSE.txt"
	File "windows-bin\CHANGES.txt"
	File "windows-bin\WINDOWS-README.txt"

	; desktop shortcut
	File "windows-bin\win-autopano-sift.vbs"
	File "windows-bin\win-autopano-sift-cmdline.vbs"

	; documentation
	File "doc\*.pdf"
	File "doc\*.txt"
	File "doc\*.1"
	File "doc\*.7"

	; Source distribution itself
	File "*.tar.gz"

	WriteRegStr HKLM Software\Autopano_SIFT_23 "Install_Dir" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Autopano_SIFT_23" "DisplayName" "Autopano-SIFT 2.3"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Autopano_SIFT_23" "UninstallString" '"$INSTDIR\uninstall.exe"'
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Autopano_SIFT_23" "NoModify" 1
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Autopano_SIFT_23" "NoRepair" 1
	WriteUninstaller "uninstall.exe"
SectionEnd

Section "Start Menu Shortcuts"
	CreateDirectory "$SMPROGRAMS\Autopano-SIFT 2.3"
	CreateShortCut "$SMPROGRAMS\Autopano-SIFT 2.3\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0

	; The native Windows GUI
	; $OUTDIR is used for the working directory
	SetOutPath $INSTDIR
	CreateShortCut "$SMPROGRAMS\Autopano-SIFT 2.3\Autopano-SIFT GUI.lnk" "$INSTDIR\autopano-win32.exe" "" "$INSTDIR\autopano-win32.exe" 0

	CreateShortCut "$SMPROGRAMS\Autopano-SIFT 2.3\LICENSE.lnk" "$INSTDIR\LICENSE.txt" "" "$INSTDIR\LICENSE.txt" 0
	CreateShortCut "$SMPROGRAMS\Autopano-SIFT 2.3\CHANGES.lnk" "$INSTDIR\CHANGES.txt" "" "$INSTDIR\CHANGES.txt" 0
	CreateShortCut "$SMPROGRAMS\Autopano-SIFT 2.3\WINDOWS README.lnk" "$INSTDIR\WINDOWS-README.txt" "" "$INSTDIR\WINDOWS-README.txt" 0

	CreateShortCut "$DESKTOP\Autopano-SIFT.lnk" "$INSTDIR\win-autopano-sift.vbs"
	CreateShortCut "$DESKTOP\Autopano-SIFT-Cmdline.lnk" "$INSTDIR\win-autopano-sift-cmdline.vbs"
SectionEnd

Section "Uninstall"
	; Remove registry keys
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Autopano_SIFT_23"
	DeleteRegKey HKLM Software\Autopano_SIFT_23

	; Remove files and uninstaller
	Delete $INSTDIR\uninstall.exe
	Delete $INSTDIR\ICSharpCode.SharpZipLib.dll
	Delete $INSTDIR\autopano.exe
	Delete $INSTDIR\autopanog.exe
	Delete $INSTDIR\autopano-win32.exe
	Delete $INSTDIR\icons\image-bottom-left.png
	Delete $INSTDIR\icons\image-bottom-right.png
	RMDir $INSTDIR\icons
	Delete $INSTDIR\generatekeys.exe
	Delete $INSTDIR\libsift.dll
	Delete $INSTDIR\showone.exe
	Delete $INSTDIR\showtwo.exe

	; supplementary Deletes
	Delete $INSTDIR\LICENSE.txt
	Delete $INSTDIR\CHANGES.txt
	Delete $INSTDIR\WINDOWS-README.txt

	; Desktop shortcut script
	Delete $INSTDIR\win-autopano-sift.vbs
	Delete $INSTDIR\win-autopano-sift-cmdline.vbs

	; documentation
	Delete $INSTDIR\*.pdf
	Delete $INSTDIR\*.txt
	Delete $INSTDIR\*.1
	Delete $INSTDIR\*.7

	; Source distribution
	Delete $INSTDIR\*.tar.gz

	; Remove shortcuts in start menu and on the desktop, if any
	Delete "$SMPROGRAMS\Autopano-SIFT 2.3\*.*"
	RMDir "$SMPROGRAMS\Autopano-SIFT 2.3"
	Delete "$DESKTOP\Autopano-SIFT.lnk"
	Delete "$DESKTOP\Autopano-SIFT-Cmdline.lnk"

	; Remove directories used
	RMDir "$INSTDIR"
SectionEnd

Function IsGTKSharpInstalled
	IfFileExists "$WINDIR\assembly\GAC\gtk-sharp\*.*" yesGtkSharp noGtkSharp

noGtkSharp:
	MessageBox MB_OK|MB_ICONEXCLAMATION \
"You do not have the GTK# toolkit version 1.0 or greater installed. To use the \
GUI and the utility programs it is recommended you install it. \
However, the core functionality is also available without installing it. \
$\n$\nClick 'Open' in the following file dialog to open the appropiate GTK# \
Sharp installer download website. Download and install the 1.0 installer, \
then start this installer again. The GTK# installer may be a ZIP file, but \
There is an executeable installer included."
	ExecShell Open "http://forge.novell.com/modules/xfmod/project/?gtks-inst4win" SW_SHOWNORMAL
;	Quit
yesGtkSharp:
FunctionEnd

; Usage
; Define in your script two constants:
;   DOT_MAJOR "(Major framework version)"
;   DOT_MINOR "{Minor frameword version)"
; 
; Call IsDotNetInstalled
; This function will abort the installation if the required version 
; or higher version of the .NETFramework is not installed.  Place it in
; either your .onInit function or your first install section before 
; other code.
Function IsDotNetInstalled

  StrCpy $0 "0"
  StrCpy $1 "SOFTWARE\Microsoft\.NETFramework" ;registry entry to look in.
  StrCpy $2 0

  StartEnum:
    ;Enumerate the versions installed.
    EnumRegKey $3 HKLM "$1\policy" $2
    
    ;If we don't find any versions installed, it's not here.
    StrCmp $3 "" noDotNet notEmpty
    
    ;We found something.
    notEmpty:
      ;Find out if the RegKey starts with 'v'.  
      ;If it doesn't, goto the next key.
      StrCpy $4 $3 1 0
      StrCmp $4 "v" +1 goNext
      StrCpy $4 $3 1 1
      
      ;It starts with 'v'.  Now check to see how the installed major version
      ;relates to our required major version.
      ;If it's equal check the minor version, if it's greater, 
      ;we found a good RegKey.
      IntCmp $4 ${DOT_MAJOR} +1 goNext yesDotNetReg
      ;Check the minor version.  If it's equal or greater to our requested 
      ;version then we're good.
      StrCpy $4 $3 1 3
      IntCmp $4 ${DOT_MINOR} yesDotNetReg goNext yesDotNetReg

    goNext:
      ;Go to the next RegKey.
      IntOp $2 $2 + 1
      goto StartEnum

  yesDotNetReg:
    ;Now that we've found a good RegKey, let's make sure it's actually
    ;installed by getting the install path and checking to see if the 
    ;mscorlib.dll exists.
    EnumRegValue $2 HKLM "$1\policy\$3" 0
    ;$2 should equal whatever comes after the major and minor versions 
    ;(ie, v1.1.4322)
    StrCmp $2 "" noDotNet
    ReadRegStr $4 HKLM $1 "InstallRoot"
    ;Hopefully the install root isn't empty.
    StrCmp $4 "" noDotNet
    ;build the actuall directory path to mscorlib.dll.
    StrCpy $4 "$4$3.$2\mscorlib.dll"
    IfFileExists $4 yesDotNet noDotNet

  noDotNet:
    ;Nope, something went wrong along the way.  Looks like the 
    ;proper .NETFramework isn't installed.  
    MessageBox MB_OK|MB_ICONEXCLAMATION \
"You must have v${DOT_MAJOR}.${DOT_MINOR} or greater of the \
Microsoft .NET framework installed.$\n$\nClick 'Open' in the following file \
dialog to download and run the Microsoft .NET 1.1 Framework Installer. \
Afterwards please just run this installer again."

	ExecShell Open "http://download.microsoft.com/download/a/a/c/aac39226-8825-44ce-90e3-bf8203e74006/dotnetfx.exe" SW_SHOWNORMAL
	Quit

  yesDotNet:
    ;Everything checks out.  Go on with the rest of the installation.
FunctionEnd


