/* au-ids.c --
 * Copyright 2007-08 Red Hat Inc., Durham, North Carolina.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *   Steve Grubb <sgrubb@redhat.com>
 *
 */

#include <stdio.h>
#include <signal.h>
#include <syslog.h>


/* Global Data */
volatile int stop = 0;
volatile int hup = 0;

/*
 * SIGTERM handler
 */
static void term_handler( int sig )
{
        stop = 1;
}

/*
 * SIGHUP handler: re-read config
 */
static void hup_handler( int sig )
{
        hup = 1;
}

static void load_config(void)
{
	hup = 0;
}

int main(int argc, char *argv[])
{
	char tmp[1025];
	char *p = " ";
	struct sigaction sa;

	/* This plugin takes 1 argument to tell you which plugin it is */
	if (argc > 1)
		p = argv[1];

	/* Register sighandlers */
	sa.sa_flags = 0;
	sigemptyset(&sa.sa_mask);
	/* Set handler for the ones we care about */
	sa.sa_handler = term_handler;
	sigaction(SIGTERM, &sa, NULL);
	sa.sa_handler = hup_handler;
	sigaction(SIGHUP, &sa, NULL);

	do {
		/* Load configuration */
		load_config();

		/* Now the event loop */
		while (fgets(tmp, 1024, stdin) && hup==0 && stop==0) {
			;	// FIXME add auparse based loop
		}
	} while (hup && stop == 0);
	return 0;
}

