/*
**
** The C code is generated by ATS/Anairiats
** The compilation time is: 2011-11-10: 12h:35m
**
*/

/* include some .h files */
#ifndef _ATS_HEADER_NONE
#include "ats_config.h"
#include "ats_basics.h"
#include "ats_types.h"
#include "ats_exception.h"
#include "ats_memory.h"
#endif /* _ATS_HEADER_NONE */

/* include some .cats files */
#ifndef _ATS_PRELUDE_NONE
#include "prelude/CATS/basics.cats"
#include "prelude/CATS/bool.cats"
#include "prelude/CATS/byte.cats"
#include "prelude/CATS/char.cats"
#include "prelude/CATS/float.cats"
#include "prelude/CATS/integer.cats"
#include "prelude/CATS/integer_fixed.cats"
#include "prelude/CATS/integer_ptr.cats"
#include "prelude/CATS/lazy.cats"
#include "prelude/CATS/lazy_vt.cats"
#include "prelude/CATS/pointer.cats"
#include "prelude/CATS/printf.cats"
#include "prelude/CATS/reference.cats"
#include "prelude/CATS/sizetype.cats"
#include "prelude/CATS/string.cats"
#include "prelude/CATS/array.cats"
#include "prelude/CATS/list.cats"
#include "prelude/CATS/matrix.cats"
#include "prelude/CATS/option.cats"
#endif /* _ATS_PRELUDE_NONE */
/* prologues from statically loaded files */
/* external codes at top */


ats_void_type atspre_exit_prerrf
  (const ats_int_type n, const ats_ptr_type fmt, ...)
{
  va_list ap ;
  va_start(ap, fmt) ; vfprintf(stderr, (char*)fmt, ap) ; va_end(ap) ;
  exit(n) ;
}

ats_void_type atspre_assert_prerrf
  (ats_bool_type assertion, ats_ptr_type fmt, ...) {
  int n ;
  va_list ap ;

  if (!assertion) {
    va_start(ap, fmt) ;
    n = vfprintf(stderr, (char*)fmt, ap) ;
    va_end(ap) ;
    if (n < 0) {
      ats_exit_errmsg (
        n, "[atspre_assert_prerrf: prerrf] failed\n"
      ) ;
    } else {
      ats_exit_errmsg (
        1, "[atspre_assert_prerrf: assert] failed\n"
      ) ;
    }
  }
  return ;
} /* end of [atspre_assert_prerrf] */



// functions for sprintf

static
ats_ptr_type __tostringf_size
  (const ats_int_type guess, const ats_ptr_type fmt, va_list ap0)
{
  int n, sz ; char *res ; va_list ap ;

  sz = guess ;
  res = ATS_MALLOC (sz) ;
  while (1) {
    va_copy (ap, ap0) ; // [vsnprintf] may modify [ap]
    n = vsnprintf (res, sz, (char*)fmt, ap) ;
    if (n >= 0) {
      if (n < sz) return res ;
      sz = n+1 ; /* exact size */
      ATS_FREE (res) ; res = ATS_MALLOC (sz) ;
      continue ;
    } // end of [if]
    return ((ats_ptr_type)0) ;
  }
} // end of [__tostringf_size]

ats_ptr_type atspre_tostringf_size
  (const ats_int_type guess, const ats_ptr_type fmt, ...)
{
  char *res ;
  va_list ap ;

  va_start(ap, fmt);
  res = (char*)__tostringf_size (guess, fmt, ap);
  va_end(ap);
  if (!res) {
    ats_exit_errmsg (1, "Exit: [ats_tostringf_size] failed.\n") ;
  }
  return res ;
}

#define __TOSTRINGF_GUESS 16
ats_ptr_type
atspre_tostringf (ats_ptr_type fmt, ...) {
  char *res ;
  va_list ap ;

  va_start(ap, fmt);
  res = (char*)__tostringf_size (__TOSTRINGF_GUESS, fmt, ap);
  va_end(ap);
  if (!res) {
    ats_exit_errmsg (1, "Exit: [ats_tostringf] failed.\n") ;
  }
  return res ;
} /* end of [atspre_tostringf] */


/* type definitions */
/* external typedefs */
/* external dynamic constructor declarations */
/* external dynamic constant declarations */
/* external dynamic terminating constant declarations */
#ifdef _ATS_PROOFCHECK
/* empty */
#endif /* _ATS_PROOFCHECK */

/* sum constructor declarations */
/* exn constructor declarations */
/* global dynamic (non-functional) constant declarations */
/* internal function declarations */
/* partial value template declarations */
/* static temporary variable declarations */
/* external value variable declarations */

/* function implementations */

/* static load function */

ats_void_type
ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__staload () {
static int ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__staload_flag = 0 ;
if (ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__staload_flag) return ;
ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__staload_flag = 1 ;

return ;
} /* staload function */

/* dynamic load function */

// dynload flag declaration
// extern ats_int_type ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__dynload_flag ;

ats_void_type
ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__dynload () {
// ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__dynload_flag = 1 ;
ATS_2d0_2e2_2e6_2src_2prelude_dats_printf_2edats__staload () ;

#ifdef _ATS_PROOFCHECK
#endif /* _ATS_PROOFCHECK */

/* marking static variables for GC */

/* marking external values for GC */

/* code for dynamic loading */
return ;
} /* end of [dynload function] */

/* external codes at mid */
/* external codes at bot */

/* ****** ****** */

/* end of [/home/hwxi/Research/Anairiats/bootstrap1/prelude_dats_printf_dats.c] */
