#include "recognizer.h"
#include "charbuffer.h"


// try to recognize the current token in the character buffer
// returns 1 on success, 0 on eof, -1 on unknown token

int Recognizer::recognize (int &token, int &len)
 {
   int  NextState;
   int  Expression;
   char Character;
   char CharClass;
   int  NextStatePos;
   int  EndOfFile;
   int  State;

   State = _start;

   do
    { 
      if ((EndOfFile = _char_buffer->NextCharacter (Character)) == -1)
       { 
	 if (_char_buffer->empty ())
	    return 0;
         else
	    NextState = -1;
       }
      else
       { 
	 CharClass = _map[Character];
	 if (CharClass == -1)
	    return -1;

	 NextStatePos = _state[State].Start + CharClass;
	 if (NextStatePos < 0 || NextStatePos >= _tab_size)
	    NextState = -1;
	 else
	    if (_control[NextStatePos] != State)
	       NextState = -1;
	    else
	       State = NextState = _next[NextStatePos];
       }
    } while (NextState != -1);

   if (EndOfFile != -1)
      _char_buffer->PreviousCharacter (Character);

   if (_state[State].Type == 0)
      return -1;

   token = _state[State].Expression;
   len   = _char_buffer->len ();

   return 1;
 }


