/* $Id: Script.cpp,v 1.15 2002/11/16 16:40:02 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef WIN32
 #include <windows.h>
#endif

#include <config.h>

#include <Ark/ArkFactory.h>
#include <Ark/ArkSystem.h>
#include <Ark/ArkDataClass.h>
#include <Ark/ArkConfig.h>

#include <Engine/Script.h>
#include <Engine/Engine.h>

namespace Ark
{    

// ===========================================================================
// GENERIC PART
// ===========================================================================

   Script::Script ()
   {
      m_ClassList = new ClassList();
      m_CbClassList = new ClassList();
   }

   Script::~Script ()
   {
      delete m_ClassList;
      delete m_CbClassList;
   }

   static void 
   LoadClassList (const String &name, 
		  Config &cfg,
		  ClassList *classlist)
   {

      String datadef = cfg.GetStr (name + "::ClassDef", String());
      if (!datadef.empty())
	 classlist->Load (datadef);
   
      String templates = cfg.GetStr (name + "::Templates", String());
      if (!templates.empty())
	 classlist->LoadTemplates (templates);
   
   }

   bool
   Script::LoadLibrary (const String &filename)
   {
      Config cfg;
      cfg.Load (filename);

      LoadClassList ("Entity", cfg, m_ClassList);
      LoadClassList ("Callback", cfg, m_ClassList);

      String script = cfg.GetStr ("Script", String());
      if (! script.empty() )
	 return LoadScript (script);

      return true;
   }

   void
   Script::SetEntries (Entity *entity,
		       const String &buffername, 
		       Stream &buffer,
		       bool callbacks)
   {
   }

//////////////////////////////////////////////////////////////////
   VersionInfo Script_VERSION = {"Script", 0,1,0};
   ScriptFactory::ScriptFactory() : Factory(Script_VERSION)
   {}

   Script *
   ScriptFactory::CreateScript(const Ark::String implname,
			      Ark::FactoryList *factlist)
   {
      if (factlist == 0)
	 factlist = Ark::Sys()->Factories();
      
      Ark::ScriptFactory *scriptfac;
      if (!factlist->GetFactory(implname, &scriptfac, Script_VERSION))
	 Ark::Sys()->Fatal("Cannot create a script factory !");
      
      return scriptfac->NewScript ();
   }

}
