#!/usr/bin/python3

from distutils.core import setup
import glob

config = {}
with open("release.conf", "r") as fd:
    for line in fd:
        fields = line.split("=", 1)
        if len(fields) < 2:
            continue

        config[fields[0]] = fields[1].strip('"\n')

setup(name=config['MODULE_NAME'],
      version=config['VERSION'],
      description=config['DESCRIPTION'],
      author=config['AUTHOR'],
      author_email=config['AUTHOR_EMAIL'],
      packages=['arkose'],
      package_dir={'arkose': 'arkose'},
      data_files=[('/usr/lib/nautilus/extensions-2.0/python/',
                   ['nautilus/arkose-nautilus.py']),
                  ('/usr/share/man/man1',
                   ['cli/arkose.1', 'gui/arkose-gui.1']),
                  ('/usr/share/applications',
                   ['gui/arkose-gui.desktop']),
                  ('/usr/share/arkose/gui',
                   ['gui/arkose-gui.xml', 'wrapper/arkose-wrapper-gui.xml']),
                  ('/usr/share/arkose/dbus-profiles',
                   glob.glob("dbus-proxy/profiles/*")),
                  ('/usr/share/arkose/wrapper-profiles',
                   glob.glob("wrapper/profiles/*")),
                  ('/usr/bin',
                   ['cli/arkose', 'gui/arkose-gui',
                    'wrapper/arkose-wrapper-gui'])])
