/*
 *
 *  (c) COPYRIGHT INRIA, 1996-2005.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 *
 * Author: I. Vatton (INRIA)
 *
 */
#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "appstruct.h"
#include "menuaction.h"
#include "registry.h"
#include "fileaccess.h"

#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "appevents_tv.h"

extern PtrEventsSet pAppli;
extern PtrSSchema   pSSchema;
extern char        *RegisteredAppEvents[];
extern PtrAppName   SchemasUsed;
extern PtrAppName   MenusUsed;
extern PtrAppName   ItemsUsed;
extern PtrAppName   ActionsUsed;
extern PtrAppMenu   MainWindowMenus;
extern PtrAppMenu   DocWindowMenus;
extern PtrAppDocType DocTypeMenus;

static FILE        *AppFile;

#include "platform_f.h"
#include "memory_f.h"


/*----------------------------------------------------------------------
   WriteIncludes writes include files 	     		        
  ----------------------------------------------------------------------*/
static void         WriteIncludes (char *fname, FILE * file)
{
   PtrAppName          menuAction;

   fprintf (file, "/* File generated by app - do not edit! */\n");
   fprintf (file, "/* #################################### */\n");
   fprintf (file, "/* Included files */\n");
   fprintf (file, "#include \"string.h\"\n");
   fprintf (file, "#include \"thot_gui.h\"\n");
   fprintf (file, "#include \"thot_sys.h\"\n");
   fprintf (file, "#include \"application.h\"\n");
   fprintf (file, "#include \"appstruct.h\"\n");
   fprintf (file, "#include \"interface.h\"\n");
   fprintf (file, "#include \"%s.h\"\n", fname);
   /* regarde s'il y a des actions de menus non standard */
   menuAction = ActionsUsed;
   while (menuAction != NULL)
     {
      if (!menuAction->AppStandardName)
	{
	   fprintf (file, "#include \"document.h\"\n");
	   fprintf (file, "#include \"view.h\"\n");
	   menuAction = NULL;
	}
      else
	 menuAction = menuAction->AppNextName;
     }






}


/*----------------------------------------------------------------------
   WriteAnEvent generates event/action a specific event.           
  ----------------------------------------------------------------------*/
static void         WriteAnEvent (char *eventName, PtrActionEvent pactevent)
{
   if (pactevent == NULL)
      return;

   WriteAnEvent (eventName, pactevent->AEvNext);
   fprintf (AppFile, "  TteAddActionEvent (appliActions, %d, %s, %d, \"%s\");\n",
	    pactevent->AEvType,
	    eventName,
	    pactevent->AEvPre,
	    pactevent->AEvAction->ActName);
}


/*----------------------------------------------------------------------
   WriteEventsList generates list of event/action.			
  ----------------------------------------------------------------------*/
static void WriteEventsList (PtrEventsSet pAppli)
{
   int                 event;
   char                name[50];

   fprintf (AppFile, "   /* Generate event/action entries */\n");
   strcpy (name, "Tte");
   for (event = 0; event <= TteExit; event++)
     {
	strcpy (&name[3], RegisteredAppEvents[event]);
	WriteAnEvent (name, pAppli->EvSList[event]);
     }
   fprintf (AppFile, "\n");
}

/*----------------------------------------------------------------------
   PrintSubMenu                                                    
  ----------------------------------------------------------------------*/
static void PrintSubMenu (PtrAppMenuItem item, char *menuName)
{
   PtrAppMenuItem      subitem;
   int                 itemsNumber;

   /* calcule le nombre d'entrees dans le sous-menu */
   subitem = item->AppSubMenu;
   itemsNumber = 0;
   while (subitem != NULL)
     {
	itemsNumber++;
	subitem = subitem->AppNextItem;
     }
   fprintf (AppFile, "  TteAddSubMenu (");
   fprintf (AppFile, "%s, %s, %d);\n", menuName, item->AppItemName, itemsNumber);

   /* traite la liste des items du sous-menu */
   subitem = item->AppSubMenu;
   while (subitem != NULL)
     {
	fprintf (AppFile, "    TteAddMenuItem (");
	fprintf (AppFile, "%s, %s", menuName, item->AppItemName);

	if (subitem->AppItemName == NULL)
	   fprintf (AppFile, ", 0");
	else
	   fprintf (AppFile, ", %s", subitem->AppItemName);

	if (subitem->AppItemActionName == NULL)
	   fprintf (AppFile, ", NULL, '%c'", (char)subitem->AppItemType);
	else
	   fprintf (AppFile, ", \"%s\", '%c'", subitem->AppItemActionName, (char)subitem->AppItemType);
	
	/* on traite l'icon si elle existe */
	if (subitem->AppItemIconName == NULL)
	  fprintf (AppFile, ", NULL);\n");
	else
	  fprintf (AppFile, ", \"%s\");\n", subitem->AppItemIconName);
	
	/* item suivant */
	subitem = subitem->AppNextItem;
     }
}


/*----------------------------------------------------------------------
   PrintMenus                                                      
  ----------------------------------------------------------------------*/
static void         PrintMenus (PtrAppMenu firstMenu)
{
  PtrAppMenu          menu;
  PtrAppMenuItem      item;
  int                 itemsNumber;
  
  if (firstMenu == NULL)
    {
      fprintf (AppFile, "  TteZeroMenu();");
    }
  else
    {
      menu = firstMenu;
      while (menu != NULL)
	{
	  /* calcule le nombre d'entrees dans le menu */
	  itemsNumber = 0;
	  item = menu->AppMenuItems;
	  while (item != NULL)
	    {
	      itemsNumber++;
	      item = item->AppNextItem;
	    }
	  
	  /*fprintf(AppFile, "\n"); */
	  fprintf (AppFile, "  TteAddMenu (");
	  fprintf (AppFile, "%d, %s, %d", menu->AppMenuView, menu->AppMenuName, itemsNumber);
	  /* Declare les menus dynamiques */
	  if (!strcmp (menu->AppMenuName, "Attributes_"))
	    {
	      fprintf (AppFile, ", \"MenuAttribute\");\n");
	      fprintf (AppFile, "  AttributeMenuLoadResources();\n");
	    }
	  else if (!strcmp (menu->AppMenuName, "Selection_"))
	    {
	      fprintf (AppFile, ", \"MenuSelection\");\n");
	      fprintf (AppFile, "  SelectionMenuLoadResources();\n");
	    }
	  else if (!strcmp (menu->AppMenuName, "Help_"))
	    fprintf (AppFile, ", \"MenuHelp\");\n");
	  else if (!strcmp (menu->AppMenuName, "Context_"))
	    fprintf (AppFile, ", \"MenuContext\");\n");
	  else
	    fprintf (AppFile, ", \"\");\n");
	  
	  /* traite la liste des items du menu */
	  item = menu->AppMenuItems;
	  while (item != NULL)
	    {
	      if (item->AppSubMenu != NULL)
		/* traitement du sous-menu */
		PrintSubMenu (item, menu->AppMenuName);
	      else
		{
		  fprintf (AppFile, "    TteAddMenuItem (");
		  fprintf (AppFile, "%s, -1", menu->AppMenuName);
		  
		  if (item->AppItemName == NULL)
		    fprintf (AppFile, ", 0");
		  else
		    fprintf (AppFile, ", %s", item->AppItemName);

		  if (item->AppItemActionName == NULL)
		    fprintf (AppFile, ", NULL, '%c'", (char)item->AppItemType);
		  else
		    fprintf (AppFile, ", \"%s\", '%c'", item->AppItemActionName, (char)item->AppItemType);

		  /* on traite l'icon si elle existe */
		  if (item->AppItemIconName == NULL)
		    fprintf (AppFile, ", NULL);\n");
		  else
		    fprintf (AppFile, ", \"%s\");\n", item->AppItemIconName);
		}
	      /* item suivant */
	      item = item->AppNextItem;
	    }
	  menu = menu->AppNextMenu;
	}
    }
}


/*----------------------------------------------------------------------
   WriteAppliInit                                                  
  ----------------------------------------------------------------------*/
static void     WriteAppliInit (char *fname, PtrEventsSet pAppli)
{
   if (strcmp (fname, "EDITOR") == 0)
     {
	fprintf (AppFile, "#include \"message.h\"\n");
	fprintf (AppFile, "#ifdef _WINGUI\n#include \"wininclude.h\"\n#endif\n\n");
	fprintf (AppFile, "int    appArgc;\nchar** appArgv;\n");
     }
   fprintf (AppFile, "\n/*----------------------------------------------------------------------\n -----------------------------------------------------------------------*/\n");
   fprintf (AppFile, "void %sApplicationInitialise ()\n", fname);
   fprintf (AppFile, "{\n PtrEventsSet appliActions;\n\n");
   fprintf (AppFile, "  /* Create the new application context*/\n");
   fprintf (AppFile, "  appliActions = TteNewEventsSet (%d, \"%s\");\n", pAppli->EvSStructId, pAppli->EvSName);

   WriteEventsList (pAppli);
   fprintf (AppFile, "}\n\n");
}


/*----------------------------------------------------------------------
   WriteActionList
  ----------------------------------------------------------------------*/
static void         WriteActionList (char *fname)
{
  PtrAction           action;
  FILE               *actionFile;
  PtrAppDocType       menusDoc;
  PtrAppName          SchUsed;
  PtrAppName          menuAction;
  char                actionFName[MAX_TXT_LEN];
  int                 nbActions;
  ThotBool            editingResource;
  ThotBool            structSelectResource;
  ThotBool	      documentWriteMode;

  strcpy (actionFName, fname);
  strcat (actionFName, "actions.proto");
  /* Opens the skeleton action-file */
  actionFile = fopen (actionFName, "w");
  /* Writes the standard headers to the action-file */
  WriteIncludes (fname, actionFile);

  fprintf (AppFile, "/*########## Init Appplication action-list #################*/\n");
  /* Handle the command USES */
  if (SchemasUsed != NULL)
    {
      SchUsed = SchemasUsed;
      while (SchUsed != NULL)
	{
	  fprintf (AppFile, "extern void %sLoadResources ();\n", SchUsed->AppNameValue);
	  SchUsed = SchUsed->AppNextName;
	}
    }

  action = ActionList;
  while (action != NULL)
    {
      fprintf (actionFile, "\n/*----------------------------------------------------------------------\n -----------------------------------------------------------------------*/\n");
      fprintf (AppFile, "extern ");
      if (strcmp (action->ActName, "NoAction"))
	{
	  /* Output the data to the actions-file */
	  if (action->ActPre)
	    {
	      fprintf (AppFile, "ThotBool %s (", action->ActName);
	      fprintf (actionFile, "ThotBool %s (", action->ActName);
	    }
	  else
	    {
	      fprintf (AppFile, "void %s (", action->ActName);
	      fprintf (actionFile, "void %s (", action->ActName);
	    }
	  
	  switch (action->ActEvent)
	    {
	    case TteAttrMenu:
	    case TteAttrCreate:
	    case TteAttrModify:
	    case TteAttrRead:
	    case TteAttrSave:
	    case TteAttrExport:
	    case TteAttrDelete:
	      fprintf (AppFile, "NotifyAttribute *event);\n");
	      fprintf (actionFile, "NotifyAttribute *event)\n");
	      break;
	    case TteElemMenu:
	    case TteElemNew:
	    case TteElemRead:
	    case TteElemSave:
	    case TteElemExport:
	    case TteElemDelete:
	    case TteElemSelect:
	    case TteElemExtendSelect:
	    case TteElemClick:
	    case TteElemLClick:
	    case TteElemMClick:
	    case TteElemRClick:
	    case TteElemActivate:
	    case TteElemInclude:
	    case TteElemCopy:
	    case TteElemChange:
	    case TteElemMove:
	    case TteElemMouseOver:
	    case TteElemMouseOut:
	      fprintf (AppFile, "NotifyElement *event);\n");
	      fprintf (actionFile, "NotifyElement *event)\n");
	      break;
	    case TteElemSetReference:
	    case TteElemFetchInclude:
	    case TteElemTextModify:
	    case TteElemReturn:
	    case TteElemTab:
	      fprintf (AppFile, "NotifyOnTarget *event);\n");
	      fprintf (actionFile, "NotifyOnTarget *event)\n");
	      break;
	    case TteElemPaste:
	      if (action->ActPre)
		{
		  fprintf (AppFile, "NotifyOnValue *event);\n");
		  fprintf (actionFile, "NotifyOnValue *event)\n");
		}
	      else
		{
		  fprintf (AppFile, "NotifyElement *event);\n");
		  fprintf (actionFile, "NotifyElement *event)\n");
		}
	      break;
	    case TteElemGraphModify:
	      fprintf (AppFile, "NotifyOnValue *event);\n");
	      fprintf (actionFile, "NotifyOnValue *event)\n");
	      break;
	    case TtePRuleCreate:
	    case TtePRuleModify:
	    case TtePRuleDelete:
	      fprintf (AppFile, "NotifyPresentation *event);\n");
	      fprintf (actionFile, "NotifyPresentation *event)\n");
	      break;
	    case TteDocOpen:
	    case TteDocTmpOpen:
	    case TteDocCreate:
	    case TteDocClose:
	    case TteDocSave:
	    case TteDocExport:
	    case TteViewOpen:
	    case TteViewClose:
	      fprintf (AppFile, "NotifyDialog *event);\n");
	      fprintf (actionFile, "NotifyDialog *event)\n");
	      break;
	    case TteViewResize:
	    case TteViewScroll:
	      fprintf (AppFile, "NotifyWindow *event);\n");
	      fprintf (actionFile, "NotifyWindow *event)\n");
	      break;
	    case TteInit:
	    case TteExit:
	      fprintf (AppFile, "NotifyEvent *event);\n");
	      fprintf (actionFile, "NotifyEvent *event)\n");
	      break;
	    case TteDocNatPresent:
	      fprintf (AppFile, "NotifyNaturePresent *event);\n");
	      fprintf (actionFile, "NotifyNaturePresent *event)\n");
	      break;
	    default:
	      break;
	    }
	  fprintf (actionFile, "{\n");
	  fprintf (actionFile, "  /* code to be written */\n");
	  if (action->ActPre)
	    fprintf (actionFile, "  return FALSE; /* let Thot perform normal operation */\n");
	  fprintf (actionFile, "}\n\n");
	}
      action = action->ActNext;
    }
  
  fprintf (AppFile, "void %sActionListInit ()\n", fname);
  fprintf (AppFile, "{\n");
  
  action = ActionList;
  while (action != NULL)
    {
      fprintf (AppFile, "  TteAddAction (\"%s\", (Proc)%s);\n",
	       action->ActName,
	       action->ActName);
      action = action->ActNext;
    }
  
  fprintf (AppFile, "}\n\n");
  
  if (strcmp (fname, "EDITOR") == 0)
    {
      /* c'est bien EDITOR.A qu'on compile, on ajoute le main avec les
	 initialisation qu'il faut */
      structSelectResource = FALSE;	/* resource unspecified */
      documentWriteMode = FALSE;      /* use default values */
      fprintf (AppFile, "\nvoid TteLoadApplications ()\n");
      fprintf (AppFile, "{\n");
      fprintf (AppFile, "  %sActionListInit ();\n", fname);
      fprintf (AppFile, "  %sApplicationInitialise ();\n", fname);
      /* Traite la commande USES */
      if (SchemasUsed != NULL)
	{
	  SchUsed = SchemasUsed;
	  while (SchUsed != NULL)
	    {
	      if (!strcmp (SchUsed->AppNameValue, "Xml")
		  || !strcmp (SchUsed->AppNameValue, "Pivot"))
		/* an explicit choice between struct and no struct */
		documentWriteMode = TRUE;
	      if (!strcmp (SchUsed->AppNameValue, "StructSelect")
		  || !strcmp (SchUsed->AppNameValue, "NoStructSelect"))
		/* an explicit choice between struct and no struct */
		structSelectResource = TRUE;
	      fprintf (AppFile, "  %sLoadResources ();\n", SchUsed->AppNameValue);
	      SchUsed = SchUsed->AppNextName;
	    }
	}
      /* set default actions */
      if (!documentWriteMode)
	fprintf (AppFile, "  PivotLoadResources ();\n");
      if (!structSelectResource)
	fprintf (AppFile, "  NoStructSelectLoadResources ();\n");
      fprintf (AppFile, "}\n\n");
      
      /* compte les elements de la liste ActionsUsed */
      menuAction = ActionsUsed;
      nbActions = 0;
      while (menuAction != NULL)
	{
	  nbActions++;
	  if (!menuAction->AppStandardName)
            /* declare les nouvelles fonctions non standard des menus */
            fprintf (AppFile, "extern void %s (Document document, View view);\n", menuAction->AppNameValue);
	  menuAction = menuAction->AppNextName;
	}
      fprintf (AppFile, "/*################### Main program #########################*/\n");
      fprintf (AppFile, "#if defined(_WINGUI) || defined(_GTK) || defined(_WX)\n");
      fprintf (AppFile, "#if defined(_WINGUI) || defined(_GTK)\n");
      fprintf (AppFile, "int main (int argc, char** argv)\n");
      fprintf (AppFile, "#endif /* #if defined(_WINGUI) || defined(_GTK) */\n");
      fprintf (AppFile, "#if defined(_WX)\n");
      fprintf (AppFile, "int amaya_main (int argc, char** argv)\n");
      fprintf (AppFile, "#endif /* defined(_WX) */\n");
      fprintf (AppFile, "#else  /* #if defined(_WINGUI) || defined(_GTK) */\n");
      fprintf (AppFile, "int main (int argc, char **argv)\n");
      fprintf (AppFile, "#endif /* #if defined(_WINGUI) || defined(_GTK) */\n");
      fprintf (AppFile, "{\n");
      
      fprintf (AppFile, "  int lg; /* identify dialogue messages */\n");
      fprintf (AppFile, "  char appName[MAX_PATH]; /* name of the application */\n");
      fprintf (AppFile, "  char workName[MAX_PATH]; /* path of the application */\n");
      
      fprintf (AppFile, "#ifndef _WX /* this init is done earlier on WX, see AmayaApp::OnInit */\n");
      fprintf (AppFile, "  /* initialize the Registry */\n");
      fprintf (AppFile, "  TtaInitializeAppRegistry (argv[0]);\n");
      fprintf (AppFile, "#endif /* _WX */\n");

      fprintf (AppFile, "  /* save argc and argv */\n");
      fprintf (AppFile, "  appArgc = argc;\n  appArgv = argv;\n");
      fprintf (AppFile, "  /* extract the name of the application */\n");
      fprintf (AppFile, "  if (strstr (argv[0], \"amaya\"))\n");
      fprintf (AppFile, "    {\n");
      fprintf (AppFile, "      strcpy (appName, \"amaya\");\n");
      fprintf (AppFile, "      strcpy (workName, \"amaya\");\n");
      fprintf (AppFile, "    }\n");
      fprintf (AppFile, "  else\n");
      fprintf (AppFile, "    TtaExtractName (argv[0], workName, appName);\n");


      fprintf (AppFile, "  /* application name is limited to 19 characters */\n");
      fprintf (AppFile, "  lg = strlen (appName);\n");
      fprintf (AppFile, "  if (lg > 19)\n");
      fprintf (AppFile, "    appName[19] = EOS;\n");
      fprintf (AppFile, "  TtaInitialize (appName);\n");
      fprintf (AppFile, "\n  TteInitMenus (appName, %d);\n", nbActions);
      
      editingResource = FALSE;	/* no editing Resource loaded by default */
      menuAction = ActionsUsed;
      while (menuAction != NULL)
	{
	  if (menuAction->AppFunction)
	    fprintf (AppFile, "  TteAddMenuAction(\"%s\", (Proc)%s, TRUE);\n", menuAction->AppNameValue, menuAction->AppNameValue);
	  else
	    fprintf (AppFile, "  TteAddMenuAction(\"%s\", (Proc)%s, FALSE);\n", menuAction->AppNameValue, menuAction->AppNameValue);
	  
	  if (!menuAction->AppStandardName)
	    /* ecrit les fonctions non standard des menus dans XXXaction.c */
	    {
	      fprintf (actionFile, "\n/*----------------------------------------------------------------------\n -----------------------------------------------------------------------*/\n");
	      fprintf (actionFile, "void %s (Document document, View view)\n",
		       menuAction->AppNameValue);
	      fprintf (actionFile, "  /* This function has to be written */\n");
	      fprintf (actionFile, "}\n\n");
	    }
	  else
	    {
	      /* Is it an editing standard function ? */
	      if (!strcmp (menuAction->AppNameValue, "TtcInsert")
		  || !strcmp (menuAction->AppNameValue, "TtcPasteFromClipboard")
		  || !strcmp (menuAction->AppNameValue, "TtcPaste")
		  || !strcmp (menuAction->AppNameValue, "TtcCutSelection")
		  || !strcmp (menuAction->AppNameValue, "TtcDeleteSelection")
		  || !strcmp (menuAction->AppNameValue, "TtcInsertChar")
		  || !strcmp (menuAction->AppNameValue, "TtcDeletePreviousChar")
		  || !strcmp (menuAction->AppNameValue, "TtcCopySelection")
		  || !strcmp (menuAction->AppNameValue, "TtcInclude"))
		editingResource = TRUE;
	    }
	  menuAction = menuAction->AppNextName;
	}

      fprintf (AppFile, "\n");
      PrintMenus (MainWindowMenus);
      fprintf (AppFile, "\n");
      PrintMenus (DocWindowMenus);
      menusDoc = DocTypeMenus;
      while (menusDoc != NULL)
	{
	  fprintf (AppFile, "\n");
	  PrintMenus (menusDoc->AppDocTypeMenus);
	  menusDoc = menusDoc->AppNextDocType;
	}

      fprintf (AppFile, "  /* load appName+\"dialogue\" message file */\n");
      fprintf (AppFile, "  strcpy (workName, appName);\n");
      fprintf (AppFile, "  strcat(workName, \"dialogue\");\n");
      fprintf (AppFile, "  TtaGetMessageTable (workName, MAX_EDITOR_LABEL);\n");
      /* if necessary load editing Resources */
      if (editingResource)
	fprintf (AppFile, "  EditingLoadResources ();\n");

      fprintf (AppFile, "  TteOpenMainWindow (appName);\n");

      fprintf (AppFile, "  TtaMainLoop ();\n");
      fprintf (AppFile, "#if !defined(_WX)\n");
      fprintf (AppFile, "  exit(0);\n");
      fprintf (AppFile, "#endif /* _WX */\n");
      fprintf (AppFile, "  return 0;\n\n"); 
      fprintf (AppFile, "}\n\n"); 
    }

  fprintf (AppFile, "void %sLoadResources ()\n", fname);
  fprintf (AppFile, "{\n");
  fprintf (AppFile, "  %sActionListInit ();\n", fname);
  fprintf (AppFile, "  %sApplicationInitialise ();\n}\n\n", fname);
  fclose (actionFile);
}


/*----------------------------------------------------------------------
   WriteIncludeFile                                                
  ----------------------------------------------------------------------*/
static void         WriteIncludeFile (FILE * dotHFile, FILE * dialogueFile)
{
   int                 i, num;
   PtrAppName          name;

   fprintf (dotHFile, "/* File generated by app - do not edit! */\n");
   fprintf (dotHFile, "/* #################################### */\n");
   fprintf (dotHFile, "/* Basic types */\n");
   for (i = 0; i < pSSchema->SsNRules; i++)
       fprintf (dotHFile, "#define %s  %d\n", pSSchema->SsRule->SrElem[i]->SrName, i + 1);

   /* liste tous les noms de menus et d'items reellement utilises */
   num = 0;
   fprintf (dotHFile, "\n/* Beginning of labels */\n");
   fprintf (dotHFile, "\n/* Pull-down menus */\n");
   name = MenusUsed;
   while (name != NULL)
     {
	fprintf (dotHFile, "#define %s  %d\n", name->AppNameValue, num);
	fprintf (dialogueFile, "%d  %s\n", num, name->AppNameValue);
	name = name->AppNextName;
	num++;
     }

   fprintf (dotHFile, "\n/* Pull-down menu items */\n");
   name = ItemsUsed;
   while (name != NULL)
     {
	if (name->AppNameValue != NULL)
	  {
	     fprintf (dotHFile, "#define %s  %d\n", name->AppNameValue, num);
	     fprintf (dialogueFile, "%d  %s\n", num, name->AppNameValue);
	     num++;
	  }
	name = name->AppNextName;
     }
   fprintf (dotHFile, "\n#define MAX_EDITOR_LABEL       %d\n", num + 1);
}


/*----------------------------------------------------------------------
   GenerateApplication generates the application prototype.	
  ----------------------------------------------------------------------*/
void                GenerateApplication (char *fname, PtrEventsSet pAppli)
{
   int                 i;
   char               *fileSuffix;
   FILE               *dotHFile;
   FILE               *infoFILE;

   i = 0;
   fileSuffix = TtaStrdup (fname);
   /* add the suffix APP.c */
   while (fname[i] != ' ' && fname[i] != EOS)
      i++;
   fname[i] = EOS;
   strcpy (&fname[i], "APP.c");

   /* create the file */
   AppFile = fopen (fname, "w");
   WriteIncludes (fileSuffix, AppFile);
   WriteAppliInit (fileSuffix, pAppli);
   WriteActionList (fileSuffix);
   fclose (AppFile);

   /* create files EDITOR.h and EDITORdialogue */
   if (!strcmp ("EDITOR", fileSuffix))
     {
	dotHFile = fopen ("EDITOR.h", "w");
	infoFILE = fopen ("EDITORdialogue", "w");
	WriteIncludeFile (dotHFile, infoFILE);
	fclose (infoFILE);
	fclose (dotHFile);
     }
   TtaFreeMemory (fileSuffix);
}
