# ---------------------------------------------------------------------------
# - MTH0104.als                                                             -
# - afnix:mth module algebra test unit                                      -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2011 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   real matrix determinant test unit
# @author amaury darsch

# get the module
interp:library "afnix-mth"

# create a simple 2x2 real matrix
const m (afnix:mth:Rmatrix 2)
m:set 0 0 1.0  
m:set 0 1 2.0  
m:set 1 0 3.0  
m:set 1 1 4.0

# check the determinant
assert -2.0 (afnix:mth:det m)
unref m

# create a simple 3x3 real matrix
const m (afnix:mth:Rmatrix 3)
m:set 0 0 1.0  
m:set 1 1 1.0  
m:set 2 2 1.0  

# check the determinant
assert 1.0 (afnix:mth:det m)
unref m

# create a simple 3x3 real matrix
const m (afnix:mth:Rmatrix 3)
m:set 0 0 1.0  
m:set 0 1 2.0  
m:set 0 2 3.0
m:set 1 0 4.0 
m:set 1 1 5.0  
m:set 1 2 6.0
m:set 2 0 7.0  
m:set 2 1 8.0  
m:set 2 2 9.0

# check the determinant
assert 0.0 (afnix:mth:det m)
unref m

# create a simple 3x3 real matrix
const m (afnix:mth:Rmatrix 3)
m:set 0 0  3.0  
m:set 0 1  1.0  
m:set 0 2  8.0
m:set 1 0  2.0  
m:set 1 1 -5.0  
m:set 1 2  4.0
m:set 2 0 -1.0  
m:set 2 1  6.0  
m:set 2 2 -2.0

# check the determinant
assert 14.0 (afnix:mth:det m)
unref m

# create a simple 4x4 real matrix
const m (afnix:mth:Rmatrix 4)
m:set 0 0  3.0  
m:set 0 1  2.0  
m:set 0 2 -1.0
m:set 0 3  4.0
m:set 1 0  2.0  
m:set 1 1  1.0  
m:set 1 2  5.0
m:set 1 3  7.0
m:set 2 0  0.0  
m:set 2 1  5.0  
m:set 2 2  2.0
m:set 2 3 -6.0
m:set 3 0 -1.0  
m:set 3 1  2.0  
m:set 3 2  1.0
m:set 3 3  0.0

# get the cofactor matrices
trans    m0  (m:get-cofactor 0 0)
assert  1.0 (m0:get 0 0)
assert  5.0 (m0:get 0 1)
assert  7.0 (m0:get 0 2)
assert  5.0 (m0:get 1 0)
assert  2.0 (m0:get 1 1)
assert -6.0 (m0:get 1 2)
assert  2.0 (m0:get 2 0)
assert  1.0 (m0:get 2 1)
assert  0.0 (m0:get 2 2)

trans    m1 (m:get-cofactor 0 1)
assert  2.0 (m1:get 0 0)
assert  5.0 (m1:get 0 1)
assert  7.0 (m1:get 0 2)
assert  0.0 (m1:get 1 0)
assert  2.0 (m1:get 1 1)
assert -6.0 (m1:get 1 2)
assert -1.0 (m1:get 2 0)
assert  1.0 (m1:get 2 1)
assert  0.0 (m1:get 2 2)

trans    m2 (m:get-cofactor 0 2)
assert  2.0 (m2:get 0 0)
assert  1.0 (m2:get 0 1)
assert  7.0 (m2:get 0 2)
assert  0.0 (m2:get 1 0)
assert  5.0 (m2:get 1 1)
assert -6.0 (m2:get 1 2)
assert -1.0 (m2:get 2 0)
assert  2.0 (m2:get 2 1)
assert  0.0 (m2:get 2 2)

trans    m3 (m:get-cofactor 0 3)
assert  2.0 (m3:get 0 0)
assert  1.0 (m3:get 0 1)
assert  5.0 (m3:get 0 2)
assert  0.0 (m3:get 1 0)
assert  5.0 (m3:get 1 1)
assert  2.0 (m3:get 1 2)
assert -1.0 (m3:get 2 0)
assert  2.0 (m3:get 2 1)
assert  1.0 (m3:get 2 2)

trans    d0 (afnix:mth:det m0)
trans    d1 (afnix:mth:det m1)
trans    d2 (afnix:mth:det m2)
trans    d3 (afnix:mth:det m3)

trans    dx (+ (+ (+ (* 3.0 d0) (* -2.0 d1)) (* -1.0 d2)) (* -4.0 d3))
const    dm (afnix:mth:det m)
assert   dx dm

trans    m0 (m:get-cofactor 3 0)
trans    m1 (m:get-cofactor 3 1)
trans    m2 (m:get-cofactor 3 2)
trans    d0 (afnix:mth:det m0)
trans    d1 (afnix:mth:det m1)
trans    d2 (afnix:mth:det m2)

trans    dx (+ (+ (* 1.0 d0) (* 2.0 d1)) (* -1.0 d2))
assert   dx dm
unref    m
