/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.acgvision.agent.action;

import com.acgvision.agent.run.Main;
import com.acgvision.agent.run.Task;
import com.acgvision.agent.run.UniqueList;
import com.acgvision.core.ws.AutomaticAction;
import com.acgvision.core.ws.Control;
import com.acgvision.core.ws.Host;
import com.acgvision.core.ws.Measure;
import com.acgvision.core.ws.Monitor;
import com.acgvision.core.ws.User;
import java.net.MalformedURLException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Send {
    private static final Logger logger = Logger.getLogger(Send.class);

    private final String pack = "http://ws.core.acgvision.com/";
    private final String  sName=  "AgentService";
    private QName qName = new QName(pack, sName);
    private java.net.URL urlNameService=null;
    private com.acgvision.core.ws.AgentService service = null;
    private com.acgvision.core.ws.Agent agentPort = null;

public Send(){

}
    public  boolean init(String url){
        try {
            logger.debug("Connect to webservice");
           
           if(logger.isInfoEnabled()) logger.info(url);
            urlNameService=   new java.net.URL(url);
            this.getPort();
//            this.service = new com.acgvision.core.ws.AgentService(
//                 urlNameService,qName);

           if (logger.isInfoEnabled()){
                logger.info("WebService wsdl location : " + this.service.getWSDLDocumentLocation());
                logger.info("WebService Service name : " + this.service.getServiceName().toString());
            }
            return true;
        } catch (MalformedURLException ex) {
          logger.fatal("Error while trying to contact webservice.");
          logger.fatal(ex);
          logger.fatal(ex.getStackTrace().toString());
          return false;
        }

    }

    /**
     * Creates a measure statement and sends  it to the ACGVision server
     * @param measure
     * @return true if the value as correctly been send and no error has occured
     */
    public  boolean sendMeasure(Measure measure) {
        try { // Call Web Service Operation
            com.acgvision.core.ws.Agent port = this.getPort();

          if(logger.isDebugEnabled())  logger.debug("Envoi de la mesure " + measure.getValue() + " pour le moniteur " + measure.getMonitor().getName());
            port.saveMeasure(measure);
            return true;
        } catch (Exception ex) {
             logger.info("An error occured while sending measure for monitor "+measure.getMonitor());
             logger.error(ex);
             return false;
        }
    }
       /**
     * Creates a measure statement and sends  it to the ACGVision server
        * @param measures
     * @return true if the value as correctly been send and no error has occured
     */
    public  boolean sendMeasures(List<Measure> measures) {
        try { // Call Web Service Operation
            com.acgvision.core.ws.Agent port = this.getPort();

          if(logger.isDebugEnabled())  logger.debug("Sending "+ measures.size() +" measures");
            port.saveMeasures(measures);
            return true;
        } catch (Exception ex) {
             logger.error("An error occured while sending measures.",ex);
             return false;
        }
    }
    /**
     * Sends an event to server
     * @param control
     * @param monitor
     * @return true if the event has correctly been send and received
     */
    public  boolean sendEvent(Control control,Monitor monitor){
        try {        
            com.acgvision.core.ws.Agent port = this.getPort();
            // TODO initialize WS operation arguments here
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
          if(logger.isInfoEnabled())  logger.info("Sending event control ="+ control.getName() + " Monitor ="+monitor.getName()+" date="+xmlGC.toGregorianCalendar().getTime() );
            port.riseMonitorEvent(xmlGC,Main.host, control, monitor);

            return true;
        } catch (DatatypeConfigurationException ex) {
         logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
        } catch (Exception ex) {
             logger.error("An Exception occured while sending event.",ex);
          return false;
        }
    }

         /**
     * Sends an event to server
     * @param control
     * @param monitor
          * @param text details of the event
          * @return true if the event has correctly been send and received
     */
    public  boolean sendEvent(Control control,Monitor monitor,String text){
        try {
            com.acgvision.core.ws.Agent port = this.getPort();
            // TODO initialize WS operation arguments here
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
          if(logger.isInfoEnabled())  logger.info("Sending event control ="+ control.getName() + " Monitor ="+monitor.getName()+" date="+xmlGC.toGregorianCalendar().getTime() );
            port.riseMonitorEventWithText(xmlGC,Main.host, control, monitor,text);
            return true;
        } catch (DatatypeConfigurationException ex) {
          logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
                } catch (Exception ex) {
             logger.error("An Exception occured while sending event.",ex);
          return false;
        }
    }
    /**
     * Envoi un évènement au noyau sur l'éxécution d'une action automatique
     * @param control
     * @param monitor
     * @param action
     * @param text
     * @return
     */
    public boolean sendEvent(Control control, Monitor monitor, AutomaticAction action, String text){
                try {
            com.acgvision.core.ws.Agent port = this.getPort();
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
          if(logger.isInfoEnabled())  logger.info("Sending event control ="+ control.getName() + " Monitor ="+monitor.getName()+" Automaticaction"+ action.getName()+"date="+xmlGC.toGregorianCalendar().getTime() );
            //Envoi de l'action automatique
            port.riseAutomaticActionEventWithText(xmlGC, Main.host, control, monitor, action, text);
            return true;
        } catch (DatatypeConfigurationException ex) {
          logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
                } catch (Exception ex) {
             logger.error("An Exception occured while sending event.",ex);
          return false;
                }
    }

    /**
     * Sends an event to server
     * @param control
     * @return true if the event has correctly been send and received
     */
    public  boolean sendEvent(Control control){
        try {            
com.acgvision.core.ws.Agent port = this.getPort();
            // TODO initialize WS operation arguments here
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
          if(logger.isInfoEnabled())  logger.info("Sending event control ="+ control.getName() +" date="+xmlGC.toGregorianCalendar().getTime() );
            port.riseEvent(xmlGC,Main.host, control);
            return true;
        } catch (DatatypeConfigurationException ex) {
          logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
                } catch (Exception ex) {
             logger.error("An Exception occured while closing event.",ex);
          return false;
        }
    }

    /**
     *
     * @param control
     * @param monitor
          * @return true if the value as correctly been send and no error has occured
     */
    public  boolean closeEvent(Control control,Monitor monitor){
        try {            
com.acgvision.core.ws.Agent port = this.getPort();
            // TODO initialize WS operation arguments here
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
           if(logger.isInfoEnabled()) logger.info("Closing event control ="+ control + " Monitor ="+monitor+" date="+xmlGC.toGregorianCalendar().getTime() );
            port.closeMonitorEvent(xmlGC,Main.host, control, monitor);
            return true;
        } catch (DatatypeConfigurationException ex) {
          logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
                } catch (Exception ex) {
             logger.error("An Exception occured while closing event.",ex);
          return false;
        }
    }

   /**
    *
    * @param control
         * @return true if the value as correctly been send and no error has occured
    */
     public  boolean closeEvent(Control control){
        try {
            com.acgvision.core.ws.Agent port = this.getPort();
            // TODO initialize WS operation arguments here
            XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
         if(logger.isInfoEnabled())   logger.info("Closing event control ="+ control +" date="+xmlGC.toGregorianCalendar().getTime() );
            port.closeEvent(xmlGC,Main.host, control);
            return true;
        } catch (DatatypeConfigurationException ex) {
          logger.error("An DatatypeConfigurationException occured while closing event.",ex);
          return false;
        } catch (Exception ex) {
             logger.error("An Exception occured while closing event.",ex);
          return false;
        }
    }

    /**
     * Logs a user using ACGVision core webservice
     * @param user with at least valid email
     * @return logged user or null on failure
     */
    public  User log(User user) {
        try { // Call Web Service Operation      
            com.acgvision.core.ws.Agent port = this.getPort();
            com.acgvision.core.ws.User result = port.log(user);
            if (result == null) {
                logger.error("Error while logging user, user email might not be registered.");
                return null;
            }
            return result;
        } catch (Exception ex) {
            logger.fatal("Error while logging user.");
            logger.fatal(ex.getMessage(),ex);
            logger.fatal(ex.toString());
            logger.fatal(ex.getCause());
            logger.fatal(ex.getCause());
            System.exit(404);//on arrete tout!
            return null;
        }
    }

        public  Host registerHost(Host host) {
        try { // Call Web Service Operation
com.acgvision.core.ws.Agent port = this.getPort();
            Host result = port.register(host);
            return result;
        } catch (Exception ex) {
            logger.fatal("An error occured while registering Host");
            System.exit(404);//on arrete tout!
            return null;
        }
    }

    public  Host getHost(Long id) {
        try { // Call Web Service Operation
com.acgvision.core.ws.Agent port = this.getPort();
            Host result = port.getHost(id);
            return result;
        } catch (Exception ex) {
            logger.fatal("An error occured while getting registered Host");
            logger.fatal(ex);
            System.exit(404);//on arrete tout!
            return null;
        }
    }

    /**
     * Tache de mise à jour des jobs
     * @param host
     * @return
     */public  UniqueList<Task> update(Host host) {
        if (host == null) {
            return null;
        }
        try{
            UniqueList<Task> list = new UniqueList<Task>();
            com.acgvision.core.ws.Jobs jobs;
            // Call Web Service Operation
            com.acgvision.core.ws.Agent port = this.getPort();
            if(logger.isInfoEnabled()) logger.info("Getting hosts'jobs");
            jobs = port.getJobs(host);
            if(jobs==null) return new UniqueList<Task>();
            if(logger.isInfoEnabled()) logger.info("add jobs");
            list.addUnique(jobs);
            return list;
        } catch (Exception ex) {
            logger.error("Error while updating host jobs.", ex);
            logger.error(ex);
            return null;
        }
     
    }

    private com.acgvision.core.ws.Agent getPort() {
            if (urlNameService != null) {
                try {
                    //Essais de connection
                    service = new com.acgvision.core.ws.AgentService(urlNameService, qName);

                } catch (javax.xml.ws.WebServiceException ex) {

                    logger.error("Error while connecting to WSDL.", ex);
                    service = this.ConnectOnError();
                }
                this.setPort( service.getAgentPort());
                return this.agentPort;
            } else {
                throw new java.lang.NullPointerException();
            }
    }

    private void setPort(com.acgvision.core.ws.Agent agentPort){
          this.agentPort = agentPort;
    }



    /**
     * On entre en mode dégradé. La connection n'a pas fonctionné, le noyau est indisponible.
     * On réssaye dans X seconds
     * Ce temps est allongé à chaque occurence pour espacer les tentatives
     * Permet à l'agent d'etre démarré même si le core est indispo
     * @return
     */
    private com.acgvision.core.ws.AgentService ConnectOnError() {
        logger.error("Error while connected to server, entering on waiting connection system");
        int WHEN = 30;
        final double DERIV = 1.1;
        com.acgvision.core.ws.AgentService result = null;
        while (result == null) {
            try {
                Thread.sleep((long) (WHEN * 1000));
                result = new com.acgvision.core.ws.AgentService(urlNameService, qName);
            } catch (javax.xml.ws.WebServiceException ex) {
                WHEN = (int) ((double) WHEN * DERIV) ;
                logger.error("Trying to reconnect in "+WHEN +"seconds");
                if (logger.isInfoEnabled())logger.info(ex,ex);
            } catch (InterruptedException ex1) {
                logger.error(ex1);
            }
        }
        return result;
    }



}
