/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.action;

import com.acgvision.core.ws.Measure;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Iterator;
import org.apache.log4j.Logger;


/**
 * Stores measure before sending
 * Handles communications failures while sending and tries again later
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class MeasureSpooler {

    private List<Measure> measures = new ArrayList<Measure>();
    private long nextTimeToSend = 0;
    private long sendingFrequence = 0;
    private static Send sender = null;
    private static final Logger logger = Logger.getLogger(MeasureSpooler.class);
    private static boolean sending = false;

    public MeasureSpooler(Send s) {
        if (s == null) {
            throw new java.lang.NullPointerException("Sender cannot be null.");
        }
        sender = s;
    }

    /**
     * Sends measures to core
     */
    public void send() {
        Date date = new Date();
       // logger.info(  " if("+this.nextTimeToSend+"<"+date.getTime()+"){");
        logger.debug("Ask for sending measures");
      
        if(this.nextTimeToSend<date.getTime() & !MeasureSpooler.sending){
            MeasureSpooler.sending=true;
            this.generateNextTimeToSend();
            if (this.getMeasures() != null && !this.getMeasures().isEmpty()) {

                logger.info("Sending measures");
                if(MeasureSpooler.sender.sendMeasures(measures)){
                    this.measures.clear();                    
                }   else {
                        logger.error("An error occured while sending Measures.");
                    }

                this.generateNextTimeToSend();
                  MeasureSpooler.sending=false;
            }
        }
    }

    /**
     * Adds a measure to spooler
     * @param m measure to add
     */
    public void add(Measure m) {
        if (m != null) {
            measures.add(m);
        }
    }

    /**
     * @return the measures
     */
    private List<Measure> getMeasures() {
        return measures;
    }

    /**
     * @return the nextTimeToSend
     */
    public long getNextTimeToSend() {
        return nextTimeToSend;
    }

    /**
     * @param nextTimeToSend the nextTimeToSend to set
     */
    public void setNextTimeToSend(long nextTimeToSend) {
        this.nextTimeToSend = nextTimeToSend;
    }

    /**
     * @return the sender
     */
    public Send getSender() {
        return sender;
    }

    /**
     * @param sender the sender to set
     */
    public void setSender(Send sender) {
        MeasureSpooler.sender = sender;
    }

    /**
     * @return the sendingFrequence
     */
    public long getSendingFrequence() {
        return sendingFrequence;
    }

    /**
     * @param sendingFrequence the sendingFrequence to set
     */
    public void setSendingFrequence(long sendingFrequence) {
        this.sendingFrequence = sendingFrequence;
    }

    /**
     * Generates next time to send values
     */
    public void generateNextTimeToSend() {
        Date date = new Date();
        this.setNextTimeToSend(date.getTime() + this.getSendingFrequence());
    }
}
