/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.action;


import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class HostActions {

   // private static final Logger logger = Logger.getLogger(HostActions.class);

    public static List<String> getIp() throws SocketException {
        List<String> ip = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        NetworkInterface it;
        Enumeration<InetAddress> adresses;
        InetAddress adresse;
        while (interfaces.hasMoreElements()) {
            it = interfaces.nextElement();
            adresses = it.getInetAddresses();
            while (adresses.hasMoreElements()) {
                adresse = adresses.nextElement();
                if (!adresse.isLoopbackAddress() && adresse.getHostAddress().toString().length() < 16) {
                    ip.add(adresse.getHostAddress().toString());
                }
            }
        }
        return ip;
    }

    public static String getFirstIp() throws SocketException {
        List<String> ip = getIp();
        if (ip.isEmpty()) {
            return null;
        }
        return ip.get(0);
    }

    /**
     * Gest the computer hostname
     * @return Local Hostname.
     * @throws UnknownHostException 
     */
    public static String getHostname() throws UnknownHostException {
        return new String(InetAddress.getLocalHost().getHostName());
    }

    /**
     * Gets the computer Operating system name
     * @return Opertaing system Name
     */
    public static String getOsName() {
        return System.getProperty("os.name");
    }

    /**
     * Gets the computer Operating system version
     * @return Opertaing system Version
     */
    public static String getOsVersion() {
        return System.getProperty("os.version");
    }


}
