
//=============================================================================
/**
 *  @file    root_si.cpp
 *
 *  $Id: root_si.cpp 88829 2010-02-04 09:21:38Z johnnyw $
 *
 *  Visitor generating code for the Root in the server inline file
 *
 *
 *  @author Aniruddha Gokhale
 */
//=============================================================================


// ***********************************************
// Root visitor for server inline
// ***********************************************

be_visitor_root_si::be_visitor_root_si (be_visitor_context *ctx)
  : be_visitor_root (ctx)
{
}

be_visitor_root_si::~be_visitor_root_si (void)
{
}

int
be_visitor_root_si::init (void)
{
  // first open the file for writing
  if (tao_cg->start_server_inline (be_global->be_get_server_inline_fname ())
        == -1)
    {
      ACE_ERROR_RETURN ((LM_ERROR,
                         "(%N:%l) be_visitor_root_si::init - "
                         "server inline open failed\n"),
                        -1);
    }

  // init stream
  this->ctx_->stream (tao_cg->server_inline ());
  return 0;
}
