// -*- C++ -*-

//=============================================================================
/**
 *  @file   QtResource_Factory.h
 *
 *  QtResource_Factory.h,v 1.3 2005/05/26 09:22:05 jwillemsen Exp
 *
 *  @author Balachandran Natarajan <bala@dre.vanderbilt.edu>
 *  @author Marek Brudka <mbrudka@aster.pl>
 */
//=============================================================================
#ifndef TAO_QTRESOURCE_FACTORY_H
#define TAO_QTRESOURCE_FACTORY_H
#include /**/ "ace/pre.h"

#include "tao/TAO_QtResource_Export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include <qapplication.h>
#include "ace/QtReactor.h"
#include "tao/GUIResource_Factory.h"

namespace TAO
{

  /**
   * @class QtResource_Factory
   *
   * @brief TAO_GUI_Resource_Factory for creating QtReactor.
   *
   * This factory is intended for creating QtReactor for ORB. This
   * factory can be feed into ORB using
   * TAO_ORB_Core::set_gui_resource_factory method which is usually
   * done by TAO_QtResource_Loader.
   */
  class TAO_QtResource_Export QtResource_Factory : public GUIResource_Factory
  {
  public:

    QtResource_Factory (QApplication *qapp_);

  protected:

    /// Create or obtain current reactor implementation
    virtual ACE_Reactor_Impl *reactor_impl (void);

  private:

    /// Reactor created by this factory.
    ACE_QtReactor *reactor_impl_;

    /// QApplication running reactor
    QApplication *qapp_;

    /// For internal locking.
    TAO_SYNCH_MUTEX lock_;
  };
}

#include /**/ "ace/post.h"
#endif /* TAO_QTRESOURCE_FACTORY_H */
