
      //==============================================================
/**
 *  @file  IRDD_Handler.h
 *
 *  IRDD_Handler.h,v 1.3 2005/03/19 22:22:21 jai Exp
 *
 *  @author Jules White <jules@dre.vanderbilt.edu>
 */
//================================================================

#ifndef CIAO_CONFIG_HANDLERS_IRDD_Handler_H
#define CIAO_CONFIG_HANDLERS_IRDD_Handler_H
#include /**/ "ace/pre.h"

#include "Config_Handlers/Config_Handlers_Export.h"
#include "ace/config-lite.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */



namespace Deployment
{
  class InstanceResourceDeploymentDescription;
}


namespace CIAO
{

  namespace Config_Handlers
  {

   class InstanceResourceDeploymentDescription;


   /*
    * @class IRDD_Handler
    *
    * @brief Handler class for <InstanceResourceDeploymentDescription> types.
    *
    * This class defines handler methods to map values from
    * XSC InstanceResourceDeploymentDescription objects, parsed from the descriptor files, to the
    * corresponding CORBA IDL Any type.
    *
    */
    
    class Config_Handlers_Export IRDD_Handler {
     
      public:

        IRDD_Handler (void);
        virtual ~IRDD_Handler (void);

        static void instance_resource_deployment_descr (
             const InstanceResourceDeploymentDescription& desc,
             Deployment::InstanceResourceDeploymentDescription& toconfig);
        
        static InstanceResourceDeploymentDescription
        instance_resource_deployment_descr (
          const Deployment::InstanceResourceDeploymentDescription& src);

    };
  }
}

#include /**/ "ace/post.h" 
#endif /* CIAO_CONFIG_HANDLERS_IRDD_Handler_H */

