/*
 * Copyright (C) 2011, Broadcom Corporation. All Rights Reserved.
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Fundamental types and constants relating to 802.1D
 *
 * $Id: 802.1d.h 241182 2011-02-17 21:50:03Z $
 */

#ifndef _802_1_D_
#define _802_1_D_

#define	PRIO_8021D_NONE		2	
#define	PRIO_8021D_BK		1	
#define	PRIO_8021D_BE		0	
#define	PRIO_8021D_EE		3	
#define	PRIO_8021D_CL		4	
#define	PRIO_8021D_VI		5	
#define	PRIO_8021D_VO		6	
#define	PRIO_8021D_NC		7	
#define	MAXPRIO			7	
#define NUMPRIO			(MAXPRIO + 1)

#define ALLPRIO		-1	

#define PRIO2PREC(prio) \
	(((prio) == PRIO_8021D_NONE || (prio) == PRIO_8021D_BE) ? ((prio^2)) : (prio))

#endif 
