/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */


#include "ui_local.h"

static menuframework_s s_tutorials_menu;


static void Demo01Introduction( menucommon_t *unused )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "demo tutorials/01_introduction" );
}

static void Demo02Bunnyjumping( menucommon_t *unused )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "demo tutorials/02_bunnyjumping" );
}

static void M_TutorialsInit( void )
{
	int yoffset = 0;
	menucommon_t *menuitem;

	s_tutorials_menu.nitems = 0;

	menuitem = UI_InitMenuItem( "m_tutorials_title1", "WELCOME TO WARSOW TUTORIALS", 0, yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_tutorials_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_tutorials_01", "01 Introduction", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, Demo01Introduction );
	Menu_AddItem( &s_tutorials_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_tutorials_02", "02 Bunny jumping", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, Demo02Bunnyjumping );
	Menu_AddItem( &s_tutorials_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );



	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_tutorials_back", "back", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_genericBackFunc );
	Menu_AddItem( &s_tutorials_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Center( &s_tutorials_menu );
	Menu_Init( &s_tutorials_menu );
	Menu_SetStatusBar( &s_tutorials_menu, NULL );
}


static void M_Tutorials_Draw( void )
{
	Menu_AdjustCursor( &s_tutorials_menu, 1 );
	Menu_Draw( &s_tutorials_menu );
}

static const char *M_Tutorials_Key( int key )
{
	return Default_MenuKey( &s_tutorials_menu, key );
}

static const char *M_Tutorials_CharEvent( qwchar key )
{
	return Default_MenuCharEvent( &s_tutorials_menu, key );
}

void M_Menu_Tutorials_f( void )
{
	M_TutorialsInit();
	M_PushMenu( &s_tutorials_menu, M_Tutorials_Draw, M_Tutorials_Key, M_Tutorials_CharEvent );
}
